function s_GlobalAlign_v6(si,Ch,SIv)
% general note: the distV vector was calculated using an ellipsoid fit to
% an eroded stack of newScale szie relative to unity aspect ratio stacks.
% in contrast, the RegArray coordinates are from the full scale stacks.
% the registration will be carried out with scaled down stacks and the RegArray
% coordinates will be scaled appropriately. previous experience suggests a
% simple multiplication with the scaling factor is sufficient.
RegArray = wk1read([si.txt 'RegArray.wk1']);
FijiXform = dlmread([si.txt 'FijiXform.txt']);
anchorIdx = SIv.anchorIdx;

% directory. reading the previously scaled stacks
if strcmp(Ch,'G')
    dirName = si.scaG; 
else
    dirName = si.scaR;   
end
stackDir  = dir(cat(2,dirName,'*.tif'));
numStacks  = size(stackDir,1);

% instead of making the voi mask a sphere, i will make it a prolate
% ellipsoid to restrict the registration search. 
voiD = round(72/SIv.xyRes); % set to be 72 um.
voiZ = round(15/SIv.xyRes); % set to be 15 um. used to be 30
fs = 10; % fontsize;
txtXoffset = 4;
if anchorIdx==0
    voiD = round(36/SIv.xyRes); % set to be 36 um.
    voiZ = round(15/SIv.xyRes); % set to be 15 um.
    fs = 9;
    txtXoffset = 3;
    anchorIdx = 1;
end

% dSteps is the number of decay steps at the periphery of the ellipsoid.
dSteps = 2;
% dLength is the decay length, as a fraction of voiD.
dLength = 0.1;
% construct ellipsoid voi mask
% determine the size of the sub master mask
radMaskXY = round(0.5*voiD + dSteps*dLength*voiD);
radMaskZ = round(0.5*voiZ + dSteps*dLength*voiZ);

subDimXY = 2*radMaskXY+1; subDimZ = 2*radMaskZ+1;
subMask = zeros(subDimXY,subDimXY,subDimZ);
for r1 = 1:subDimXY
    for c1 = 1:subDimXY
        for z1 = 1:subDimZ
           for d1 = (dSteps+1):-1:1
                yStep = 0.5*voiD + (d1-1)*dLength*voiD;
                xStep = 0.5*voiD + (d1-1)*dLength*voiD;
                zStep = 0.5*voiZ + (d1-1)*dLength*voiZ;
                val = ((1/yStep)*(r1-0.5*subDimXY))^2+((1/xStep)*(c1-0.5*subDimXY))^2+((1/zStep)*(z1-0.5*subDimZ))^2;
                if val <= 1
                    subMask(r1,c1,z1) = 1/(2^(d1-1));
                end
            end
        end
    end
end
maskSigma = 0.25*dLength*voiD;
subMask = imgaussian(im2double(subMask),maskSigma,6*maskSigma);

distV = dlmread([si.txt 'DistV.txt'],'\t');
horiV = [1; 0; -1*distV(1)/distV(3)];
horiV = horiV./norm(horiV);
% construct vertical vector in the square reference frame using the
% cross product of the distal and horizontal vectors.
vertV = cross(horiV,distV);
vertV = vertV./norm(vertV);
rotMat0 = eye(4); rotMat0(1:3,1:3) = [horiV vertV -distV];

% the vectors bring the array to the square orientation but not the desired
% z orientation. this is read from the output of suite_TurnAngles_v4 and
% included in the final rotation matrix
zdegFiji = dlmread([si.txt 'TurnAngles.txt'],'\t',1,0,[1 0 1 0]);
zRotFiji = make_transformation_matrix([0 0 0],[0 0 zdegFiji],[1 1 1],[]);

rotMatI = zRotFiji*inv(rotMat0);

voiZXY = RegArray;
voiZXY(:,1) = [];
voiZXY(:,2:3) = [];

% the following code builds the xyz track of the sub stacks
xyFr = 8;
trekDim = subDimZ-2*xyFr;
xyTrek = zeros(trekDim, trekDim, numStacks);
zTrek = zeros(trekDim, 4, numStacks);
xyDisp = zeros(numStacks,1); zDisp = xyDisp; rDisp = xyDisp;
minX = min(voiZXY(:,2)); minY = min(voiZXY(:,3)); minZ = min(voiZXY(:,1));
coefXY = (0.1)^(1/(numStacks-1)); coefZ = (0.0001)^(1/(numStacks-1));
annoStk = zeros(trekDim, trekDim, numStacks);

hf = figure;
imshow(xyTrek(:,:,1),[]);
set(gca,'units','pixels');
pos = get(gca,'position');
image(zeros(trekDim,trekDim));
set(gca,'units','pixels','position',pos,'visible','off');

for j2 = 1:numStacks
    xj2 = voiZXY(j2,2)-minX+1; tX = rem(xj2,trekDim); if tX==0; tX=trekDim; end
    yj2 = voiZXY(j2,3)-minY+1; tY = rem(yj2,trekDim); if tY==0; tY=trekDim; end
    zj2 = voiZXY(j2,1)-minZ+1; tZ = rem(zj2,trekDim); if tZ==0; tZ=trekDim; end
    if j2 == 1; x1 = xj2; y1 = yj2; z1 = zj2; end
    xyDisp(j2) = SIv.xyRes*norm([xj2-x1;yj2-y1]);
    zDisp(j2) = SIv.xyRes*(zj2-z1); 
    rDisp(j2) = SIv.xyRes*norm([xj2-x1;yj2-y1;zj2-z1]);
    ht1 = text('units','pixels','color','w',...
              'position',[trekDim+txtXoffset 22],'horizontalalignment','right','verticalalignment','bottom',...
              'rotation',0,'fontsize',fs,'string',cat(2,'xy disp = ',num2str(xyDisp(j2),'%03.0f'),'um'));
    ht2 = text('units','pixels','color','w',...
              'position',[trekDim+txtXoffset 12],'horizontalalignment','right','verticalalignment','bottom',...
              'rotation',0,'fontsize',fs,'string',cat(2,'z disp = ',num2str(zDisp(j2),'%03.0f'),'um'));
    ht3 = text('units','pixels','color','w',...
              'position',[trekDim+txtXoffset 2],'horizontalalignment','right','verticalalignment','bottom',...
              'rotation',0,'fontsize',fs,'string',cat(2,'r disp = ',num2str(rDisp(j2),'%03.0f'),'um'));
    pause(0.05);
    tim = getframe(gca); tim2 = tim.cdata; tim2 = tim2(1:trekDim,1:trekDim,1);
    kText = find(tim2(:));
    annoSlc = zeros(trekDim, trekDim); annoSlc(kText) = 1;
    annoStk(:,:,j2) = annoSlc;
    
    delete(ht1,ht2,ht3); 
    
    xyTrek(tY,tX,j2) = 1;
    zTrek(tZ,:,j2) = 1;
    if j2 > 1
        xyTrek(:,:,j2) = xyTrek(:,:,j2) + coefXY*xyTrek(:,:,j2-1);
        zTrek(:,:,j2) = zTrek(:,:,j2) + coefZ*zTrek(:,:,j2-1);
    end
end
close(hf);
xyTrek = xyTrek + annoStk;
xyzTrek = [0.2*ones(trekDim,2,numStacks)...
           zTrek...
           0.2*ones(trekDim,2,numStacks)...
           xyTrek...
           0.2*ones(trekDim,xyFr,numStacks)];
xyzTrek = [0.2*ones(xyFr,subDimZ,numStacks); xyzTrek; 0.2*ones(xyFr,subDimZ,numStacks)];
% track building complete

% read the anchor stack to get dimension information and construct the
% starting static voi stack.
[fulStruct, sizZ] = tiffread2([dirName stackDir(anchorIdx).name]);
sizX = fulStruct(1).width; sizY = fulStruct(1).height;
fulStk = zeros(sizY, sizX, sizZ,'single');
for i0 = 1:sizZ
    fulStk(:,:,i0) = single(fulStruct(i0).data);
end
fulSize = [sizX; sizY; sizZ];
% need to transform the origin of the voi ellipsoid to the squared
% coordinates.
oriXYZ = [voiZXY(anchorIdx,2); voiZXY(anchorIdx,3); voiZXY(anchorIdx,1)];

anchorStack0 = extractROI_3D(oriXYZ,[radMaskXY; radMaskXY; radMaskXY],fulStk);
anchorStack1 = affine_transform(anchorStack0,Fiji2Kroon(rotMatI));
anchorStack = anchorStack1(:,:,radMaskXY+1-radMaskZ:radMaskXY+1+radMaskZ);
anchorStack = subMask.*anchorStack;

% the cartesian center of an image with pixel boundaries Pi and Pf is
% 0.5*(Pf+Pi-1). i decided that this was the case.
voiCent = 0.5*(2*oriXYZ-1);
t_rev = eye(4); t_for = eye(4); 
t_rev(1:3,4) = (voiCent)-0.5*(fulSize);
t_for(1:3,4) = -1*((voiCent)-0.5*(fulSize));

% initialize the output variable, which will hold all the transformation
% matrices, concatanated along the row dimension.

MOneSeries = zeros(4,4,numStacks); MOneSeries(:,:,anchorIdx) = eye(4);
%MRunSeries = zeros(4,4,numStacks); MRunSeries(:,:,1) = eye(4);

% initialize the options structure for the volume registration.
Options = struct('Similarity',[],'Registration','Rigid',...
                 'Penalty',1e-5,'MaxRef',2,'Grid',[],...
                 'Spacing',[],'MaskMoving',[],'MaskStatic',[],...
                 'Verbose',0,'Points1',[],'Points2',[],...
                 'PStrength',[],'Interpolation','Linear','Scaling',[1 1 1]);

% output variables
zmipStkRaw = zeros(subDimXY,subDimXY,numStacks,'single');
zmipStkRaw(:,:,anchorIdx) = max(anchorStack,[],3);
zmipStkReg = zmipStkRaw;

xmipStkRaw = zeros(subDimZ,subDimXY,numStacks,'single');
xmipStkRaw(:,:,anchorIdx) = zMIP_v1(rot90_3D(anchorStack,2,3),1,subDimXY);
xmipStkReg = xmipStkRaw;

ymipStkRaw = zeros(subDimXY,subDimZ,numStacks,'single');
ymipStkRaw(:,:,anchorIdx) = zMIP_v1(rot90_3D(anchorStack,1,3),1,subDimXY);
ymipStkReg = ymipStkRaw;


corrVals = zeros(numStacks,3);
corrVals(anchorIdx,:) = [anchorIdx 1 1];

statStack = anchorStack;
for j1 = anchorIdx+1:numStacks 
    stkName = stackDir(j1).name;
    stkIdx = str2double(stkName(regexp(stkName,'\d')));
    disp(cat(2,'loop count = ',num2str(j1), ', stk idx = ',num2str(stkIdx)));
    
    [fulStruct, ~] = tiffread2([dirName stkName]);
    fulStk(:) = 0;
    for i0 = 1:sizZ
        fulStk(:,:,i0) = single(fulStruct(i0).data);
    end
    
    M_stat = MOneSeries(:,:,j1-1);
    
    dynaOriXYZ = [voiZXY(j1,2); voiZXY(j1,3); voiZXY(j1,1)];
    dynaStack0 = extractROI_3D(dynaOriXYZ,[radMaskXY; radMaskXY; radMaskXY],fulStk);
    dynaStack1 = affine_transform(dynaStack0,Fiji2Kroon(Kroon2Fiji(M_stat)*rotMatI));
    dynaStack = dynaStack1(:,:,radMaskXY+1-radMaskZ:radMaskXY+1+radMaskZ);
    dynaStack = subMask.*dynaStack;
   
    %[regiStack,~,~,M] = register_volumes(dynaStack,statStack,Options);
    [regiStack,~,~,M] = register_volumes((imgaussian(dynaStack,1)),round(imgaussian(round(statStack),1)),Options);
    
    % since i'm prepping each dyna stack with the transformation matrix of
    % the prior registration step, the mipDyna does not reflect the
    % original substack. i'll devote some processing time for now to
    % accurately capture the raw dyna mip.
    tempStk = affine_transform(dynaStack0,Fiji2Kroon(rotMatI));
    tempStk = tempStk(:,:,radMaskXY+1-radMaskZ:radMaskXY+1+radMaskZ);
    tempStk = subMask.*tempStk;
    % recording to output variables
    zmipStkRaw(:,:,j1) = max(tempStk,[],3);
    zmipStkReg(:,:,j1) = max(regiStack,[],3);
    xmipStkRaw(:,:,j1) = zMIP_v1(rot90_3D(tempStk,2,3),1,subDimXY);
    xmipStkReg(:,:,j1) = zMIP_v1(rot90_3D(regiStack,2,3),1,subDimXY);
    ymipStkRaw(:,:,j1) = zMIP_v1(rot90_3D(tempStk,1,3),1,subDimXY);
    ymipStkReg(:,:,j1) = zMIP_v1(rot90_3D(regiStack,1,3),1,subDimXY);
    % my rule is: never multiply kroon matrices.
    M_dyna = Fiji2Kroon(Kroon2Fiji(M)*Kroon2Fiji(M_stat))
    
    mipStat = max(statStack,[],3); mipDyna = zmipStkRaw(:,:,j1); mipRegi = zmipStkReg(:,:,j1);
    C1 = normxcorr2(mipDyna(11:end-10,11:end-10), mipStat);
    C2 = normxcorr2(mipRegi(11:end-10,11:end-10), mipStat);
    disp(cat(2,'pre-reg max corr = ',num2str(max(abs(C1(:)))),', post-reg max corr = ',num2str(max(abs(C2(:))))));
    corrVals(j1,:) = [j1 max(abs(C1(:))) max(abs(C2(:)))];
    
    if floor(10000*max(abs(C1(:)))) > floor(10000*max(abs(C2(:))))
        disp('setting M to identity...');
        M = eye(4);
        M_dyna = Fiji2Kroon(Kroon2Fiji(M)*Kroon2Fiji(M_stat));
    end
    
    MOneSeries(:,:,j1) = M_dyna;
    
    t_shift = eye(4);
    t_shift(1:3,4) = oriXYZ-dynaOriXYZ;
    XFullFiji = FijiXform*t_rev*inv(rotMatI)*Kroon2Fiji(M_dyna)*rotMatI*t_for*t_shift;
    
    dlmwrite([si.mGlo 'XFullFiji' num2str(stkIdx,'%03.0f') '.txt'],XFullFiji,'\t');
    
    statStack1 = affine_transform(dynaStack0,Fiji2Kroon(Kroon2Fiji(M_dyna)*rotMatI));
    statStack = statStack1(:,:,radMaskXY+1-radMaskZ:radMaskXY+1+radMaskZ);
    statStack = subMask.*statStack;
    imshow(zmipStkReg(:,:,j1),[]);
    pause(0.05);
end

statStack = anchorStack;
for j1 = anchorIdx-1:-1:1
    stkName = stackDir(j1).name;
    stkIdx = str2double(stkName(regexp(stkName,'\d')));
    disp(cat(2,'loop count = ',num2str(j1), ', stk idx = ',num2str(stkIdx)));
    
    [fulStruct, ~] = tiffread2([dirName stkName]);
    fulStk(:) = 0;
    for i0 = 1:sizZ
        fulStk(:,:,i0) = single(fulStruct(i0).data);
    end
    
    M_stat = MOneSeries(:,:,j1+1);

    dynaOriXYZ = [voiZXY(j1,2); voiZXY(j1,3); voiZXY(j1,1)];
    dynaStack0 = extractROI_3D(dynaOriXYZ,[radMaskXY; radMaskXY; radMaskXY],fulStk);
    dynaStack1 = affine_transform(dynaStack0,Fiji2Kroon(Kroon2Fiji(M_stat)*rotMatI));
    dynaStack = dynaStack1(:,:,radMaskXY+1-radMaskZ:radMaskXY+1+radMaskZ);
    dynaStack = subMask.*dynaStack;
    
    %[regiStack,~,~,M] = register_volumes(dynaStack,statStack,Options);
    [regiStack,~,~,M] = register_volumes((imgaussian(dynaStack,1)),round(imgaussian(round(statStack),1)),Options);
    
    % since i'm prepping each dyna stack with the transformation matrix of
    % the prior registration step, the mipDyna does not reflect the
    % original substack. i'll devote some processing time for now to
    % accurately capture the raw dyna mip.
    tempStk = affine_transform(dynaStack0,Fiji2Kroon(rotMatI));
    tempStk = tempStk(:,:,radMaskXY+1-radMaskZ:radMaskXY+1+radMaskZ);
    tempStk = subMask.*tempStk;
    % recording to output variables
    zmipStkRaw(:,:,j1) = max(tempStk,[],3);
    zmipStkReg(:,:,j1) = max(regiStack,[],3);
    xmipStkRaw(:,:,j1) = zMIP_v1(rot90_3D(tempStk,2,3),1,subDimXY);
    xmipStkReg(:,:,j1) = zMIP_v1(rot90_3D(regiStack,2,3),1,subDimXY);
    ymipStkRaw(:,:,j1) = zMIP_v1(rot90_3D(tempStk,1,3),1,subDimXY);
    ymipStkReg(:,:,j1) = zMIP_v1(rot90_3D(regiStack,1,3),1,subDimXY);
    % my rule is: never multiply kroon matrices.
    M_dyna = Fiji2Kroon(Kroon2Fiji(M)*Kroon2Fiji(M_stat))
    
    mipStat = max(statStack,[],3); mipDyna = zmipStkRaw(:,:,j1); mipRegi = zmipStkReg(:,:,j1);
    C1 = normxcorr2(mipDyna(11:end-10,11:end-10), mipStat);
    C2 = normxcorr2(mipRegi(11:end-10,11:end-10), mipStat);
    disp(cat(2,'pre-reg max corr = ',num2str(max(abs(C1(:)))),', post-reg max corr = ',num2str(max(abs(C2(:))))));
    corrVals(j1,:) = [j1 max(abs(C1(:))) max(abs(C2(:)))];
    
    if floor(10000*max(abs(C1(:)))) > floor(10000*max(abs(C2(:))))
        disp('setting M to identity...');
        M = eye(4);
        M_dyna = Fiji2Kroon(Kroon2Fiji(M)*Kroon2Fiji(M_stat));
    end
 
    MOneSeries(:,:,j1) = M_dyna;
    
    t_shift = eye(4);
    t_shift(1:3,4) = oriXYZ-dynaOriXYZ;
    XFullFiji = FijiXform*t_rev*inv(rotMatI)*Kroon2Fiji(M_dyna)*rotMatI*t_for*t_shift;

    dlmwrite([si.mGlo 'XFullFiji' num2str(stkIdx,'%03.0f') '.txt'],XFullFiji,'\t');

    statStack1 = affine_transform(dynaStack0,Fiji2Kroon(Kroon2Fiji(M_dyna)*rotMatI));
    statStack = statStack1(:,:,radMaskXY+1-radMaskZ:radMaskXY+1+radMaskZ);
    statStack = subMask.*statStack;
    
    imshow(zmipStkReg(:,:,j1),[]);
    pause(0.05);
end


MOneSeriesLong = zeros(4*numStacks,4);
for j2 = 1:numStacks
    MOneSeriesLong(1+4*(j2-1):4*j2,:) = MOneSeries(:,:,j2);
end
XFullFiji = FijiXform;
stkName = stackDir(anchorIdx).name;
stkIdx = str2double(stkName(regexp(stkName,'\d')));
dlmwrite([si.mGlo 'XFullFiji' num2str(stkIdx,'%03.0f') '.txt'],XFullFiji,'\t');
dlmwrite([si.txt 'MOneSeries.txt'],MOneSeriesLong,'\t');
dlmwrite([si.txt 'GlobalCorrVals.txt'],corrVals,'\t');

% saving output images
for j0 = 1:numStacks
    zRaw = uint16(zmipStkRaw(:,:,j0)); xRaw = uint16(xmipStkRaw(:,:,j0)); yRaw = uint16(ymipStkRaw(:,:,j0));
    zRaw = imadjust(zRaw,stretchlim(zRaw,0),[0 1]);
    xRaw = imadjust(xRaw,stretchlim(xRaw,0),[0 1]);
    yRaw = imadjust(yRaw,stretchlim(yRaw,0),[0 1]);
    topRaw = [zRaw 0.4*(2^16-1)*ones(subDimXY,4,'uint16') yRaw];
    botRaw = [xRaw 0.4*(2^16-1)*ones(subDimZ,4,'uint16') im2uint16(xyzTrek(:,:,j0))];
    slcRaw = [topRaw; 0.4*(2^16-1)*ones(4,subDimXY+4+subDimZ,'uint16'); botRaw];
    
    zReg = uint16(zmipStkReg(:,:,j0)); xReg = uint16(xmipStkReg(:,:,j0)); yReg = uint16(ymipStkReg(:,:,j0));
    zReg = imadjust(zReg,stretchlim(zReg,0),[0 1]);
    xReg = imadjust(xReg,stretchlim(xReg,0),[0 1]);
    yReg = imadjust(yReg,stretchlim(yReg,0),[0 1]);
    topReg = [zReg 0.4*(2^16-1)*ones(subDimXY,4,'uint16') yReg];
    botReg = [xReg 0.4*(2^16-1)*ones(subDimZ,4,'uint16') im2uint16(xyzTrek(:,:,j0))];
    slcReg = [topReg; 0.4*(2^16-1)*ones(4,subDimXY+4+subDimZ,'uint16'); botReg];
    
    imwrite(uint16(slcRaw),[si.img 'mipGloRaw_preFx.tif'],...
                                     'tiff','Compression','none','WriteMode','append');
    imwrite(uint16(slcReg),[si.img 'mipGloReg_preFx.tif'],...
                                     'tiff','Compression','none','WriteMode','append');
end












