function s_PlotGCExtension_v10(si,Ch,SIv,label)
% to be used with AlignGCs_v6 and later

% this version recovers the original orientation of the individual growth
% cone by transforming the standard view GCs back to the raw view and
% performs the segmentation on these. takes a long time to process. one
% innovation here was to exlude the cuts in the watershed segmentation that
% coincide with the skel mask. this seems to preserve the integrity o fthe
% central growth cone mask well while still separating this form neighboring
% areas. will implement this in the earlier version of this script.

% label can be 0, 1 or 2.

% _v10 uses a more stringent filter of median pVal >=0.6 after 50hAPF to
% select best GCs.
%%
% directory. needed to define numStacks
if strcmp(Ch,'G')
    scaDir = si.scaG;
    locDir = si.mLocG;
    flg = 'G';
else
    scaDir = si.scaR;
    locDir = si.mLocR;
    flg = 'R';
end
scaList  = dir(cat(2,scaDir,'*.tif'));

hrsAPF = dlmread([si.txt 'hrsAPF.txt']);

[~,idx50_0] = min(abs(hrsAPF-50)); % what is the 50 hAFP stack idx?

if isempty(SIv.trakSpan)
    startIdx = 1; numStacks = numel(scaList);
    idx50 = idx50_0;
else
    startIdx = SIv.trakSpan(1); stopIdx = SIv.trakSpan(2);
    numStacks = stopIdx-startIdx+1;
    idx50 = idx50_0-SIv.trakSpan(1)+1;
end

if label==1
    flgL = '_Label1';
elseif label==2
    flgL = '_Label2';
else
    flgL = [];
end

% shift seedIdx as needed
skelMIPIdx = SIv.skelMIPIdx-startIdx+1;

% following needed for sca and reg space mapping
% reading seed stack and recording full stack dimensions
tempH = TIFFStack([scaDir scaList(skelMIPIdx).name]);
[scaY scaX scaZ ~] = size(tempH);
clear tempH
regDims = s_readFijiXformLims_v2(si);
regX = regDims.xBot-regDims.xTop+1; % regXYZ are the post-crop dimensions of the registered stacks
regY = regDims.yBot-regDims.yTop+1;
regZ = regDims.zBot-regDims.zTop+1;
M_t1 = eye(4); M_t1(1:3,4) = -1*0.5*[regDims.regX; regDims.regY; regDims.regZ]; % the translation matrix uses the embedded dimensions of the registered stacks;
M_t1rev = eye(4); M_t1rev(1:3,4) = 0.5*[regDims.regX; regDims.regY; regDims.regZ];
M_t2 = eye(4); M_t2(1:3,4) = 0.5*[scaX; scaY; scaZ];
M_t2rev = eye(4); M_t2rev(1:3,4) = -1*0.5*[scaX; scaY; scaZ];

% number of timepoints to be averaged to define the bottom of the growth
% cones. limit is 40 hrs APF

tLim = numel(find(find(hrsAPF<=40)>=startIdx));
if tLim ==0; tLim = 5; end % catch, in case trakSpan or the data series starts after 40 hrs APF.

% read the gc center coordinates in sca space. find the 0 valued
% coordinates to identify gcs rejected during alignement.
gcStkH = TIFFStack([si.img 'centGCsca-' flg flgL '.tif']);
centGCsca = single(gcStkH(:,:,:)); clear gcStkH;
kGud0 = find(sum(logical(squeeze(centGCsca(:,1,:))),2)==numStacks);
% read the projection values relative to vertical
projVal = real(dlmread([si.txt 'projVal' flgL '.txt'],'\t'));
projVal = projVal(:,kGud0);

pVal_end = projVal(idx50:end,:);

pVal_median = median(pVal_end,1);
kThresh = find(pVal_median>=0.6);

% kThresh = find(median(projVal,1)>=0.5); % do not process GCs with median projection values less that 0.5 (thet=60).
% projVal = projVal(:,kThresh);
kGud = kGud0(kThresh);

% centGCsca = centGCsca(kGud,:,:);
% read the goodGCs from tracking
goodGCs = dlmread([si.txt 'GoodGCs' flgL '.txt'],'\t');
goodGCs = goodGCs(kGud);
% record the processed GCs
dlmwrite([si.txt 'BestGCs' flgL '.txt'],goodGCs,'\t');

numGCs = numel(goodGCs);

% read the projection angles relative to vertical
projAng = real(dlmread([si.txt 'projAng' flgL '.txt'],'\t'));
projAng = projAng(:,kGud);


% define volume dimensions
leg3Dful = round(0.67*SIv.gcDims(1)/SIv.xyRes); % half dim of the extracted volume
leg2Dmip = 2*round(SIv.gcDims(3)/SIv.xyRes); 
legGC = round(SIv.gcDims(4)/SIv.xyRes);
sizX = 2*leg2Dmip+1; sizY = 2*leg3Dful+1; sizZ = 2*leg3Dful+1;
% distance from trackGC coordinates to the center of the gc cylinder. set
% as 6 um.
L = round(SIv.gcDims(4)/SIv.xyRes);

gcBot = zeros(numStacks,3,numGCs,'uint16');
gcBotSca = zeros(numStacks,3,numGCs,'uint16');
gcBotReg = zeros(numStacks,3,numGCs,'uint16');
gcTip = zeros(numStacks,3,numGCs,'uint16'); % x,y,z coordinates of the tip in standard orientation.
gcTipSca = zeros(numStacks,3,numGCs,'uint16'); % x,y,z coordinates of the tip in standard orientation.
gcTipReg = zeros(numStacks,3,numGCs,'uint16');
gcExt = zeros(numStacks,numGCs); % distance, in pixels from the base plane of the gc to the tip.

skelYMIPs = zeros(sizZ,sizX,numGCs);

skelIdx = cell(numGCs,1);
skelIdxLength = zeros(numGCs,1);

hypYMIP = zeros(sizY,sizX,numStacks,numGCs,'uint16'); % vessel for segmented gc mips
projAngCorr = zeros(numGCs,1);

cylMsk0 = zeros(sizY,sizX,sizZ);
cylMsk0(:,leg2Dmip+1,leg3Dful+1) = 1;
cylMsk0 = bwdist(cylMsk0)<round(3/SIv.xyRes); 

% stack frame coordinates later used to remove border crossing binary
% objects
frmMont = stak2mont(repmat(padarray(zeros(sizZ-2,sizX-2,'single'),[1 1],1,'both'),[1 1 sizY]));
[fR,fC] = find(frmMont);

stkIdx = zeros(numStacks,1);
for s0 = 1:numStacks
    truIdx = s0+startIdx-1;
    stkName = scaList(truIdx).name;
    stkIdx(s0) = str2double(stkName(regexp(stkName,'\d')));
end

poolNum = 5;%poolNum = 6;
poolSet = 1;
if floor(numGCs/(poolSet*poolNum)) > 0
    loopLims = zeros(floor(numGCs/(poolSet*poolNum)),2);
    loopLims(:,1) = 1:(poolSet*poolNum):poolSet*poolNum*size(loopLims,1)';
    loopLims(:,2) = loopLims(:,1)+poolSet*poolNum-1;
    if rem(numGCs,(poolSet*poolNum))~=0
        loopLims = cat(1,loopLims,[0 0]);
        loopLims(end,1) = 1+loopLims(end-1,2);
        loopLims(end,2) = numGCs;
    end
else
    loopLims = [1 numGCs];
end

% re-assigning indexed variables where possible
si_mGloFx = si.mGloFx;
regDims_xTop = regDims.xTop;
regDims_yTop = regDims.yTop;
regDims_zTop = regDims.zTop;

%%

for p1 = 1:size(loopLims,1)
matlabpool(poolNum)
tLoop = zeros(numGCs,1);
parfor i0 = loopLims(p1,1):loopLims(p1,2)
    tic
    disp(cat(2,'loop count = ',num2str(i0),', GCid = ',num2str(goodGCs(i0))));
    projAng_pf = projAng(:,i0);
%     centGCsca_pf = squeeze(centGCsca(i0,:,:));
%     centGCalgn_pf = zeros(size(centGCsca_pf));
    % match the cylMask to the average orientation of the mipMsk GCs.
    thet = mean(projAng_pf(skelMIPIdx:numStacks));
    Mthet = eye(4);
    Mthet(2,2) = cosd(thet); Mthet(2,3) = -sind(thet);
    Mthet(3,2) = sind(thet); Mthet(3,3) = cosd(thet);
    cylMsk = affine_transform(cylMsk0,Fiji2Kroon(Mthet),3);
    cylMsk = round(rot90_3D(cylMsk,2,1));
    cylMont = stak2mont(cylMsk);
    % define temp variables
    hypStk = zeros(sizY,sizX,sizZ,numStacks,'uint16');
   
    dirGC = ['GC' num2str(goodGCs(i0),'%03.0f')];
%     pTime = 0.1*rand(numStacks,1);
    for i1 = 1:numStacks
%         i1
        M_gc = dlmread([locDir dirGC '/' dirGC '-' num2str(stkIdx(i1),'%03.0f') '.txt'],'\t');
        ori = M_gc(4,1:3); M_gc(4,1:3) = 0;
%         pause(pTime(i1));
        slabH = TIFFStack([scaDir scaList(stkIdx(i1)).name]);
%         if i1 ==1; scaZ = size(slabH,3); end
        zTop = max(1,ori(3)-leg3Dful);
        zBot = min(scaZ,ori(3)+leg3Dful);
        slabIm = slabH(:,:,zTop:zBot);
        rawVoi = single(extractROI_3D([ori(1);ori(2);ori(3)-zTop+1],[leg3Dful;leg3Dful;leg3Dful],slabIm));
        regVoi = uint16(affine_transform(rawVoi,Fiji2Kroon(M_gc),3));
        hypStk(:,:,:,i1) = extractROI_3D([leg3Dful+1;leg3Dful+1;leg3Dful+1],[leg2Dmip;leg3Dful;leg3Dful],regVoi);
        delete(slabH);
%         clear slabH
    end
    
    mipStk0 = max(hypStk(:,:,:,skelMIPIdx:numStacks),[],4); 
    mipStk = rot90_3D(mipStk0,2,1);
    % k-means segmentations.
    mipStkG1 = zeros(size(mipStk));
    for i2 = 1:sizY;mipStkG1(:,:,i2) = imgaussian(im2double(mipStk(:,:,i2)),1);end
    mipMont = stak2mont(mipStkG1);
   
    mipStkG10 = zeros(size(mipStk));
    for i2 = 1:sizY;mipStkG10(:,:,i2) = imgaussian(im2double(mipStk(:,:,i2)),10);end
    mipMontG10 = stak2mont(mipStkG10);

    mipMontIn = im2uint16(mipMont-mipMontG10);
    
    [~,mipMontK] = kmeans_oa_v(mipMontIn,find(mipMontIn),6);
    
    % combining watershed transform with the k-means segmented image to break
    % valleys.
    mskPeak = mipMontK.*(mipMontK>1);
    mskAlK = mskPeak>0; 
    CC = bwconncomp(mskAlK); n = CC.NumObjects;
    maxK = zeros(n,1);
    mipMontC = zeros(size(mskPeak));
    for i2 = 1:n
        idx = cell2mat(CC.PixelIdxList(i2));
        val = mskPeak(idx);
        maxK(i2) = max(val);
        k1 = find(val>max(1,round(maxK(i2))-3));
        mipMontC(idx(k1)) = 1;
    end
    mipMontC = bwmorph(mipMontC,'clean');
    wshed = watershed(-mipMontC.*mskPeak)==0;
    mipMontC(wshed) = 0;
    mipMontC = mipMontC - bwselect(mipMontC,fC,fR);
    
    
%     figure, imshow(mipMontC);
    
    % the objective is to find the largest binary central object. the
    % central cylinder mask, cylMsk, is used for the first selection round.
    % then, slices with more than one object are handled by walking from
    % the ends of the largest contiguous set of single-object slices and
    % selecting the closest object where there is more than one. 
    [r1,c1] = find(cylMont); 
    mskMont = double(bwselect(mipMontC,c1,r1)); mskStk = mont2stak(mskMont,size(mipStk)); % cylMsk selection
%     figure, imshow(cat(3,mipMontC,mskMont,cylMont));
    [bigStk,~] = findbiggest(mskStk);
    
    oneGCstk = zeros(sizZ,sizX,sizY);
    bigSpan = find(max(squeeze(max(bigStk,[],2)),[],1));
    oneGCstk(:,:,bigSpan(end)) = bigStk(:,:,bigSpan(end));
    for i2 = bigSpan(end)-1:-1:bigSpan(1) % walk up
        slc = oneGCstk(:,:,i2+1);
        [r1,c1] = find(slc);
        slxSlc = bwselect(bigStk(:,:,i2),c1,r1);
        if any(slxSlc(:))
            oneGCstk(:,:,i2) = slxSlc;
        else
            [r1,c1] = find(imdilate(slc,ones(3)));% the dilation makes sure that slices that were 26-connected in 3d touch in 2d.
            slxSlc = bwselect(bigStk(:,:,i2),c1,r1);
            if any(slxSlc(:))
                oneGCstk(:,:,i2) = slxSlc;
            else
                break
            end
        end
    end
 
    
    [r1,c1,z1] = ind2sub(size(oneGCstk),find(oneGCstk));
    onSlices = unique(z1);
    numOnSlices = length(onSlices);
    midNum = find(onSlices==leg3Dful+1-round(0.5*legGC),1);
    if isempty(midNum)
        midNum = round(0.5*numOnSlices);
    end
    for i1 = midNum:numOnSlices % walking down form the center of onSlices
        onIdx = find(z1 == onSlices(i1));
        intSlice = mipStkG1(:,:,onSlices(i1)).*cylMsk(:,:,onSlices(i1)); % constrain the search for the intensity maximum to the cylMask
%         intSlice = imgaussian(double(mipStk(:,:,onSlices(i1))),1); %intensity slice from the original data stack
        kSlice = sub2ind(size(intSlice),r1(onIdx),c1(onIdx));
        pixVal = intSlice(kSlice);
        centR = round(sum(r1(onIdx).*pixVal)/sum(pixVal));
        centC = round(sum(c1(onIdx).*pixVal)/sum(pixVal));
        if i1 == midNum
            skelZ = onSlices(i1);
            skelR = centR;
            skelC = centC;
        else
            %normS(onSlices(i1),1)=norm([centR centC]-[skelR(end) skelC(end)]);
            if norm([centR centC]-[skelR(end) skelC(end)]) <= round(2.5/SIv.xyRes) % making sure the Skel doesn't jump GCs. threshold set at 2.5 um
                if norm([centR centC]-[skelR(end) skelC(end)]) <= sqrt(2)
                    % if the centroid of the next mask slice is
                    % 8-connected to the previous one, add the coordinates to
                    % the list.
                    skelR = cat(2,skelR,centR);
                    skelC = cat(2,skelC,centC);
                    skelZ = cat(2,skelZ,onSlices(i1));
                else
                    % otherwise, connect the two centroids with a straight
                    % line.
                    linkR = round(linspace(skelR(end),centR,20));
                    linkC = round(linspace(skelC(end),centC,20));
                    %linkK = sub2ind([sizY sizX sizZ],linkR,linkC);
                    linkK = sub2ind(size(intSlice),linkR,linkC);
                    k1 = find(linkK ~= linkK(1)); % removing the repeated starting coordinate.
                    skelR = cat(2,skelR,linkR(k1));
                    skelC = cat(2,skelC,linkC(k1));
                    skelZ = cat(2,skelZ,onSlices(i1)*ones(1,length(k1)));
                end
            else
%                 extZ = onSlices(i1):sizZ;
%                 skelZ = cat(2,skelZ,extZ);
%                 skelR = cat(2,skelR,skelR(end)*ones(1,length(extZ)));
%                 skelC = cat(2,skelC,skelC(end)*ones(1,length(extZ)));
                break
            end
                
                
        end
%         if i1 == numOnSlices
%             extZ = onSlices(end):sizZ;
%             skelZ = cat(2,skelZ,extZ);
%             skelR = cat(2,skelR,skelR(end)*ones(1,length(extZ)));
%             skelC = cat(2,skelC,skelC(end)*ones(1,length(extZ)));
%         end
    end
    
    for i1 = midNum-1:-1:1 % walking up form the center of onSlices
        onIdx = find(z1 == onSlices(i1));
        intSlice = mipStkG1(:,:,onSlices(i1)).*cylMsk(:,:,onSlices(i1)); % constrain the search for the intensity maximum to the cylMask
%         intSlice = imgaussian(double(mipStk(:,:,onSlices(i1))),1); %intensity slice from the original data stack
        kSlice = sub2ind(size(intSlice),r1(onIdx),c1(onIdx));
        pixVal = intSlice(kSlice);
        centR = round(sum(r1(onIdx).*pixVal)/sum(pixVal));
        centC = round(sum(c1(onIdx).*pixVal)/sum(pixVal));
        
        if norm([centR centC]-[skelR(1) skelC(1)]) <= round(2.5/SIv.xyRes) % making sure the Skel doesn't jump GCs. threshold set at 2.5 um
            if norm([centR centC]-[skelR(1) skelC(1)]) <= sqrt(2)
                % if the centroid of the next mask slice is
                % 8-connected to the previous one, add the coordinates to
                % the list.
                skelR = cat(2,centR,skelR);
                skelC = cat(2,centC,skelC);
                skelZ = cat(2,onSlices(i1),skelZ);
            else
                % otherwise, connect the two centroids with a straight
                % line.
                linkR = round(linspace(centR,skelR(1),20));
                linkC = round(linspace(centC,skelC(1),20));
                %linkK = sub2ind([sizY sizX sizZ],linkR,linkC);
                linkK = sub2ind(size(intSlice),linkR,linkC);
                k1 = find(linkK ~= linkK(end)); % removing the repeated starting coordinate.
                skelR = cat(2,linkR(k1),skelR);
                skelC = cat(2,linkC(k1),skelC);
                skelZ = cat(2,onSlices(i1)*ones(1,length(k1)),skelZ);
            end
        else
%             extZ = 1:onSlices(i1);
%             skelZ = cat(2,extZ,skelZ);
%             skelR = cat(2,skelR(1)*ones(1,length(extZ)),skelR);
%             skelC = cat(2,skelC(1)*ones(1,length(extZ)),skelC);
            break
        end
        
%         if i1 == 1
%             extZ = 1:onSlices(i1);
%             skelZ = cat(2,extZ,skelZ);
%             skelR = cat(2,skelR(1)*ones(1,length(extZ)),skelR);
%             skelC = cat(2,skelC(1)*ones(1,length(extZ)),skelC);
%         end
    end
    
    skelK = unique(sub2ind([sizZ sizX sizY],round(skelR),round(skelC),skelZ));
    
    % calculating the correction to the estimated projection angle
    [sR,~,sZ] = ind2sub([sizZ sizX sizY],skelK);
    fitCtr = find(sZ==leg3Dful+1,1);
    if ~isempty(fitCtr)
        fit1st = find(sZ==max(leg3Dful+1-round(0.5*legGC),sZ(1)));
        fitLst = find(sZ==min(leg3Dful+1+round(0.5*legGC),sZ(end)));
        fitSpan = fit1st:fitLst;
        if ge(numel(fitSpan),5)
            x = 1:numel(fitSpan); y = sR(fitSpan);
            p = polyfit(x,y,1);
            %         f = polyval(p,x);
            %         figure, plot(x,y,'o',x,f,'-');
            thet2 = atand(-p(1)); projAngCorr(i0) = thet2-thet;
        else
            projAngCorr(i0) = 360;
        end
    else
        projAngCorr(i0) = 360;
    end
    
    skelIdx{i0} = skelK;
    skelIdxLength(i0) = length(skelIdx{i0});    
    
    skelMask = zeros(size(oneGCstk));
    skelMask(skelK) = 1;
    skelYMIPs(:,:,i0) = zMIP_v1(rot90_3D(skelMask,2,3),1,sizY);
        
%         figure, imshow(cat(3,mipMontC,mskMont,stak2mont(oneGCstk)));
%         figure, imshow(skelYMIPs(:,:,i0),[]);
    
    skelMask = round(rot90_3D(skelMask,2,3)); % turn the skelMask back to the GC volume orientation.
    [skelY,skelX,skelZ] = ind2sub(size(skelMask),find(skelMask)); % recover the skeleton subscripts.
    skelV = [skelX';skelY';skelZ']; % construct position vectors 
    skelV = sortrows(skelV',2)';
    % upsample the the skeleton before rotation
    skelVup = [interp1(1:numel(skelX),skelV(1,:),1:0.1:numel(skelX));....
               interp1(1:numel(skelX),skelV(2,:),1:0.1:numel(skelX));...
               interp1(1:numel(skelX),skelV(3,:),1:0.1:numel(skelX))];
    
    Mtheti = eye(3)/Mthet(1:3,1:3);
    skelV0 = zeros(size(skelVup));
    for i1 = 1:size(skelV0,2)
        skelV0(:,i1) = 0.5*[sizX;sizY;sizZ]+(Mtheti*(skelVup(:,i1)-0.5*[sizX;sizY;sizZ]));
    end
    kInB = find(ge(skelV0(2,:),1) & le(skelV0(2,:),sizY) & ge(skelV0(3,:),1) & le(skelV0(3,:),sizZ)); % in bounds check. X doesn't move, so no check for this dim.
    skelV0 = skelV0(:,kInB);
    % extend the upsampled skeleton to the limits of the Y dimension
    minY0 = min(skelV0(2,:)); maxY0 = max(skelV0(2,:)); % note that these are the first and last entries, since the array has been sorted by the second row.
    if gt(minY0,1)
        extY = 1:0.1:minY0;
        extX = skelV0(1,1)*ones(1,numel(extY));
        extZ = skelV0(3,1)*ones(1,numel(extY));
        skelV0 = [[extX;extY;extZ] skelV0];
    end
    if lt(maxY0,sizY)
        extY = maxY0:0.1:sizY;
        extX = skelV0(1,end)*ones(1,numel(extY));
        extZ = skelV0(3,end)*ones(1,numel(extY));
        skelV0 = [skelV0 [extX;extY;extZ]];
    end
    
    gcCent_pf = zeros(numStacks,3);
    gcC2B_pf = zeros(tLim,1);
    gcBot_pf = zeros(numStacks,3);
    gcBotSca_pf = zeros(numStacks,3,'uint16');
    gcBotReg_pf = zeros(numStacks,3,'uint16');
    gcTip_pf = zeros(numStacks,3);
    gcTipSca_pf = zeros(numStacks,3,'uint16');
    gcTipReg_pf = zeros(numStacks,3,'uint16');
    gcExt_pf = zeros(numStacks,1);
    hypYMIP_pf = zeros(sizY,sizX,numStacks,'uint16');
   
    for i1 = 1:numStacks
%         i1
        fulStk = hypStk(:,:,:,i1);
        roiStkG1 = zeros(size(fulStk),'single');
        roiStkG10 = zeros(size(fulStk),'single');
        for i2 = 1:sizY
                roiStkG1(i2,:,:) = imgaussian(squeeze(single(fulStk(i2,:,:))),1);
                roiStkG10(i2,:,:) = imgaussian(squeeze(single(fulStk(i2,:,:))),5);
        end
        roiStkIn = single(uint16(roiStkG1-roiStkG10));
       
        % build skelMask to match the GC orientation
        thet = projAng_pf(i1);
        Mthet = eye(3); % rotation matrix. 3x3 form is sufficent.
        Mthet(2,2) = cosd(thet); Mthet(2,3) = -sind(thet);
        Mthet(3,2) = sind(thet); Mthet(3,3) = cosd(thet);
        
        skelV1 = zeros(size(skelV0)); % transformed skeleton subscripts
        for i2 = 1:size(skelV0,2)
            skelV1(:,i2) = 0.5*[sizX;sizY;sizZ]+(Mthet*(skelV0(:,i2)-0.5*[sizX;sizY;sizZ]));
        end
        skelY1 = round(skelV1(2,:));
        if numel(skelY1) ~= numel(unique(skelY1))
            [b1, m1, ~] = unique(skelY1,'first');
            [~, m2, ~] = unique(skelY1,'last');
            kRep = find(m2-m1);
            skelV1u = zeros(3,numel(b1)); % unique skeleton subscripts
            skelV1u(2,:) = b1; skelV1u(1,:) = skelV1(1,m1); skelV1u(3,:) = skelV1(3,m1);
            for i2 = 1:numel(kRep)
                skelV1u(1,kRep(i2)) = mean(skelV1(1,m1(kRep(i2)):m2(kRep(i2))));
                skelV1u(3,kRep(i2)) = mean(skelV1(3,m1(kRep(i2)):m2(kRep(i2))));
            end
        end
        skelV1u = round(skelV1u);
        kInB = find(ge(skelV1u(2,:),1) & le(skelV1u(2,:),sizY) & ge(skelV1u(3,:),1) & le(skelV1u(3,:),sizZ)); % in bounds check. X doesn't move, so no check for this dim.
        skelV1u = skelV1u(:,kInB);
        skelK1 = sub2ind([sizY,sizX,sizZ],skelV1u(2,:),skelV1u(1,:),skelV1u(3,:));
        skelMask0 = zeros(sizY,sizX,sizZ);
        skelMask0(skelK1) = 1;
        skelMask0 = bwdist(skelMask0)<round(2/SIv.xyRes);
        
        gcCent_pf(i1,:) = round([leg2Dmip+1+0; leg3Dful+1-L*cosd(thet); leg3Dful+1-L*sind(thet)]);
        ballMsk = zeros(sizY,sizX,sizZ);
        ballMsk(gcCent_pf(i1,2),gcCent_pf(i1,1),gcCent_pf(i1,3)) = 1;
        ballMsk = bwdist(ballMsk)<round(4/SIv.xyRes);
        gcMsk = skelMask0 | ballMsk;
        % create a line in yz space that passes through centGC and has
        % angle thet. base equation is z = m*y+b, with m = tand(thet) and b
        % the z intercept.
        b = gcCent_pf(i1,3)-tand(thet)*gcCent_pf(i1,2);
        yline = 1:0.1:sizY;
        zline = tand(thet)*yline + b;
        % need to limit the extent of zline to the image boundaries
        kZin = find(zline>=1 & zline<=sizZ);
        idxLine = sub2ind([sizY sizZ],round(yline(kZin)),round(zline(kZin)));
        lineMsk = zeros(sizY,sizZ);
        lineMsk(idxLine) = 1;
        distMsk = zeros(sizY,sizX,sizZ);
        distMsk(round(yline(kZin(end))),gcCent_pf(i1,1),round(zline(kZin(end)))) = 1;
        distMsk = bwdist(distMsk); % measures distance to the bottom of the lineMsk
        roiMsk = gcMsk.*roiStkIn;
        [~,roiK] = kmeans_oa_v(roiMsk,find(roiMsk),20);
        
        if i1 <= tLim
            pipeMsk = zeros(sizY,sizX,sizZ);
            pipeMsk(:,gcCent_pf(i1,1),:) = lineMsk;
            pipeMsk = bwdist(pipeMsk) <= round(1/SIv.xyRes);
            kPipe = find((roiK>2).*pipeMsk);
            if ~isempty(kPipe)
                [~,idxP] = sort(distMsk(kPipe),'ascend');
                % find the pi*r^2 closest pixels in the intersection.
                sortLim = min(numel(idxP),floor(pi*(round(1/SIv.xyRes))^2)); % in case there are fewer than pi*r^2 pixels in the intersection.
                [r1,c1,z1] = ind2sub([sizY sizX sizZ],kPipe(idxP(1:sortLim)));
                gcC2B_pf(i1,:) = norm(gcCent_pf(i1,:)-[mean(c1) mean(r1) mean(z1)]);
            end
        end
        roiK1 = roiK>1;
        [~,bigIdx] = findbiggest(roiK1);
        [~,minIdx] = min(distMsk(bigIdx));
        [tipR,tipC,tipZ] = ind2sub([sizY sizX sizZ],bigIdx(minIdx));
        gcTip_pf(i1,:) = [tipC tipR tipZ];
        hypYMIP_pf(:,:,i1) = uint16(max(single(fulStk).*gcMsk,[],3));
    end
    
    % by the definition of a plane, a(x-x0)+b(y-y0)+c(z-z0)=0,
    % which is equivalent to the equation you have above, the normal vector to the plane is <a,b,c> 
    gcC2B_ave = mean(gcC2B_pf(find(gcC2B_pf))); %#ok<*FNDSB>
    % calculating the shortest distance between the gc tip coordinate and
    % the average gc bottom plane.
    for i1 = 1:numStacks
        thet = projAng_pf(i1);    
        v = [0 L*cosd(thet) L*sind(thet)];
        v = v/norm(v);
        p = gcCent_pf(i1,:)+gcC2B_ave*v;
        gcBot_pf(i1,:) = p;
        C = [-v(1)/v(3) -v(2)/v(3) (v(1)/v(3))*p(1)+(v(2)/v(3))*p(2)+p(3)];
        % test code
%         x=1:sizX;
%         y=1:sizY;
%         [xx yy ] = meshgrid(x,y);
%         zz = C(1)*xx+C(2)*yy+C(3);
%         figure, surf(xx,yy,zz,'edgecolor','none');
%         zLim = find(zz(:)>=1 & zz(:)<=sizZ);
%         idx = sub2ind([sizY sizX sizZ],round(yy(zLim)), round(xx(zLim)), round(zz(zLim)));
%         test = zeros(sizY,sizX,sizZ);
%         test(idx) = 1;
%         figure, imshow(squeeze(max(test,[],2)),[]);
        
        [~, gcExt_pf(i1)] = dist2plane(gcTip_pf(i1,:),C);
        % convert the gc bottom and tip coordinates to scaled and
        % registered spaces
        XformFiji = dlmread([si_mGloFx 'XFullFiji' num2str(stkIdx(i1),'%03.0f') '.txt'],'\t');
        M_gc = dlmread([locDir dirGC '/' dirGC '-' num2str(stkIdx(i1),'%03.0f') '.txt'],'\t');
        ori = M_gc(4,1:3); M_gc(4,1:3) = 0;
%         sizX = 2*leg2Dmip+1; sizY = 2*leg3Dful+1; sizZ = 2*leg3Dful+1;
        p0b = p - [leg2Dmip+1 leg3Dful+1 leg3Dful+1];
        botSca1 = (eye(4)/M_gc)*[p0b';1];
        botSca1 = botSca1(1:3); botSca1 = botSca1 + ori';
        botReg1 = ones(4,1); botReg1(1:3) = botSca1;
        botReg1 = M_t1rev*XformFiji*M_t2rev*botReg1;
        botReg1(1) = botReg1(1)-regDims_xTop+1; % correcting for the x crop.
        botReg1(2) = botReg1(2)-regDims_yTop+1; % correcting for the y crop.
        botReg1(3) = botReg1(3)-regDims_zTop+1; % correcting for the z crop.
        botReg1 = botReg1(1:3);
        
        p0t = gcTip_pf(i1,:) - [leg2Dmip+1 leg3Dful+1 leg3Dful+1];
        tipSca1 = (eye(4)/M_gc)*[p0t';1];
        tipSca1 = tipSca1(1:3); tipSca1 = tipSca1 + ori';
        tipReg1 = ones(4,1); tipReg1(1:3) = tipSca1;
        tipReg1 = M_t1rev*XformFiji*M_t2rev*tipReg1;
        tipReg1(1) = tipReg1(1)-regDims_xTop+1; % correcting for the x crop.
        tipReg1(2) = tipReg1(2)-regDims_yTop+1; % correcting for the y crop.
        tipReg1(3) = tipReg1(3)-regDims_zTop+1; % correcting for the z crop.
        tipReg1 = tipReg1(1:3);
       
        gcBotSca_pf(i1,:) = uint16(botSca1)';
        gcBotReg_pf(i1,:) = uint16(botReg1)';
        gcTipSca_pf(i1,:) = uint16(tipSca1)';
        gcTipReg_pf(i1,:) = uint16(tipReg1)';
    
    end
  
    hypYMIP(:,:,:,i0) = hypYMIP_pf;
    gcBotSca(:,:,i0) = gcBotSca_pf;
    gcBotReg(:,:,i0) = gcBotReg_pf;
    gcTipSca(:,:,i0) = gcTipSca_pf;
    gcTipReg(:,:,i0) = gcTipReg_pf;
    gcBot(:,:,i0) = uint16(gcBot_pf);
    gcTip(:,:,i0) = uint16(gcTip_pf);
    gcExt(:,i0) = gcExt_pf;
    
    tLoop(i0) = toc;
    disp(['time taken to process gc loop ' num2str(i0) ' was ' num2str(tLoop(i0)) ' seconds.']);
    fclose('all');
end
matlabpool close
end


% saving output variables.

% flg = Ch;
% saving the skeleton indices.
skelIdxOut = zeros(max(skelIdxLength)+1,3,numGCs);
for j0 = 1:numGCs
    [sR,sC,sZ] = ind2sub([sizZ sizX sizY],skelIdx{j0});
    skelIdxOut(1,:,j0) = [sizX sizZ sizY];
    skelIdxOut(2:length(skelIdx{j0})+1,:,j0) = [sC' sR' sZ']; 
end


dlmwrite([si.txt 'SkelGCIndices-' flg flgL '.txt'],reshape(skelIdxOut,[max(skelIdxLength)+1 numGCs*3]),'\t');
% saving the correction to the projection angles
dlmwrite([si.txt 'projAngCorr' flgL '.txt'],projAngCorr,'\t');
% saving the gc extension distance
dlmwrite([si.txt 'gcExt' flgL '.txt'],gcExt,'\t');

% saving coordinate files as images
% to match the dimensional arrangement with earlier scripts, the images
% will be saved in numGC,3,numStacks format.
warning('off','MATLAB:DELETE:FileNotFound'); % useful: s = warning('query','last');
fN_Bot = [si.img 'botGC-' flg flgL '.tif']; delete(fN_Bot); 
fN_BotSca = [si.img 'botGCsca-' flg flgL '.tif']; delete(fN_BotSca);
fN_BotReg = [si.img 'botGCreg-' flg flgL '.tif']; delete(fN_BotReg);
fN_Tip = [si.img 'tipGC-' flg flgL '.tif']; delete(fN_Tip);
fN_TipSca = [si.img 'tipGCsca-' flg flgL '.tif']; delete(fN_TipSca);
fN_TipReg = [si.img 'tipGCreg-' flg flgL '.tif']; delete(fN_TipReg);
for i1 = 1:numStacks
    imwrite(squeeze(gcBot(i1,:,:))',fN_Bot,'tiff','Compression','none','WriteMode','append');
    imwrite(squeeze(gcBotSca(i1,:,:))',fN_BotSca,'tiff','Compression','none','WriteMode','append');
    imwrite(squeeze(gcBotReg(i1,:,:))',fN_BotReg,'tiff','Compression','none','WriteMode','append');
    imwrite(squeeze(gcTip(i1,:,:))',fN_Tip,'tiff','Compression','none','WriteMode','append');
    imwrite(squeeze(gcTipSca(i1,:,:))',fN_TipSca,'tiff','Compression','none','WriteMode','append');
    imwrite(squeeze(gcTipReg(i1,:,:))',fN_TipReg,'tiff','Compression','none','WriteMode','append');
end


% preparing the annotation text
annoWidth = 9; 
hypAnno = zeros(sizY,annoWidth,numStacks,numGCs,'uint8');
hf = figure('color','w');
image(ones(sizY,annoWidth));
set(gca,'units','pixels','position',[5 5 annoWidth-1 sizY-1],'visible','off');

for i0 = 1:numStacks
    for i1 = 1:numGCs
        ht = text('units','pixels','color','k','position',[5 2],'rotation',90,'fontsize',10,'string',...
                [num2str(goodGCs(i1),'%03.0f') ' P=' num2str(projVal(i0,i1),'%03.2f') ' E=' num2str(gcExt(i0,i1),'%03.1f')]);
        tim = getframe(gca);
        tim2 = tim.cdata;
        kText = find(tim2(:,:,3)==0);
        textMask = zeros(sizY,annoWidth,'uint8');
        textMask(kText) = 128;
        hypAnno(:,:,i0,i1) = textMask;
        delete(ht)
    end
end
close(hf);

% preparing tip trak output stack.
fN_Big = [si.img 'tipTrak-' flg flgL '.tif']; delete(fN_Big);
for i0 = 1:numStacks
    slcYMIP = squeeze(hypYMIP(:,:,i0,:));
    slcYMIPb = zeros(size(slcYMIP),'uint8'); slcYMIPr = slcYMIPb; slcYMIPg = slcYMIPb;
    for i1 = 1:numGCs
        ymip = slcYMIP(:,:,i1);
        k1 = find(ymip); 
        slcYMIPb(:,:,i1) = im2uint8(imadjust(ymip,stretchlim(ymip(k1)),[]));
        slcYMIPr(:,:,i1) = slcYMIPb(:,:,i1); slcYMIPr(gcBot(i0,2,i1),:,i1) = 64;
        slcYMIPg(:,:,i1) = slcYMIPb(:,:,i1); slcYMIPg(gcTip(i0,2,i1),:,i1) = 64;
    end
    slcAnno = squeeze(hypAnno(:,:,i0,:));
    slcYMIPb = [slcAnno slcYMIPb]; montYMIPb = uint8(stak2mont(slcYMIPb));
    slcYMIPr = [slcAnno slcYMIPr]; montYMIPr = uint8(stak2mont(slcYMIPr));
    slcYMIPg = [slcAnno slcYMIPg]; montYMIPg = uint8(stak2mont(slcYMIPg));
    montRGB = cat(3,montYMIPr,montYMIPg,montYMIPb);
    imwrite(montRGB,fN_Big,'tiff','Compression','none','WriteMode','append');
end


% preparing the skeleton overlay output stak
fN_Skel = [si.img 'skelMont-' flg flgL '.tif']; delete(fN_Skel);
skelStk = zeros(sizY,sizX+annoWidth,numGCs,3,'uint8');
for i1 = 1:numGCs
    skelMIP = max(hypYMIP(:,:,skelMIPIdx:numStacks,i1),[],3);
    k1 = find(skelMIP); 
    skelMIPb = im2uint8(imadjust(skelMIP,stretchlim(skelMIP(k1)),[0 0.75]));
    [~,c1,z1] = ind2sub([sizZ sizX sizY],skelIdx{i1});
    idx2D = sub2ind([sizY sizX],z1,c1);
    skelMIPr = skelMIPb; skelMIPg = skelMIPb; 
    skelMIPr(idx2D) = 255;
    slcAnno = squeeze(hypAnno(:,:,numStacks,i1));
    skelStk(:,:,i1,3) = [slcAnno skelMIPb]; 
    skelStk(:,:,i1,1) = [slcAnno skelMIPr]; 
    skelStk(:,:,i1,2) = [slcAnno skelMIPg]; 
end
skelRGB = cat(3,uint8(stak2mont(skelStk(:,:,:,1))),uint8(stak2mont(skelStk(:,:,:,2))),uint8(stak2mont(skelStk(:,:,:,3))));
imwrite(skelRGB,fN_Skel,'tiff','Compression','none','WriteMode','append');
