function s_ShellzMIP_v3(si,Ch)
% uses channel specific shell mask

flg = Ch;
if strcmp(Ch,'G')
    regDir = si.regG;
    flg2 = 'R';
else
    regDir = si.regR;
    flg2 = 'G';
end


regList  = dir([regDir '*.tif']);

numStacks  = size(regList,1);
info = imfinfo([regDir regList(1).name]);
sizX = info.Width; sizY = info.Height; sizZ = numel(info);
% reading the ShellMask
shellPath = [si.img 'ShellMask-' flg '.tif'];
if exist(shellPath,'file') == 0 
        shellPath = [si.img 'ShellMask-' flg2 '.tif'];
end
[ShellStruct, ~] = tiffread2(shellPath);
ShellMask = zeros(sizY,sizX,sizZ,'single');

for i0 = 1:sizZ; ShellMask(:,:,i0) = single(ShellStruct(i0).data); end
ShellMask = ShellMask>0;
clear ShellStruct 

valMIP = zeros(sizY,sizX,numStacks);
idxMIP = zeros(sizY,sizX,numStacks);
outFile1 = [si.img 'ShellzMIP_val-' flg '.tif'];
if exist(outFile1,'file') ~= 0 % delete result of previous run, if it exists.
        delete(outFile1);
end
outFile2 = [si.img 'ShellzMIP_idx-' flg '.tif'];
if exist(outFile2,'file') ~= 0 % delete result of previous run, if it exists.
        delete(outFile2);
end

matlabpool open 4
parfor j1 = 1:numStacks
    stkName = regList(j1).name;
    stkIdx = str2double(stkName(regexp(stkName,'\d')));
    disp(cat(2,'loop count = ',num2str(j1), ', stk idx = ',num2str(stkIdx)));
    [inStruct, ~] = tiffread2([regDir stkName]);
    inStk = zeros(sizY,sizX,sizZ);
    for i0 = 1:sizZ; inStk(:,:,i0) = single(inStruct(i0).data); end
    
    inStk = inStk.*ShellMask;
    [valMIP(:,:,j1),idxMIP(:,:,j1)] = max(inStk,[],3);
end
matlabpool close 

for j1 = 1:numStacks
    imwrite(uint16(valMIP(:,:,j1)),outFile1,...
                                     'tiff','Compression','none','WriteMode','append');
    imwrite(uint16(idxMIP(:,:,j1)),outFile2,...
                                     'tiff','Compression','none','WriteMode','append');
end
    
    
    
    