function s_Shield2Shell_v1(si,Ch,Lims)
% takes the output of ShieldMask_v2 and builds a shell which is Lims
% bounded from the shield. Lims(1) > Lims(2)
disp('creating the Shield Mask...');
inStkH = TIFFStack([si.img 'ShieldMask.tif']);
shield = single(squeeze(inStkH(:,:,:,1)));
delete(inStkH);
[sizY sizX sizZ] = size(shield);
Km = find(shield);

disp('creating directional distance map...');
dirMsk = ones(sizY,sizX,sizZ,'int8'); 
[Kr,Kc,Kz] = ind2sub([sizY sizX sizZ],Km);
for j1 = 1:numel(Km)
    z1 = max(Kz(j1));
    dirMsk(Kr(j1),Kc(j1),z1:end) = -1;
end
distX = bwdist(shield);
distX = distX.*single(dirMsk);

disp('applying shell limits...');
shell = le(distX,Lims(1)) & ge(distX,Lims(2));

fileName = [si.img 'ShellMask-' Ch '.tif'];
if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
    delete(fileName);
end
disp('saving new Shell Mask...');
for i1 = 1:sizZ
    imwrite(uint8(shell(:,:,i1)),fileName,...
               'tiff','Compression','none','WriteMode','append');
end
