function s_ShieldMask_v2(si,Ch,SIv)
% erodes the registered anchor stack to remove the axons. uses gridFit to
% build the shield
if strcmp(Ch,'G')
    regDir = si.regG;   
else
    regDir = si.regR;
end
regList  = dir([regDir '*.tif']);
anchorIdx = SIv.anchorIdx;
if anchorIdx==0; 
    hA = dlmread([si.txt 'hrsAPF.txt']);
    [~,anchorIdx] = min(abs(hA-40));
    disp(['anchor idx in use is ', num2str(anchorIdx), ', the stack closest to 40 hAPF.']);

end
disp('reading the registered anchor stack...');
% reading the anchor stack
[stkStruct, sizZ] = tiffread2([regDir regList(anchorIdx).name]);

sizX = stkStruct(1).width; sizY = stkStruct(1).height; 
if isempty(SIv.ZMIP_stkLims)
    topZLim = 1; botZLim = sizZ;
else
    topZLim = SIv.ZMIP_stkLims(1); botZLim = SIv.ZMIP_stkLims(2);
end
shrtZ = botZLim-topZLim+1;

inStk = zeros([sizY, sizX, shrtZ],'single');
for i0 = 1:shrtZ; inStk(:,:,i0) = single(stkStruct(i0+topZLim-1).data);end
clear stkStruct

disp('background subtraction...');
mskStk = inStk;

% when the dark background is too high, background subtraction captures the
% original stack frame in the registered stack.
% the following code attempts to get rid of this.
kIn = find(mskStk(:));
[muIn,~] = kmeans_oa_v(mskStk,kIn,5);
kOut = setdiff(1:numel(mskStk(:)),kIn);
mskStk(kOut) = single(muIn(1));
clear kIn kOut


mskStkG03 = imgaussian(mskStk,1);
mskStkG10 = imgaussian(mskStk,10);
mskStkNet = single(uint16(mskStkG03-mskStkG10)); % background subtracted stack
disp('...done.');



disp('opening the background subtracted stack...');
eLeg = round(0.6/SIv.xyRes); %eLeg = round(1.2/SIv.xyRes);
eDim = 2*eLeg+1;
eBox = zeros(eDim,eDim,eDim); eBox(eLeg+1,eLeg+1,eLeg+1) = 1;
eBox = bwdist(eBox)<eLeg+1;
oStk = imopen(mskStkNet,eBox);
disp('...done.');

% commented out code helps if the oStk needs cleaning.
% sint_SaveStack(oStk,16,si.img,'oStk_test.tif');
% inStkH = TIFFStack([si.img 'oStk_test_fx.tif']);
% oStk = single(squeeze(inStkH(:,:,:)));
% delete(inStkH);
% sint_SaveStack(oStk,16,si.img,'oStk_test2.tif');

disp('k-means segmentation of opened stack...');
[~,oMsk] = kmeans_oa_v(oStk,find(oStk(:)),5);
disp('...done.');

disp('masking regional maxima with opened and segmented stack...');
mxMsk = (oMsk>1).*imregionalmax(mskStkNet);
% mxMsk = logical(ShellMask).*mxMsk;
% mxMsk = imclearborder(mxMsk);
disp('...done.');

% regional max are not all single pixel in size. using the centroids to
% reduce them in size
ctrStrct = regionprops(bwconncomp(mxMsk),'centroid');
ctrSubs = zeros(length(ctrStrct),3);
for i0 = 1:length(ctrStrct); ctrSubs(i0,:) = round(ctrStrct(i0).Centroid); end

objX = ctrSubs(:,1);
objY = ctrSubs(:,2);
objZ = ctrSubs(:,3);

% [ctrT,radT,~,vT] = ellipsoid_fit([objX objY objZ],3);
% suite_plotEllfit(objX,objY,objZ,ctrT,radT,vT);

% taking a new approach to sphere filtering. 
[k3,ctr3,rad3,v3,~] = sInt_filtSphfit_v3(ctrSubs,'in',0.04);
suite_plotEllfit(objX(k3),objY(k3),objZ(k3),ctr3,rad3,v3);
objSubs = [objX(k3) objY(k3) objZ(k3)+topZLim-1]; % returning to the full Z stack size

x1 = objSubs(:,1); y1 = objSubs(:,2); z1 = objSubs(:,3);
density = 10; 
[zg,xg,yg] = sint_gritfitExt(round([x1 y1 z1]),[sizX sizY sizZ],density);
figure, plot3( x1, y1, z1, '.r' );
axis equal
hold on;
p = surf(xg,yg,zg);
set( p, 'FaceColor', 'g','FaceAlpha',0.5 );
XI = 1:0.5:sizX; YI = 1:0.5:sizY; % create finer mesh and interpolate the gridfit.
[Xm,Ym] = meshgrid(XI,YI);
Zm = interp2(xg,yg,zg,Xm,Ym);
truZ = find(ge(round(Zm(:)),1) & le(round(Zm(:)),sizZ)); % reigning in the extended z dimension from gridfit
Km = unique(sub2ind([sizY sizX sizZ],round(Ym(truZ)),round(Xm(truZ)),round(Zm(truZ))));
shield = zeros(sizY,sizX,sizZ,'int8');
shield(Km) = 1;

fileName = [si.img 'ShieldMask.tif'];
if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
    delete(fileName);
end

for i1 = 1:sizZ
    imwrite(uint8(shield(:,:,i1)),fileName,...
               'tiff','Compression','none','WriteMode','append');
end






% [k4,ctr4,rad4,v4,~] = sInt_filtSphfit_v2(ctrSubs(k3,:),0.05);
% suite_plotEllfit(objX(k3(k4)),objY(k3(k4)),objZ(k3(k4)),ctr4,rad4,v4);
% objSubs = [objX(k3(k4)) objY(k3(k4)) objZ(k3(k4))+topZLim-1]; % returning to the full Z stack size


% ShellMask = sInt_4PieceShell(SIv,objSubs,[sizY sizX sizZ],[7 -3]); % this used to be [4 -5]
% 
% fileName = [si.img 'ShellMask.tif'];
% if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
%     delete(fileName);
% end
% 
% for i1 = 1:sizZ
%     imwrite(im2uint8(ShellMask(:,:,i1)),fileName,...
%                'tiff','Compression','none','WriteMode','append');
% end


