function s_SliceRegister_v5(si,Ch,SIv)
% _v5 takes seedXYZ coordinates produced by s_TurnAngles_v11 instead of the
% interactively picked pixel.
% comments below may be outdated.
% for now, user will enter the starting template parameters by hand.
% the templateSliceIdx defines the center of the templateMIP (maximum
% intensity projection).
% maximum intensity projection (MIP) depth. make it odd.
% the rotAngle specifies the range of rotation (in one degree increments) of the template image.
% imrotate performs counterclockwise rotation for positive angles. the
% final output will record the negative value of the highest correlation
% value rotation since i want to keep track of how the target image is
% rotated relative to the template. the reverse implementation used here is
% simply for ease of coding.

% in earlier versions, these variables were passed to this script. they
% haven't changed over time, so i'm burying them inside for now.
%%
mipDepth = 1;
rotAngle = 0;
templateLeg = 151;
zPad = 20;
dist2Ell = 0;

anchorIdx = SIv.anchorIdx;
if anchorIdx==0; anchorIdx=1; end
% templateLeg needs to be an odd number. this is how you're going to ensure
% that the center of the image will remain the same after rotation and
% recropping.

templateLongLeg = ceil(sqrt(2)*templateLeg);
if rem(templateLongLeg,2) == 0
    templateLongLeg = templateLongLeg+1;
else
    templateLongLeg = templateLongLeg+2;
end
% read the growth cone generated ShellSeed image saved by suite_TurnAngles_v2. we
% will extract the template slice info from this mask.
[stackStruct, sizZ] = tiffread2([si.img 'ShellSeed.tif']);
sizX = stackStruct(1).width; sizY = stackStruct(1).height;    
inStack = zeros([sizY, sizX, sizZ]);
for i0 = 1:sizZ
    inStack(:,:,i0) = ...
        im2single(stackStruct(i0).data);
end
[r1,c1,z1] = ind2sub([sizY, sizX, sizZ],find(inStack));

[ center, radii, evecs, v ] = ellipsoid_fit([c1 r1 z1]); % ellipsoid fit
dlmwrite([si.txt 'EllCoefsPre.txt'],v,'\t');

[ center, radii, evecs, v ] = ellipsoid_fit([c1 r1 z1],3); % sphere fit
dlmwrite([si.txt 'SphCoefsPre.txt'],v,'\t');
% suite_plotEllfit(c1,r1,z1,center,radii,v);

% % interactively select the seed coordinates for the template center.
% mipErodeMask = zMIP_v1(inStack,1,sizZ);
% [c0,r0,~] = impixel(mipErodeMask);
% % find the z coordinate of the seed.
% [~, z0idx] = min((r1-r0).*(r1-r0)+(c1-c0).*(c1-c0));
% x = c1(z0idx); y = r1(z0idx); z = z1(z0idx);

xyz = dlmread([si.txt 'seedXYZ.txt']);
x = xyz(1); y = xyz(2); z = xyz(3);

p = [v(1) v(2) v(3) 2*v(4) 2*v(5) 2*v(6) 2*v(7) 2*v(8) 2*v(9) -1];
[~,foot] = pqdist([x; y; z], p);

% determine if the seed is inside or outside the ellipsoid
seedVal = v(1) *x.*x +   v(2) * y.*y + v(3) * z.*z + ...
          2*v(4) *x.*y + 2*v(5)*x.*z + 2*v(6) * y.*z + ...
          2*v(7) *x    + 2*v(8)*y    + 2*v(9) * z;
if seedVal < 1
    distV = [x;y;z]-foot;
    distV = distV./norm(distV);
else
    distV = -([x;y;z]-foot);
    distV = distV./norm(distV);
end
dlmwrite([si.txt 'DistV.txt'],distV,'\t');
templateCent = round(foot + dist2Ell*distV);
tempX = templateCent(1);
tempY = templateCent(2);
tempZ = templateCent(3);

% directory. reading the previously scaled stacks
if strcmp(Ch,'G')
    dirName = si.scaG; 
else
    dirName = si.scaR;   
end

stackDir  = dir([dirName '*.tif']);
numStacks  = size(stackDir,1);

% read the template MIP slices (stack id'ed by anchorIdx),
% extract templateMIPLong and stack size.
stackInfo = imfinfo([dirName stackDir(anchorIdx).name]);
numSlices = max(size(stackInfo));
fulX = stackInfo(1).Width; fulY = stackInfo(1).Height; fulZ = numSlices;
fulOri = 0.5*[fulX fulY fulZ];
smlOri = 0.5*[sizX sizY sizZ];
% the template center was extracted from the scaled down eroded mask. need
% to convert these coordinates back to unity aspect ratio full scale stack.
newScale = 1; % obsolete variable.
t2oriFor = eye(4); t2oriFor(1:3,4) = -1*smlOri;
t2oriBak = eye(4); t2oriBak(1:3,4) = fulOri;
s2Ful = (1/newScale).*eye(4); s2Ful(4,4) = 1; 
smlV = [tempX; tempY; tempZ; 1];
fulV = t2oriBak*s2Ful*t2oriFor*smlV;

templateX = round(fulV(1));
templateY = round(fulV(2));
templateSliceIdx = round(fulV(3));


templateLongStack = zeros(templateLongLeg,templateLongLeg,mipDepth);

% will be padding the templateSlice in case the LongLeg is out of bounds.
padSize = 0.5*(templateLongLeg+1);
for i1 = 1:mipDepth
    templateSlice = imread([dirName stackDir(anchorIdx).name],templateSliceIdx-0.5*(mipDepth-1)+(i1-1));
    templateSlice = padarray(templateSlice, [padSize padSize], 0);
    templateLongStack(:,:,i1) = templateSlice(padSize+templateY-0.5*(templateLongLeg-1):padSize+templateY+0.5*(templateLongLeg-1),...
                                              padSize+templateX-0.5*(templateLongLeg-1):padSize+templateX+0.5*(templateLongLeg-1));
end
templateMIPLong = max(templateLongStack,[],3);

% making a stack of rotated and cropped MIPs. rotation range is
% [rotAngle:-rotAngle].

rotRange = (rotAngle:-1:-1*rotAngle);
rotTemplate = zeros(templateLeg,templateLeg,rotRange);
for i2 = 1:length(rotRange)
    rotMIPLong =  imrotate(templateMIPLong,rotRange(i2),'bilinear','crop');
    rotTemplate(:,:,i2) = rotMIPLong(0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg,...
                                 0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg);
end

% initialize output variables
% rotCorrArray will hold the correlation values through the rotation range.
% columns are rotation angle, corr value, X(c) and Y(r) coordinates from
% normxcorr2.
rotCorrArray = zeros(length(rotRange),4);
rotCorrArray(:,1) = rotRange';


% the final variable will hold the stack number, slice number, corr value, rotAngle, and
% X(c) and Y(c) coordinates for the center of the best correlated slice.
regArray = zeros(numStacks,6);
regArray(:,1) = (1:numStacks)';
regStk = zeros(templateLeg,templateLeg,numStacks);
% save the rotTemplate for the second for loop.
anchorRotTemplate = rotTemplate;

for n1 = anchorIdx:numStacks
    n1
%     
%     if n1>90 || n1<=96
%         zPad = 100;
%     else
%         zPad = 20;
%     end
    
    topSlice = max(templateSliceIdx-zPad-0.5*(mipDepth-1),1);
    botSlice = min(templateSliceIdx+zPad+0.5*(mipDepth-1),numSlices);
    sliceRange = (topSlice:botSlice)';
    [targetStack, ~] = tiffread2([dirName stackDir(n1).name],topSlice,botSlice);
    
    % sliceCorrArray will hold the correlation values through the slice range.
    % columns are targetSliceIdx, corr value, rotAngle, X(c) and Y(r) coordinates
    % from normxcorr2.
    
    sliceCorrArray = zeros((numel(sliceRange)-(mipDepth-1)),5);
    
    for n2 = 1:(numel(sliceRange)-(mipDepth-1))
        % with all the index shuffling, i need to keep track of what the
        % actual slice index is.
        targetSliceIdx = topSlice+0.5*(mipDepth-1)+n2-1;
        
        % create a MIP for the target slice
        targetLongStack = zeros(templateLongLeg,templateLongLeg,mipDepth);
        for n3 = 1:mipDepth
            targetSlice = double(targetStack(n2+n3-1).data);
            targetSlice = padarray(targetSlice, [padSize padSize], 0);
            targetLongStack(:,:,n3) = targetSlice(padSize+templateY-0.5*(templateLongLeg-1):padSize+templateY+0.5*(templateLongLeg-1),...
                                                 padSize+templateX-0.5*(templateLongLeg-1):padSize+templateX+0.5*(templateLongLeg-1));
        end
        targetMIP = max(targetLongStack,[],3);    
            
        % now run the correlation through the rotated target stack.
        for n4 = 1:length(rotRange)
            cc = normxcorr2(rotTemplate(:,:,n4),targetMIP);
            [max_cc, imax] = max(abs(cc(:)));
            [ypeak, xpeak] = ind2sub(size(cc),imax(1));
            corr_offset = [ (ypeak-templateLeg-0.5*(templateLongLeg-templateLeg)) ...
                            (xpeak-templateLeg-0.5*(templateLongLeg-templateLeg)) ];
            rotCorrArray(n4,2:4) = [max_cc corr_offset(2) corr_offset(1)];
        end
        [~, idxMxRotCorr] = max(rotCorrArray(:,2));
        sliceCorrArray(n2,:) = [targetSliceIdx ...
                                rotCorrArray(idxMxRotCorr,2) ...
                                rotCorrArray(idxMxRotCorr,1) ...
                                rotCorrArray(idxMxRotCorr,3) ...
                                rotCorrArray(idxMxRotCorr,4)];
        rotCorrArray(:,2:4) = 0;
    end
    % out of the slice loop. now find the best slice and write results into
    % regArray. note that i'm multiplying the rotation angle by -1 and
    % converting offsets to actual coordinates.
    [~, idxMxSliceCorr] = max(sliceCorrArray(:,2));
    regArray(n1,2:6) = [sliceCorrArray(idxMxSliceCorr,1:2) ...
                       -1*sliceCorrArray(idxMxSliceCorr,3) ...
                       sliceCorrArray(idxMxSliceCorr,4)+templateX ...
                       sliceCorrArray(idxMxSliceCorr,5)+templateY];
    templateSliceIdx = sliceCorrArray(idxMxSliceCorr,1);
    clear sliceCorrArray
    % recreate rotTemplate using offsets and new stack.
    templateX = regArray(n1,5);
    templateY = regArray(n1,6);
    
    templateLongStack(:) = 0;
    
    for i1 = 1:mipDepth
        templateSlice = imread([dirName stackDir(n1).name],regArray(n1,2)-0.5*(mipDepth-1)+(i1-1));
        templateSlice = padarray(templateSlice, [padSize padSize], 0);
        templateLongStack(:,:,i1) = templateSlice(padSize+templateY-0.5*(templateLongLeg-1):padSize+templateY+0.5*(templateLongLeg-1),...
                                                  padSize+templateX-0.5*(templateLongLeg-1):padSize+templateX+0.5*(templateLongLeg-1));
    end
    templateMIPLong = max(templateLongStack,[],3);
    
    rotTemplate(:) = 0;
    for i2 = 1:length(rotRange)
        rotMIPLong =  imrotate(templateMIPLong,rotRange(i2),'bilinear','crop');
        rotTemplate(:,:,i2) = rotMIPLong(0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg,...
                                     0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg);
    end
    regStk(:,:,n1) = templateLongStack(0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg,...
                                     0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg,...
                                     0.5*(mipDepth-1)+1);
    imshow(regStk(:,:,n1),[]);
    pause(0.05);
end

templateX = round(fulV(1));
templateY = round(fulV(2));
templateSliceIdx = round(fulV(3));
rotTemplate = anchorRotTemplate;

for n1 = anchorIdx-1:-1:1
    n1
    topSlice = max(templateSliceIdx-zPad-0.5*(mipDepth-1),1);
    botSlice = min(templateSliceIdx+zPad+0.5*(mipDepth-1),numSlices);
    sliceRange = (topSlice:botSlice)';
    [targetStack, ~] = tiffread2([dirName stackDir(n1).name],topSlice,botSlice);
    
    % sliceCorrArray will hold the correlation values through the slice range.
    % columns are targetSliceIdx, corr value, rotAngle, X(c) and Y(r) coordinates
    % from normxcorr2.
    
    sliceCorrArray = zeros((numel(sliceRange)-(mipDepth-1)),5);
    
    for n2 = 1:(numel(sliceRange)-(mipDepth-1))
        % with all the index shuffling, i need to keep track of what the
        % actual slice index is.
        targetSliceIdx = topSlice+0.5*(mipDepth-1)+n2-1;
        
        % create a MIP for the target slice
        targetLongStack = zeros(templateLongLeg,templateLongLeg,mipDepth);
        for n3 = 1:mipDepth
            targetSlice = double(targetStack(n2+n3-1).data);
            targetSlice = padarray(targetSlice, [padSize padSize], 0);
            targetLongStack(:,:,n3) = targetSlice(padSize+templateY-0.5*(templateLongLeg-1):padSize+templateY+0.5*(templateLongLeg-1),...
                                                 padSize+templateX-0.5*(templateLongLeg-1):padSize+templateX+0.5*(templateLongLeg-1));
        end
        targetMIP = max(targetLongStack,[],3);    
            
        % now run the correlation through the rotated target stack.
        for n4 = 1:length(rotRange)
            cc = normxcorr2(rotTemplate(:,:,n4),targetMIP);
            [max_cc, imax] = max(abs(cc(:)));
            [ypeak, xpeak] = ind2sub(size(cc),imax(1));
            corr_offset = [ (ypeak-templateLeg-0.5*(templateLongLeg-templateLeg)) ...
                            (xpeak-templateLeg-0.5*(templateLongLeg-templateLeg)) ];
            rotCorrArray(n4,2:4) = [max_cc corr_offset(2) corr_offset(1)];
        end
        [~, idxMxRotCorr] = max(rotCorrArray(:,2));
        sliceCorrArray(n2,:) = [targetSliceIdx ...
                                rotCorrArray(idxMxRotCorr,2) ...
                                rotCorrArray(idxMxRotCorr,1) ...
                                rotCorrArray(idxMxRotCorr,3) ...
                                rotCorrArray(idxMxRotCorr,4)];
        rotCorrArray(:,2:4) = 0;
    end
    % out of the slice loop. now find the best slice and write results into
    % regArray. note that i'm multiplying the rotation angle by -1 and
    % converting offsets to actual coordinates.
    [~, idxMxSliceCorr] = max(sliceCorrArray(:,2));
    regArray(n1,2:6) = [sliceCorrArray(idxMxSliceCorr,1:2) ...
                       -1*sliceCorrArray(idxMxSliceCorr,3) ...
                       sliceCorrArray(idxMxSliceCorr,4)+templateX ...
                       sliceCorrArray(idxMxSliceCorr,5)+templateY];
    templateSliceIdx = sliceCorrArray(idxMxSliceCorr,1);
    clear sliceCorrArray
    % recreate rotTemplate using offsets and new stack.
    templateX = regArray(n1,5);
    templateY = regArray(n1,6);
    
    templateLongStack(:) = 0;
    
    for i1 = 1:mipDepth
        templateSlice = imread([dirName stackDir(n1).name],regArray(n1,2)-0.5*(mipDepth-1)+(i1-1));
        templateSlice = padarray(templateSlice, [padSize padSize], 0);
        templateLongStack(:,:,i1) = templateSlice(padSize+templateY-0.5*(templateLongLeg-1):padSize+templateY+0.5*(templateLongLeg-1),...
                                                  padSize+templateX-0.5*(templateLongLeg-1):padSize+templateX+0.5*(templateLongLeg-1));
    end
    templateMIPLong = max(templateLongStack,[],3);
    
    rotTemplate(:) = 0;
    for i2 = 1:length(rotRange)
        rotMIPLong =  imrotate(templateMIPLong,rotRange(i2),'bilinear','crop');
        rotTemplate(:,:,i2) = rotMIPLong(0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg,...
                                     0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg);
    end
    regStk(:,:,n1) = templateLongStack(0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg,...
                                     0.5*(templateLongLeg-templateLeg)+1:0.5*(templateLongLeg-templateLeg)+templateLeg,...
                                     0.5*(mipDepth-1)+1);
    imshow(regStk(:,:,n1),[]);
    pause(0.05);
end

for i0 = 1:numStacks
    imwrite(uint16(regStk(:,:,i0)),[si.img 'RegSlices.tif'],...
                                     'tiff','Compression','none','WriteMode','append');
end
wk1write([si.txt 'RegArray.wk1'], regArray);