function s_StkFileNames_v2(si,Ch)

% writes the stack file names to a txt file. for Fiji use.
% v2 appends the channel id, since the names of the stacks have this
% identifier.
if strcmp(Ch,'G')
    rawDir = si.rawG; 
else
    rawDir = si.rawR;   
end

rawList  = dir(cat(2,rawDir,'*.tif'));
numStacks  = size(rawList,1);

nameList = cell(numStacks,1);
for i0 = 1:numStacks
    nameList{i0} = rawList(i0).name;
end
nameListPath = [si.txt 'AllStks_' Ch '.txt'];
dlmcell(nameListPath,nameList);