function s_TrackGCs_v2(si,Ch,SIv)
% directory. reading the previously registered stacks
if strcmp(Ch,'G')
    regDir = si.regG; 
else
    regDir = si.regR;   
end
regList  = dir(cat(2,regDir,'*.tif'));
if isempty(SIv.trakSpan)
    startIdx = 1; numStacks = numel(regList);
else
    startIdx = SIv.trakSpan(1); stopIdx = SIv.trakSpan(2);
    numStacks = stopIdx-startIdx+1;
end
newIdx = SIv.seedIdx-startIdx+1;
% read the seed coordinates for the GCs, output of s_DefineGCs
seedGCs = dlmread([si.txt 'SeedGCs.txt'],'\t');
numGC = size(seedGCs,2);
trackGCs = zeros(3,numGC,numStacks);
trackGCs(:,:,newIdx) = seedGCs;
% leg is half dim of the image volume
leg = round(5/SIv.xyRes); % image vol will be approx. 10um  in linear dimension
volDim = 2*leg+1; volCtr = sub2ind([volDim volDim volDim],leg+1,leg+1,leg+1);
gball = zeros(volDim,volDim,volDim); gball(leg+1,leg+1,leg+1) = 1;
tempSig = round(3.5/SIv.xyRes); gballTemp = imgaussian(gball, tempSig); gballTemp = gballTemp./max(gballTemp(:));

% read LineMask, output of s_DefineGCs
[lineStruct, sizZ] = tiffread2([si.img 'LineMask.tif']);
sizX = lineStruct(1).width; sizY = lineStruct(1).height;    
LineMask = zeros(sizY,sizX,sizZ,'single');
for i0 = 1:sizZ; LineMask(:,:,i0) = single(lineStruct(i0).data); end
clear lineStruct 
tempMsk = zeros(volDim,volDim,volDim,numGC); %targMsk = tempMsk;
matlabpool open 8
parfor i0 = 1:numGC
    disp(['building voi mask for GC no. ', num2str(i0), ' of ', num2str(numGC),',']);
    voi = extractROI_3D(seedGCs(:,i0),[leg; leg; leg],LineMask);
    voiCC = bwconncomp(voi); % next few lines through the j0-loop bwselects the central line in voi.
    voiL = labelmatrix(voiCC);
    ctrL = unique(voiL(volCtr)); ctrL(ctrL==0) = []; % last command removes background pixels in set, if any.
    voi = false(size(voi));
    for j0 = 1:length(ctrL)
        ind = voiCC.PixelIdxList{ctrL(j0)};
        voi(ind) = true;
    end
    tempG = convn(single(voi),gballTemp,'same'); 
    
    tempMsk(:,:,:,i0) = tempG./max(tempG(:));    
end
disp('voi mask set complete.');   
matlabpool close

% quality control for tracking. leave behind GCs that do not pass the
% threshold for correlation or drift.
corrThresh = 0.7; driftThresh = round(5/SIv.xyRes); %round(5/SIv.xyRes);
goodGCs = 1:numGC;
badGCcounter = 1;
badGCs = [];
trackMap = zeros(sizY,sizX);

trakVals = zeros(numGC,6,numStacks); trakVals(:,1,:) = repmat((1:numGC)',[1 numStacks]);  

targGCstk = zeros(volDim,volDim,numGC); % vessel for computation
targGCstkA = zeros(volDim,volDim,numGC); % vessel for intensity adjusted output
% initialize the template images from stk seedIdx
disp('preparing seed stack montage.');
[stkStruct, ~] = tiffread2([regDir regList(SIv.seedIdx).name]);
  seedStk = zeros([sizY, sizX, sizZ],'single');
for i0 = 1:sizZ; seedStk(:,:,i0) = single(stkStruct(i0).data);end
clear stkStruct
for j1 = 1:numGC
    rawVoi = extractROI_3D(trackGCs(:,j1,newIdx),[leg; leg; leg],seedStk);
    targVoi = rawVoi.*tempMsk(:,:,:,j1);
    targGCstk(:,:,j1) = max(targVoi,[],3);
    targGCstkA(:,:,j1) = imadjust(uint16(targGCstk(:,:,j1)),stretchlim(uint16(targGCstk(:,:,j1)),0),[]);
    trakVals(j1,2:4,newIdx) = trackGCs(:,j1,newIdx);
    trakVals(j1,5,newIdx) = 1;
end
montStack1 = stak2mont(targGCstk); montStack1A = stak2mont(targGCstkA);
montStack = zeros(size(montStack1,1),size(montStack1,2),numStacks); montStackA = montStack;
montStack(:,:,newIdx) = montStack1; montStackA(:,:,newIdx) = montStack1A;
clear montStack1 montStack1A

targStk = seedStk;
disp('tracking GCs, going up through the stacks...');
for j0 = (newIdx+1):numStacks
    truIdx = j0+startIdx-1;
    disp(['   tracking in stack no. ', num2str(truIdx), ',']);
    [stkStruct, ~] = tiffread2([regDir regList(truIdx).name]);
    inStk = zeros([sizY, sizX, sizZ],'single');
    for i0 = 1:sizZ; inStk(:,:,i0) = single(stkStruct(i0).data);end
    clear stkStruct
    targGCstk = mont2stak(montStack(:,:,j0-1),size(targGCstk));
    for j1 = 1:numGC
        if goodGCs(j1) ~= 0
            
            rawVoi = extractROI_3D(trackGCs(:,j1,j0-1),[leg; leg; leg],inStk);
            tempVoi = rawVoi.*tempMsk(:,:,:,j1);
            [tempGC,~] = max(tempVoi,[],3);
            if sum(tempGC(:)) ~= 0
                targGC = targGCstk(:,:,j1);
                cc = normxcorr2_general(tempGC,targGC);
                [ccDimY,ccDimX] = size(cc);
                ccCentY1 = round(0.5*(ccDimY+1));
                ccCentX1 = round(0.5*(ccDimX+1));
                cc_roi = cc(ccCentY1-leg:ccCentY1+leg,ccCentX1-leg:ccCentX1+leg); % avoiding hot pixels that appear to be produced with this version of normxcorr2_general.
                [max_cc, imax] = max(abs(cc_roi(:)));
                [ypeak, xpeak] = ind2sub(size(cc_roi),imax(1));
                delX = (leg+1)-xpeak; delY = (leg+1)-ypeak;
                idxR = trackGCs(2,j1,j0-1) + delY;
                idxC = trackGCs(1,j1,j0-1) + delX;
                
                rawVoi2 = extractROI_3D([idxC;idxR;trackGCs(3,j1,j0-1)],[leg; leg; leg],inStk);
                tempVoi2 = rawVoi2.*tempMsk(:,:,:,j1);
                tempGCxz = squeeze(max(tempVoi2,[],1))'; % XZ projection
                targVoi = extractROI_3D(trackGCs(:,j1,j0-1),[leg; leg; leg],targStk);
                targVoi2 = targVoi.*tempMsk(:,:,:,j1);
                targGCxz = squeeze(max(targVoi2,[],1))'; % XZ projection
                cc = normxcorr2_general(tempGCxz,targGCxz);
                cc_roi = cc(ccCentY1-leg:ccCentY1+leg,ccCentX1-leg:ccCentX1+leg); % avoiding hot pixels that appear to be produced with this version of normxcorr2_general.
                [~, imax] = max(abs(cc_roi(:)));
                [zpeak, ~] = ind2sub(size(cc_roi),imax(1));
                delZ = (leg+1)-zpeak;
                idxZ = trackGCs(3,j1,j0-1) + delZ;
                
                trakVals(j1,5:6,j0) = [max_cc norm([delX delY delZ])];
                trakVals(j1,2:4,j0) = [idxC idxR idxZ];
                
                if    gt(idxR,leg) && gt(idxC,leg) && gt(idxZ,leg)...
                        && lt(idxR,sizY-leg) && lt(idxC,sizX-leg) && lt(idxZ,sizZ-leg)...
                        && lt(norm([delX delY delZ]),driftThresh) && gt(max_cc,corrThresh)
                    
                    trackGCs(:,j1,j0) = [idxC; idxR; idxZ];
                    rawVoi = extractROI_3D(trackGCs(:,j1,j0),[leg; leg; leg],inStk);
                    targVoi = rawVoi.*tempMsk(:,:,:,j1);
                    targGCstk(:,:,j1) = max(targVoi,[],3);
                    targGCstkA(:,:,j1) = imadjust(uint16(targGCstk(:,:,j1)),stretchlim(uint16(targGCstk(:,:,j1)),0),[]);  
                else
                    badGCs(badGCcounter) = j1;
                    badGCcounter = badGCcounter+1;
                    goodGCs(j1) = 0;
                    targGCstk(:,:,j1) = zeros(volDim,volDim);
                    targGCstkA(:,:,j1) = zeros(volDim,volDim);
                end
            else
                badGCs(badGCcounter) = j1;
                badGCcounter = badGCcounter+1;
                goodGCs(j1) = 0;
                targGCstk(:,:,j1) = zeros(volDim,volDim);
                targGCstkA(:,:,j1) = zeros(volDim,volDim);
            end
        end     
    end
    montStack(:,:,j0) = stak2mont(targGCstk);
    montStackA(:,:,j0) = stak2mont(targGCstkA);
    targStk = inStk;
end

targStk = seedStk;
disp('tracking GCs, going down through the stacks...');
for j0 = (newIdx-1):-1:1
    truIdx = j0+startIdx-1;
    disp(['   tracking in stack no. ', num2str(truIdx), ',']);
    [stkStruct, ~] = tiffread2([regDir regList(truIdx).name]);
    inStk = zeros([sizY, sizX, sizZ],'single');
    for i0 = 1:sizZ; inStk(:,:,i0) = single(stkStruct(i0).data);end
    clear stkStruct
    targGCstk = mont2stak(montStack(:,:,j0+1),size(targGCstk));
    for j1 = 1:numGC
        if goodGCs(j1) ~= 0
            
            rawVoi = extractROI_3D(trackGCs(:,j1,j0+1),[leg; leg; leg],inStk);
            tempVoi = rawVoi.*tempMsk(:,:,:,j1);
            [tempGC,~] = max(tempVoi,[],3);
            if sum(tempGC(:)) ~= 0
                targGC = targGCstk(:,:,j1);
                cc = normxcorr2_general(tempGC,targGC);
                [ccDimY,ccDimX] = size(cc);
                ccCentY1 = round(0.5*(ccDimY+1));
                ccCentX1 = round(0.5*(ccDimX+1));
                cc_roi = cc(ccCentY1-leg:ccCentY1+leg,ccCentX1-leg:ccCentX1+leg); % avoiding hot pixels that appear to be produced with this version of normxcorr2_general.
                [max_cc, imax] = max(abs(cc_roi(:)));
                [ypeak, xpeak] = ind2sub(size(cc_roi),imax(1));
                delX = (leg+1)-xpeak; delY = (leg+1)-ypeak;
                idxR = trackGCs(2,j1,j0+1) + delY;
                idxC = trackGCs(1,j1,j0+1) + delX;
                
                rawVoi2 = extractROI_3D([idxC;idxR;trackGCs(3,j1,j0+1)],[leg; leg; leg],inStk);
                tempVoi2 = rawVoi2.*tempMsk(:,:,:,j1);
                tempGCxz = squeeze(max(tempVoi2,[],1))'; % XZ projection
                targVoi = extractROI_3D(trackGCs(:,j1,j0+1),[leg; leg; leg],targStk);
                targVoi2 = targVoi.*tempMsk(:,:,:,j1);
                targGCxz = squeeze(max(targVoi2,[],1))'; % XZ projection
                cc = normxcorr2_general(tempGCxz,targGCxz);
                cc_roi = cc(ccCentY1-leg:ccCentY1+leg,ccCentX1-leg:ccCentX1+leg); % avoiding hot pixels that appear to be produced with this version of normxcorr2_general.
                [~, imax] = max(abs(cc_roi(:)));
                [zpeak, ~] = ind2sub(size(cc_roi),imax(1));
                delZ = (leg+1)-zpeak;
                idxZ = trackGCs(3,j1,j0+1) + delZ;
                
                trakVals(j1,5:6,j0) = [max_cc norm([delX delY delZ])];
                trakVals(j1,2:4,j0) = [idxC idxR idxZ];
                
                if    gt(idxR,leg) && gt(idxC,leg) && gt(idxZ,leg)...
                        && lt(idxR,sizY-leg) && lt(idxC,sizX-leg) && lt(idxZ,sizZ-leg)...
                        && lt(norm([delX delY delZ]),driftThresh) && gt(max_cc,corrThresh)
                    
                    trackGCs(:,j1,j0) = [idxC; idxR; idxZ];
                    rawVoi = extractROI_3D(trackGCs(:,j1,j0),[leg; leg; leg],inStk);
                    targVoi = rawVoi.*tempMsk(:,:,:,j1);
                    targGCstk(:,:,j1) = max(targVoi,[],3);
                    targGCstkA(:,:,j1) = imadjust(uint16(targGCstk(:,:,j1)),stretchlim(uint16(targGCstk(:,:,j1)),0),[]);
                else
                    badGCs(badGCcounter) = j1;
                    badGCcounter = badGCcounter+1;
                    goodGCs(j1) = 0;
                    targGCstk(:,:,j1) = zeros(volDim,volDim);
                    targGCstkA(:,:,j1) = targGCstk(:,:,j1);
                end
            else
                badGCs(badGCcounter) = j1;
                badGCcounter = badGCcounter+1;
                goodGCs(j1) = 0;
                targGCstk(:,:,j1) = zeros(volDim,volDim);
                targGCstkA(:,:,j1) = zeros(volDim,volDim);
            end
        else
            targGCstk(:,:,j1) = zeros(volDim,volDim); 
            targGCstkA(:,:,j1) = targGCstk(:,:,j1);
        end
         
    end
    montStack(:,:,j0) = stak2mont(targGCstk); 
    montStackA(:,:,j0) = stak2mont(targGCstkA);
    targStk = inStk;
end


goodGCidx = find(goodGCs);

for j0 = numStacks:-1:1
    for j1 = 1:length(goodGCidx)
        trackMap(trackGCs(2,goodGCs(goodGCidx(j1)),j0),trackGCs(1,goodGCs(goodGCidx(j1)),j0)) = goodGCs(goodGCidx(j1));
    end
end

disp(['tracking complete. ', num2str(numel(goodGCidx)) , ' of ', num2str(numGC), ' growth cones tracked successfully through the series.']);
% recording the output, trackGCs, as a 3 by numGC*numStack array.
dlmwrite([si.txt 'TrackGCs.txt'],trackGCs,'\t');

outFile1 = [si.img 'TrackGCMap.tif'];
if exist(outFile1,'file') ~= 0 % delete result of previous run, if it exists.
        delete(outFile1);
end
imwrite(uint16(trackMap),outFile1,'tiff','Compression','none');


outFile2 = [si.img 'TrackGCMontage.tif'];
if exist(outFile2,'file') ~= 0 % delete result of previous run, if it exists.
        delete(outFile2);
end
for j0 = 1:numStacks
    imwrite(uint16(montStackA(:,:,j0)),outFile2,...
                                     'tiff','Compression','none','WriteMode','append');
end

