function s_TurnAngles_v11(si,Ch,SIv)
% _v11 identifies the top center data point in the registered cloud for use
% as input to s_SliceRegister_v5. the coordinates are saved in seedXYZ.txt
% _v10 has the option of using a template file that has more slices than
% the series stacks. this option is triggered by anchorIdx=0.

% asks for a cleaned up opened stack (oStk_clean)

% rotations constrained to the circular arc that splits the imaged sub
% array in half.

% anchorIdx is the stack to be used in extracting the turn angles. 
anchorIdx = SIv.anchorIdx;
%topLim = SIv.TA_stkLims(1); botLim = SIv.TA_stkLims(2);
% directory. reading the previously scaled stacks
if strcmp(Ch,'G')
    dirName = si.scaG; 
else
    dirName = si.scaR;   
end
stackDir  = dir([dirName '*.tif']);
% reading the input image stack
disp('reading the anchor stack...');
if anchorIdx==0
    anchorPath = [si.img 'template' Ch '_sca.tif'];
    [~, sizZsub] = tiffread2([dirName stackDir(1).name]);
    difZ = round(SIv.templateOffset/SIv.xyRes);
else
    anchorPath = [dirName stackDir(anchorIdx).name];
    difZ = 0;
end
[stkStruct, sizZ] = tiffread2(anchorPath);
if anchorIdx~=0; sizZsub = sizZ; end
sizX = stkStruct(1).width; sizY = stkStruct(1).height;    
inStk = zeros([sizY, sizX, sizZ],'single');
% inStkG01 = inStk; inStkG10 = inStk;
disp('background subtraction...');
for i0 = 1:sizZ;
    inStk(:,:,i0) = single(stkStruct(i0).data);
%     inStkG01(:,:,i0) = imgaussian(inStk(:,:,i0),1);
%     inStkG10(:,:,i0) = imgaussian(inStk(:,:,i0),10);
end

inStkG01 = imgaussian(inStk,1);
inStkG10 = imgaussian(inStk,10);

inStkNet = single(uint16(inStkG01-inStkG10)); % background subtracted stack
clear stkStruct inStkG01 inStkG10

disp('opening the background segmented stack. takes a couple of minutes...');
eLeg = round(1.2/SIv.xyRes);
eDim = 2*eLeg+1;
eBox = zeros(eDim,eDim,eDim); eBox(eLeg+1,eLeg+1,eLeg+1) = 1;
eBox = bwdist(eBox)<eLeg+1;
oStk = imopen(inStkNet,eBox);


fileName = [si.img 'oStk.tif'];
if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
    delete(fileName);
end
for t0 = 1:size(oStk,3)
    imwrite(uint16(oStk(:,:,t0)),[si.img 'oStk.tif'],...
                                     'tiff','Compression','none','WriteMode','append');
end
% interrupt further processing while user fixes the oStk
while exist([si.img 'oStk_fx.tif'],'file') == 0
    disp('waiting for fixed opened stk...');
    pause(60)
end
disp('received fixed opened stk, moving on...');
oStkH = TIFFStack([si.img 'oStk_fx.tif']);
oStk = oStkH(:,:,:);

disp('k-means segmentation...');
[~,kMsk] = kmeans_oa_v(oStk,find(oStk(:)),5);

disp('masking regional maxima with opened and segmented stack...');
% mxMsk = (kMsk>1).*imregionalmax(inStkNet);
regMx = imregionalmax(inStkNet);
mxMsk = (kMsk>0).*regMx;

ctrStrct = regionprops(bwconncomp(mxMsk),'centroid');
ctrSubs = zeros(length(ctrStrct),3);
for i0 = 1:length(ctrStrct); ctrSubs(i0,:) = round(ctrStrct(i0).Centroid); end
% test = ctrSubs;
ctrSubs(:,3) = ctrSubs(:,3)-difZ;

disp('sphere filtering to identify intensity maxima in the medulla...');
[k3,ctr3,rad3,v3,~] = sInt_filtSphfit_v2(ctrSubs,0.05);
suite_plotEllfit(ctrSubs(k3,1),ctrSubs(k3,2),ctrSubs(k3,3),ctr3,rad3,v3);

disp('ellipsoid fitting to medulla maxima to extract rotation matrix...');
[A , c] = MinVolEllipse(ctrSubs(k3,:)', 0.01);
figure
plot3(ctrSubs(k3,1),ctrSubs(k3,2),ctrSubs(k3,3),'*');
hold on
Ellipse_plot(A,c);

[~, Q V] = svd(A);
ellRad = zeros(1,3);
ellRad(1) = 1/sqrt(Q(1,1));
ellRad(2) = 1/sqrt(Q(2,2));
ellRad(3) = 1/sqrt(Q(3,3));
[~,zAx] = min(ellRad); % the transformed reference frame z axis should always correspond to the smallest radius.

V2 = repmat(sign(diag(V))',[3 1]).*V; % aligning the ellipse axis vectors with the (+) direction.
% i'd like to align the transformed y axis with the chiasm. in general, this should be the largest radius.
% however, another 'constant' of this axis is that between the transformed
% x and y axes, it should have the greatest component along the original z
% axis.
[~,zPidx] = sort(sum(repmat([0; 0; 1], [1,3]).*V2,1),'descend'); % z projection indices, sorted in descending order
yAx = zPidx(1); if yAx == zAx; yAx = zPidx(2); end
xAx = setdiff(1:3,[zAx yAx]);

V3 = [V2(:,xAx) V2(:,yAx) V2(:,zAx)];

iV = eye(3)/V3;
FijiXform = eye(4);
FijiXform(1:3,1:3) = iV;

ZcorrAng = 0;
% optional correction (in degrees) for non-aligned z axis. user needs to check the
% transformed image, produced below to decide if this is required. ugh.
% note2self: you could automate this, and apply the know how to turnangles,
% by transforming the point cloud first, taking a z projection and
% exploring the grid parameters in the center.
ZcorrMat = make_transformation_matrix([0 0 0],[0 0 ZcorrAng],[1 1 1],[]);
FijiXform = ZcorrMat*FijiXform;
iV = FijiXform(1:3,1:3);


dlmwrite([si.txt 'FijiXform.txt'],FijiXform,'\t');


orgPts = ctrSubs(k3,:)';
rotPts = zeros(size(orgPts));
oriSft = 0.5*[sizX;sizY;sizZ];
for i0 = 1:length(k3)
    rotPts(:,i0) = (iV*(orgPts(:,i0)-oriSft))+oriSft;
end

figure, plot3(rotPts(1,:),rotPts(2,:),rotPts(3,:),'b*');
hold on
plot3(orgPts(1,:),orgPts(2,:),orgPts(3,:),'r*');

disp('decomposing rotation matrix to define turn angles...');
% decomposing the transformation matrix into X*Y*Z rotation
% matrices. Z first, then Y, X last.
k = -2:2;
yDeg = ((-1).^k)*asind(FijiXform(1,3)) + 180*k;
yDeg = yDeg(gt(yDeg,-180) & le(yDeg,180)); % two possible values

xDeg = [-(((-1).^k).*asind(FijiXform(2,3)./cosd(yDeg(1)))+ 180*k)...
       -(((-1).^k).*asind(FijiXform(2,3)./cosd(yDeg(2)))+ 180*k)];
xDeg = sort(xDeg(gt(xDeg,-180) & le(xDeg,180)),'ascend'); % four possible values
   
zDeg = [-(((-1).^k).*asind(FijiXform(1,2)./cosd(yDeg(1)))+ 180*k)...
       -(((-1).^k).*asind(FijiXform(1,2)./cosd(yDeg(2)))+ 180*k)];
zDeg = sort(zDeg(gt(zDeg,-180) & le(zDeg,180)),'ascend'); % four possible values

thCom = zeros(3,4,2,4); % sticking to XYZ convention to avoid confusion
thCom(1,1,:,:) = xDeg(1); thCom(1,2,:,:) = xDeg(2); thCom(1,3,:,:) = xDeg(3); thCom(1,4,:,:) = xDeg(4);
thCom(2,:,1,:) = yDeg(1); thCom(2,:,2,:) = yDeg(2); 
thCom(3,:,:,1) = zDeg(1); thCom(3,:,:,2) = zDeg(2); thCom(3,:,:,3) = zDeg(3); thCom(3,:,:,4) = zDeg(4);

thComR = reshape(thCom,[3,32])';
eqVal = zeros(32,1);

for i0 = 1:32
    th = thComR(i0,:);
    x = th(1); y = th(2); z = th(3);
    rotmat = zeros(3,3);
    % entries for the rotation matrix X*Y*Z using the definition of right-handed principle axis rotations 
    rotmat(1,1) = cosd(y)*cosd(z);
    rotmat(1,2) = -cosd(y)*sind(z);
    rotmat(1,3) = sind(y);
    rotmat(2,1) = sind(x)*sind(y)*cosd(z) + cosd(x)*sind(z);
    rotmat(2,2) = -sind(x)*sind(y)*sind(z) + cosd(x)*cosd(z);
    rotmat(2,3) = -sind(x)*cosd(y);
    rotmat(3,1) = -cosd(x)*sind(y)*cosd(z) + sind(x)*sind(z);
    rotmat(3,2) = cosd(x)*sind(y)*sind(z) + sind(x)*cosd(z);
    rotmat(3,3) = cosd(x)*cosd(y);
    eqVal(i0) = isequal(round(10000*rotmat),round(10000*iV));
end

kEq = find(eqVal);
[~,minZidx] = min(abs(thComR(kEq,3))); % if there are more than one set of angles, pick the one with the smallest absolute z component.
zDegFiji = thComR(kEq(minZidx),3);
yDegFiji = thComR(kEq(minZidx),2);
xDegFiji = thComR(kEq(minZidx),1);

disp('recording turn angles...');
outHeader = {'zdegFiji' 'xdegFiji' 'ydegFiji'};
outData = num2cell([zDegFiji xDegFiji yDegFiji]);
dlmcell([si.txt 'TurnAngles.txt'],[outHeader; outData]);   

disp('recording the medulla int. maxima to ShellSeed stack...');

kSub = find(ge(ctrSubs(k3,3),1) & le(ctrSubs(k3,3),sizZsub));
objX = ctrSubs(k3(kSub),1);
objY = ctrSubs(k3(kSub),2);
objZ = ctrSubs(k3(kSub),3);
Mask = zeros([sizY,sizX,sizZsub],'uint8');
Mask(sub2ind([sizY,sizY,sizZsub],objY,objX,objZ)) = 1;

% write the shell seed to output directory
fileName = [si.img 'ShellSeed.tif'];
if exist(fileName,'file') ~= 0 % delete result of previous run, if it exists.
    delete(fileName);
end
for i1 = 1:size(Mask,3)
    imwrite(uint8(255.*double(Mask(:,:,i1))),fileName,...
        'tiff','Compression','none','WriteMode','append');
end

% finding the top-center point in the registered array to be used as input to s_SliceRegister_v5
topPool = round(0.05*size(k3(kSub),2)); % we'll be searching in the top 5% of the data points.
[s_v,s_i] = sort(rotPts(3,kSub),'ascend');
topX = rotPts(1,s_i(1:topPool));
topY = rotPts(2,s_i(1:topPool));
topZ = rotPts(3,s_i(1:topPool));
meanX = mean(topX); meanY = mean(topY);
[min_v,min_i] = min( (topX-meanX).^2 + (topY-meanY).^2);

figure, plot3(rotPts(1,kSub),rotPts(2,kSub),rotPts(3,kSub),'k+');
hold on
plot3(topX,topY,topZ,'bo');
plot3(topX(min_i),topY(min_i),topZ(min_i),'r*');

k_TopCent = s_i(min_i);
seedX = objX(k_TopCent);
seedY = objY(k_TopCent);
seedZ = objZ(k_TopCent);

dlmwrite([si.txt 'seedXYZ.txt'],[seedX seedY seedZ],'\t');


