function si = s_buildSIstruct_v1(SIv)

% constant suite input
SIc = {'scope_output/','one/','odd/','even/',... % series specific folder
                'figures/',... % post-processing output folder
                'fijiScripts/',... % scripts used to process stacks
                'grn/','rawG/','scaG/','jitG/','regG/','reRawG/',... % grn Ch stack folders
                'red/','rawR/','scaR/','jitR/','regR/','reRawR/',... % red Ch stack folders
                   'suite_output/','img_files/','txt_files/', 'mat_files/',... % output directory
                      'mFiji_Global/','mFiji_Local/','mFiji_Jitter/','mFiji_GlobalFx/','mFiji_LocalG/','mFiji_LocalR/'}; 
dateDir = [SIv.homeDrive SIv.dateDir];

scopDir = [dateDir SIc{1}];
oneDir = [dateDir SIc{2}]; oddDir = [dateDir SIc{3}]; eveDir = [dateDir SIc{4}];

soDir = SIc{19};
imgDir = [SIc{19} SIc{20}]; txtDir = [SIc{19} SIc{21}];
matGlo = [SIc{19} SIc{22} SIc{23}]; matLoc = [SIc{19} SIc{22} SIc{24}]; matJit = [SIc{19} SIc{22} SIc{25}]; matGloFx = [SIc{19} SIc{22} SIc{26}];
matLocG = [SIc{19} SIc{22} SIc{27}]; matLocR = [SIc{19} SIc{22} SIc{28}]; 



scrpDir = SIc{6};
figDir = SIc{5};

gRaw = [SIc{7} SIc{8}];   gSca = [SIc{7} SIc{9}];   gJit = [SIc{7} SIc{10}];  gReg = [SIc{7} SIc{11}];  gRw2 = [SIc{7} SIc{12}]; 
rRaw = [SIc{13} SIc{14}]; rSca = [SIc{13} SIc{15}]; rJit = [SIc{13} SIc{16}]; rReg = [SIc{13} SIc{17}]; rRw2 = [SIc{13} SIc{18}]; 


% building the directory deals with the entire future contents of the dated
% directory.
if ~exist(scopDir,'dir') % the existence of this folder suggests that this script was run before
    mkdir(scopDir);
    if(SIv.numFly) == 1 % only one fly was imaged
        mkdir(oneDir);
        mkdir([oneDir scrpDir]); mkdir([oneDir figDir]);
        mkdir([oneDir soDir]); mkdir([oneDir imgDir]); mkdir([oneDir txtDir]);
        mkdir([oneDir matGlo]); mkdir([oneDir matJit]); mkdir([oneDir matGloFx]);
        mkdir([oneDir gRaw]); mkdir([oneDir gSca]); mkdir([oneDir gJit]); mkdir([oneDir gReg]); mkdir([oneDir gRw2]);
        if (SIv.numCh) == 2 % the line above assumes that when numCh=1, it will be grn.
            mkdir([oneDir rRaw]); mkdir([oneDir rSca]); mkdir([oneDir rJit]); mkdir([oneDir rReg]); mkdir([oneDir rRw2]);
            mkdir([oneDir matLocG]); mkdir([oneDir matLocR]);
        else
            mkdir([oneDir matLocG]);
        end
    else
        % odd file stucture
        mkdir(oddDir);
        mkdir([oddDir scrpDir]); mkdir([oddDir figDir]);
        mkdir([oddDir soDir]); mkdir([oddDir imgDir]); mkdir([oddDir txtDir]);
        mkdir([oddDir matGlo]); mkdir([oddDir matJit]); mkdir([oddDir matGloFx]);
        mkdir([oddDir gRaw]); mkdir([oddDir gSca]); mkdir([oddDir gJit]); mkdir([oddDir gReg]); mkdir([oddDir gRw2]);
        if (SIv.numCh) == 2 % the line above assumes that when numCh=1, it will be grn.
            mkdir([oddDir rRaw]); mkdir([oddDir rSca]); mkdir([oddDir rJit]); mkdir([oddDir rReg]); mkdir([oddDir rRw2]);
            mkdir([oddDir matLocG]); mkdir([oddDir matLocR]);
        else
            mkdir([oddDir matLocG]);
        end
        % even file stucture
        mkdir(eveDir);
        mkdir([eveDir scrpDir]); mkdir([eveDir figDir]);
        mkdir([eveDir soDir]); mkdir([eveDir imgDir]); mkdir([eveDir txtDir]);
        mkdir([eveDir matGlo]); mkdir([eveDir matJit]); mkdir([eveDir matGloFx]);
        mkdir([eveDir gRaw]); mkdir([eveDir gSca]); mkdir([eveDir gJit]); mkdir([eveDir gReg]); mkdir([eveDir gRw2]);
        if (SIv.numCh) == 2 % the line above assumes that when numCh=1, it will be grn.
            mkdir([eveDir rRaw]); mkdir([eveDir rSca]); mkdir([eveDir rJit]); mkdir([eveDir rReg]); mkdir([eveDir rRw2]);
            mkdir([eveDir matLocG]); mkdir([eveDir matLocR]);
        else
            mkdir([eveDir matLocG]);
        end
    end
end
        
if (SIv.numFly) == 1
    topDir = oneDir;
else
    if strcmp((SIv.parFly),'odd')
        topDir = oddDir;
    else
        topDir = eveDir;
    end
end
% the output, SIs, is series specific.
si = struct('rawG', [topDir gRaw],'scaG',[topDir gSca],'jitG',[topDir gJit],'regG',[topDir gReg],'reRawG',[topDir gRw2],...
             'rawR', [topDir rRaw],'scaR',[topDir rSca],'jitR',[topDir rJit],'regR',[topDir rReg],'reRawR',[topDir rRw2],...
             's_output', [topDir soDir],'img',[topDir imgDir],'txt',[topDir txtDir],...
             'mGlo',[topDir matGlo],'mLocG',[topDir matLocG],'mLocR',[topDir matLocR],...
             'mJit',[topDir matJit],'mGloFx',[topDir matGloFx],...
             'fig', [topDir figDir],'Fiji',[topDir scrpDir]);
            





