function s_devTime(si,SIv)

% calculates developmental time for the time series
d =  dir([si.txt 'TimeStamps_All.txt']);
fid = fopen([si.txt d.name]);
fulTxt = textscan(fid,'%s')';
fclose(fid);
fulTxt = fulTxt{:}';

numStks = numel(fulTxt)/3;
hrsAPF = zeros(numStks,1);
d0 = datenum(SIv.stagingDate);

for i0 = 1:numStks
    s1 = [cell2mat(fulTxt(3*i0-1)) ' ' cell2mat(fulTxt(3*i0))];
    d1 = datenum(s1);
    if strcmp(SIv.stagingMode,'he')
        hrsAPF(i0) = 0.01*round(100*(24*(d1-d0)+12));
    else
        hrsAPF(i0) = 0.01*round(100*(24*(d1-d0)));
    end
end

dlmwrite([si.txt 'hrsAPF.txt'],hrsAPF);