function K = Fiji2Kroon(F)

% separate the affine transformation matrix into rotation, Fr, and
% translation, Ft, components.
if numel(F) == 9
    F4 = eye(4);
    F4(1:2,1:2) = F(1:2,1:2);
    F4(1:2,4) = F(1:2,3);
    F = F4;
end

Fr = eye(4);
Fr(1:3,1:3) = F(1:3,1:3);
Ft = Fr\F;

K = [F(2,2) F(1,2) F(3,2) -Ft(2,4);
    F(2,1) F(1,1) F(3,1) -Ft(1,4);
    F(2,3) F(1,3) F(3,3) -Ft(3,4);
    0      0      0       1];
