function F = Kroon2Fiji(K)

% separate the affine transformation matrix into rotation, Fr, and
% translation, Ft, components.
if numel(K) == 9
    K4 = eye(4);
    K4(1:2,1:2) = K(1:2,1:2);
    K4(1:2,4) = K(1:2,3);
    K = K4;
end

Kr = eye(4);
Kr(1:3,1:3) = K(1:3,1:3);
Kt = Kr\K;

F = [K(2,2) K(1,2) K(3,2) -Kt(2,4);
     K(2,1) K(1,1) K(3,1) -Kt(1,4);
     K(2,3) K(1,3) K(3,3) -Kt(3,4);
     0      0      0       1];
 
%  Fr = [K(2,2) K(1,2) K(3,2) 0;
%      K(2,1) K(1,1) K(3,1) 0;
%      K(2,3) K(1,3) K(3,3) 0;
%      0      0      0       1];
%  Ft = eye(4);
%  Ft(1:3,4) = [-Kt(2,4);-Kt(1,4);-Kt(3,4)];
%  F = Fr*Ft;