function roi = extractROI_3D(center,legs,fullIM)

% performs out of bounds subscript calcs for cropping out a roi centered at center(x,y,z) coordinates
% with dims (2*legs(1)+1, 2*legs(2)+1,2*legs(3)+1), with leg(1) the x dim, from an
% original image of size fullsize(x,y,z).
if ~iscolumn(center)
    center = center';
end
if ~iscolumn(legs)
    legs = legs';
end

dim1 = 2*legs(1)+1; dim2 = 2*legs(2)+1; dim3 = 2*legs(3)+1;
roi = zeros(dim2,dim1,dim3,class(fullIM));
fullSize = [size(fullIM,2); size(fullIM,1); size(fullIM,3)]; 
oriXYZ = center;
LoIdxRHS = oriXYZ - legs;
LoIdxLHS = [1;1;1];
kLoOOB = find(LoIdxRHS < 1);
if ~isempty(kLoOOB)
    LoIdxLHS(kLoOOB) = LoIdxLHS(kLoOOB)+(1-LoIdxRHS(kLoOOB));
    LoIdxRHS(kLoOOB) = 1;
end

HiIdxRHS = oriXYZ + legs;
HiIdxLHS = [dim1; dim2; dim3];
%fullSize = [sizX; sizY];
kHiOOB = find(HiIdxRHS./fullSize > 1);
if ~isempty(kHiOOB)
        HiIdxLHS(kHiOOB) = HiIdxLHS(kHiOOB) - (HiIdxRHS(kHiOOB)-fullSize(kHiOOB));
        HiIdxRHS(kHiOOB) = fullSize(kHiOOB);
end
roi(LoIdxLHS(2):HiIdxLHS(2), LoIdxLHS(1):HiIdxLHS(1), LoIdxLHS(3):HiIdxLHS(3)) =...
    fullIM(LoIdxRHS(2):HiIdxRHS(2),LoIdxRHS(1):HiIdxRHS(1), LoIdxRHS(3):HiIdxRHS(3));