function [kOut,ctr3,rad3,v3,counter] = sInt_filtSphfit_v3(objSubs,seedSide,distThresh)
% inputs: 
% SIv: variable suite inputs 
% distThresh: fraction of the radius
% objSubs: concatenated column vectors of XYX coordinates
% outputs:
% k0: indices of the surviving coordinates
% cntr1,rad1,v1: final sphere fit parameters

% rel2Sph are the distances of all coordinates to
% sphere/ellipdoidal surface. positive value indicates inside the sphere,
% negative outside.

x0 = objSubs(:,1); y0 = objSubs(:,2); z0 = objSubs(:,3);
[ctr0,rad0,~,v0] = ellipsoid_fit([x0 y0 z0],3); % sphere fit to obj coordinates
% in my data sets, most of the noise i'm trying to filter out comes from
% 'above' the medulla array. in the first round of fitting, these
% extra/unwanted data points move the fit 'up' leading to the medulla array
% derived coordinates to lay inside the sphere.

% suite_plotEllfit(x0,y0,z0,ctr0,rad0,v0);

valSph0 = v0(1) *x0.*x0 +   v0(2) * y0.*y0 + v0(3) * z0.*z0 + ...
       2*v0(4) *x0.*y0 + 2*v0(5)*x0.*z0 + 2*v0(6) * y0.*z0 + ...
       2*v0(7) *x0    + 2*v0(8)*y0    + 2*v0(9) * z0; % value is >1 inside, and <1 outside
if strcmp(seedSide,'out')
    k0 = find(valSph0 <= 1);
else
    k0 = find(valSph0 >= 1);
end

x1 = objSubs(k0,1); y1 = objSubs(k0,2); z1 = objSubs(k0,3);
[ctr1,rad1,~,v1] = ellipsoid_fit([x1 y1 z1],3); % second round of fitting.
% use the second round fit to catch points that were missed in the first
% round of filtering. use a generous threshold now; this will be refined
% later.

% suite_plotEllfit(x1,y1,z1,ctr1,rad1,v1);

p1 = [v1(1) v1(2) v1(3) 2*v1(4) 2*v1(5) 2*v1(6) 2*v1(7) 2*v1(8) 2*v1(9) -1];
[dist2Sph1,~] = pqdist([x0'; y0'; z0'], p1);
k1 = find(dist2Sph1 <= 0.1*rad1(1));


% moving on to older code, which filters the data based on the distance
% threshold.
x2 = objSubs(k1,1); y2 = objSubs(k1,2); z2 = objSubs(k1,3);
[ctr2,rad2,~,v2] = ellipsoid_fit([x2 y2 z2],3); % third round of fitting.

% suite_plotEllfit(x2,y2,z2,ctr2,rad2,v2);

[k3,ctr3,rad3,v3,counter] = sInt_filtSphfit(x2,y2,z2,rad2,v2,distThresh);

% suite_plotEllfit(x2(k3),y2(k3),z2(k3),ctr3,rad3,v3);
kOut = k1(k3);