function [k0,ctr1,rad1,v1,counter] = s_filtSphfit(c0,r0,z0,radii,v,distThresh)
% inputs: distThresh is a fractional value. it is a multiplier of the radius
% outputs: k0 are the indices of the coordinates that pass the distance
% constraint. rel2Sph are the distances of all coordinates to
% sphere/ellipdoidal surface. positive value indicates inside the sphere,
% negative outside.
p = [v(1) v(2) v(3) 2*v(4) 2*v(5) 2*v(6) 2*v(7) 2*v(8) 2*v(9) -1];
x=c0';y=r0';z=z0';
[dist2Sph,~] = pqdist([x; y; z], p);
valSph = v(1) *x.*x +   v(2) * y.*y + v(3) * z.*z + ...
       2*v(4) *x.*y + 2*v(5)*x.*z + 2*v(6) * y.*z + ...
       2*v(7) *x    + 2*v(8)*y    + 2*v(9) * z; % value is >1 inside, and <1 outside
rel2Sph = sign(valSph-1).*dist2Sph;   
[mu,relMask] = kmeans_oa(round(rel2Sph),1:numel(rel2Sph),3);
% find the clusters whose means are less than the distThresh fraction of
% the radius
muSml = find(lt(abs(mu),distThresh*radii(1)*ones(size(mu))));

x1 = c0'; y1 = r0'; z1 = z0';
counter = 0;
if numel(muSml)==numel(mu)
    k0 = 1:numel(c0);
    [ ctr1, rad1, ~, v1 ] = ellipsoid_fit([x1' y1' z1'],3);
else
    while numel(muSml)~=numel(mu) % refit and refilter until all clusters fall inside threshold
        k1 = [];
        for i0 = 1:numel(muSml)
            k11 = find(relMask==muSml(i0));
            k1 = [k1 k11];
        end
        x1 = x1(k1); y1 = y1(k1); z1 = z1(k1);
        [ ctr1, rad1, ~, v1 ] = ellipsoid_fit([x1' y1' z1'],3);
        p1 = [v1(1) v1(2) v1(3) 2*v1(4) 2*v1(5) 2*v1(6) 2*v1(7) 2*v1(8) 2*v1(9) -1];
        [dist2Sph1,~] = pqdist([x1; y1; z1], p1);
        valSph1 = v1(1)*x1.*x1 +   v1(2)*y1.*y1 +   v1(3)*z1.*z1 + ...
            2*v1(4)*x1.*y1 + 2*v1(5)*x1.*z1 + 2*v1(6)*y1.*z1 + ...
            2*v1(7)*x1     + 2*v1(8)*y1     + 2*v1(9)*z1; % value is >1 inside, and <1 outside
        rel2Sph1 = sign(valSph1-1).*dist2Sph1;
        [mu,relMask] = kmeans_oa(round(rel2Sph1),1:numel(rel2Sph1),3);
        muSml = find(lt(abs(mu),distThresh*rad1(1)*ones(size(mu))));
        counter = counter+1;
    end
    [~,k0,~] = intersect([x;y;z]',[x1;y1;z1]','rows'); 
end

