function regDims = s_readFijiXformLims_v2(si)
d =  dir([si.Fiji 'xform*']);
fid = fopen([si.Fiji d.name]);
fulTxt = textscan(fid,'%c')';
fclose(fid);
fulTxt = fulTxt{:}'; % full text of the script

% define the line with the TransformJ Embed command
e1 = strfind(fulTxt,'Embed');
e11 = strfind(fulTxt(e1:end),';');
embTxt = fulTxt(e1:(e11(1)+e1-1));
eqPos = strfind(embTxt,'='); % position of the equals signs
xPos = regexp(embTxt(eqPos(1):eqPos(2)),'\d');
xSiz = str2double(embTxt(xPos+eqPos(1)-1)); % new x-size of stack
yPos = regexp(embTxt(eqPos(2):eqPos(3)),'\d');
ySiz = str2double(embTxt(yPos+eqPos(2)-1)); % new y-size of stack
zPos = regexp(embTxt(eqPos(3):eqPos(4)),'\d');
zSiz = str2double(embTxt(zPos+eqPos(3)-1)); % new z-size of stack

% define the line with the TransformJ Crop command
c1 = strfind(fulTxt,'Crop');
c11 = strfind(fulTxt(c1:end),';');
crpTxt = fulTxt(c1:(c11(1)+c1-1));
eqPos = strfind(crpTxt,'='); % position of the equals signs
cmmPos = strfind(crpTxt,',');% position of the commas

x1Pos = regexp(crpTxt(eqPos(1):cmmPos(2)),'\d');
x1Lim = str2double(crpTxt(x1Pos+eqPos(1)-1)); % xLimTop
x2Pos = regexp(crpTxt(cmmPos(2):eqPos(2)),'\d');
x2Lim = str2double(crpTxt(x2Pos+cmmPos(2)-1)); % xLimBot

y1Pos = regexp(crpTxt(eqPos(2):cmmPos(3)),'\d');
y1Lim = str2double(crpTxt(y1Pos+eqPos(2)-1)); % xLimTop
y2Pos = regexp(crpTxt(cmmPos(3):eqPos(3)),'\d');
y2Lim = str2double(crpTxt(y2Pos+cmmPos(3)-1)); % xLimBot

z1Pos = regexp(crpTxt(eqPos(3):cmmPos(4)),'\d');
z1Lim = str2double(crpTxt(z1Pos+eqPos(3)-1)); % zLimTop
z2Pos = regexp(crpTxt(cmmPos(4):end),'\d');
z2Lim = str2double(crpTxt(z2Pos+cmmPos(4)-1)); % zLimBot

% creating the output structure
regDims = struct('regX',xSiz,'regY',ySiz,'regZ',zSiz,...
                 'xTop',x1Lim,'xBot',x2Lim,...
                 'yTop',y1Lim,'yBot',y2Lim,...
                 'zTop',z1Lim,'zBot',z2Lim);  
