function [zf,xf,yf] = sint_gritfitExt(cloud,dims,density)
% inputs:
% cloud: n x 3 array of the x,y,z coordinates of the data points
% dims: 1 x 2 array of x,y dimensions of the source volume
% density: number of data points per node tile
% overlap (internal): fraction of angular overlap between two neighboring
% 'lanes' of 6 total. value must be in [0,1/3).
ang = 3;
overlap = 1/3;
padCoef = 0; % option to extend the gridfit domain beyond the image boundaries.

X0 = cloud(:,1); Y0 = cloud(:,2); Z0 = cloud(:,3);
sizX = dims(1); sizY = dims(2); %sizZ = dims(3);
xPad = round(padCoef*sizX); yPad = round(padCoef*sizY);

idx2D = sub2ind([sizY sizX],Y0,X0);
mip2D = zeros(sizY,sizX);
mip2D(idx2D) = 1;
stats = regionprops(mip2D,'ConvexArea','ConvexImage','Extrema'); 
e = stats.Extrema; eXi = 0.5+min(e(:,1)); eXf = max(e(:,1))-0.5;
eYi = 0.5+min(e(:,2)); eYf = max(e(:,2))-0.5;
cvxIm = zeros(sizY,sizX);
cvxIm(eYi:eYf,eXi:eXf) = stats.ConvexImage; %

% turns out 40 is the magic number. this construction ensures nodeSpace =
% 40;
nodeSpace = min(100,round(sqrt(density*stats.ConvexArea/numel(X0)))); % density number of  objects / tile, empirical.

% se = strel('disk', round(nodeSpace));
% cvxMsk = imerode(cvxIm,se);
cvxMsk = cvxIm;

[rad oX oY] = max_inscribed_circle(im2uint8(bwperim(cvxIm)), 0); % smallest inscribed circle
% rad = sqrt(stats.ConvexArea/pi); % radius of the circle with the same area as the convex area covered by the 2D projection of the cloud.
lane = 2*rad*sind(0.5*(ang/(1-overlap))); % secant length of 60/(1-overlap) degree arc
s = nodeSpace/sqrt(density); % trace spacing, linked to linearized 'density'
tNum = 1+2*ceil(0.5*(lane/s)); % number of traces
s = lane/(tNum-1);

[rCvx,cCvx] = find(cvxIm);
ori = [mean(cCvx) mean(rCvx)];
% tl = [1 1]; tr = [sizX 1]; bl = [1 sizY]; br = [sizX sizY];
tl = [1-xPad 1-yPad]; tr = [sizX+xPad 1-yPad]; bl = [1-xPad sizY+yPad]; br = [sizX+xPad sizY+yPad];
tSpan = max([norm(tl-ori) norm(tr-ori) norm(bl-ori) norm(br-ori)]); % half-length of the traces
tSpan = ceil(tSpan/s)*s;
tY = ori(2)-tSpan:s:ori(2)+tSpan;
tY = repmat(tY',[1 tNum]);
tX = s*(-0.5*(tNum-1):0.5*(tNum-1))+ori(1);
tX = repmat(tX,[size(tY,1) 1]);

% xnodes = unique([1:0.5*nodeSpace:sizX sizX]);
% ynodes = unique([1:0.5*nodeSpace:sizY sizY]);
xnodes = unique([(1-xPad):0.5*nodeSpace:(sizX+xPad) (sizX+xPad)]);
ynodes = unique([(1-yPad):0.5*nodeSpace:(sizY+yPad) (sizY+yPad)]);
[zg,xg,yg] = gridfit(X0,Y0,Z0,...
                     xnodes,ynodes,'smoothness',3); % gridfit the data
% figure, plot3( objX, objY, objZ, '.r' );
% axis equal
% hold on;
% p = surf(xg,yg,zg);
% set( p, 'FaceColor', 'g','FaceAlpha',0.5 );

skirt = [];
for r0 = 1:(180/ang)
%     r0
    for t0 = 1:tNum
%         t0
        [theta,rho] = cart2pol(tX(:,t0)-ori(1),tY(:,t0)-ori(2));
        theta = theta + r0*pi*(ang/180);
        [tXr,tYr] = pol2cart(theta,rho);
        tXr = tXr+ori(1); tYr = tYr+ori(2); % rotated trace coordinates
        kXim = find(tXr>=1 & tXr<=sizX);
        kYim = find(tYr>=1 & tYr<=sizY);
        kIm = intersect(kXim,kYim);
        tXim = tXr(kIm); tYim = tYr(kIm); % trace coordinates inside image boundries.
        idxIm = sub2ind([sizY sizX],round(tYim),round(tXim));
        val = cvxMsk(idxIm);
        if any(val==0) % only enter the calculation if there are any trace points outside the convex mask
            tZim = interp2(xg,yg,zg,tXim,tYim);
            idxVal1 = find(val); % indices of the trace that fall inside the eroded convex image
            idxVal0 = setdiff(1:numel(val),idxVal1); % indices of the trace that fall outside the eroded concev image
            % choose the axis with the largest number of unique values;
            % i.e. avoid vertical lines.
            [~,axs] = max([range(tXim(idxVal1)) range(tYim(idxVal1))]);
            if axs == 1
                ord1 = tXim(idxVal1); % ordinate
                ord0 = tXim(idxVal0);
                topLim = sizX;
            else
                ord1 = tYim(idxVal1); % ordinate
                ord0 = tYim(idxVal0);
                topLim = sizY;
            end
            
%             nots = range(tYim(idxVal1))*([0 1 3 8 10 11]/11) + min(tYim(idxVal1));
            if numel(idxVal1) > 30
                nots = range(ord1)*([0 5 10]/10) + min(ord1);
            else
                nots = range(ord1)*(5/10) + min(ord1);
            end
            nots = [1 nots topLim];
            
            slm = slmengine(ord1,tZim(idxVal1),'degree',3,'knots',nots,'endconditions','natural','plot','off');
            
            nZ = slmeval(ord0,slm,0);
            skirt = [skirt; [tXim(idxVal0) tYim(idxVal0) nZ]];
        end
    end
end

ext = [cloud;double(skirt)];
X1 = ext(:,1); Y1 = ext(:,2); Z1 = ext(:,3);
[zf,xf,yf] = gridfit(X1,Y1,Z1,...
                     xnodes,ynodes,'smoothness',3); % gridfit the data
% figure, plot3( X1, Y1, Z1, '.r' );
% axis equal
% hold on;
% p = surf(xf,yf,zf);
% plot3( skirt(:,1), skirt(:,2), skirt(:,3), '.b' );
% set( p, 'FaceColor', 'g','FaceAlpha',0.5 );








