function [algnCtrSca1, algnCtrReg1] = sint_mapGCcents(L,XformFiji,regDims,M_gc,ang1,M_t1rev,M_t2rev)
% the function align_GCs uses images voi centered 'L' pixels (6 microns,
% specified in SIv.gcDims) from the tracked GC coordinates, which were
% seeded from the weighted intensity maxima of GC volumes in DefineGCs.
% this internal function takes the post-alignment coordinates (algnCtr1) of the GC
% center in the image voi, transforms them back to the pre-alignment space
% and repositions them in the full sized sca or reg space.
algnCtr1 = [0; -L*cosd(ang1); -L*sind(ang1)];
algnOri = M_gc(4,1:3); % these three values are the L-displaced centers that are used to extract pre-alingment vois. 
M_gc(4,1:3) = 0;
algnCtrSca1 = (eye(4)/M_gc)*[algnCtr1;1];
algnCtrSca1 = algnCtrSca1(1:3); algnCtrSca1 = algnCtrSca1 + algnOri';
algnCtrReg1 = ones(4,1); algnCtrReg1(1:3) = algnCtrSca1;
algnCtrReg1 = M_t1rev*XformFiji*M_t2rev*algnCtrReg1;
algnCtrReg1(1) = algnCtrReg1(1)-regDims.xTop+1; % correcting for the x crop.
algnCtrReg1(2) = algnCtrReg1(2)-regDims.yTop+1; % correcting for the y crop.
algnCtrReg1(3) = algnCtrReg1(3)-regDims.zTop+1; % correcting for the z crop.
algnCtrReg1 = algnCtrReg1(1:3);

% check if the coordinates are with the stack limits
sizX = -2*M_t2rev(1,4);
sizY = -2*M_t2rev(2,4);
sizZ = -2*M_t2rev(3,4);

regX = regDims.xBot-regDims.xTop+1;
regY = regDims.yBot-regDims.yTop+1;
regZ = regDims.zBot-regDims.zTop+1;

if any(algnCtrSca1<1); algnCtrSca1 = [0;0;0]; end
if any(gt(algnCtrSca1,[sizX;sizY;sizZ])); algnCtrSca1 = [0;0;0]; end

if any(algnCtrReg1<1); algnCtrReg1 = [0;0;0]; end
if any(gt(algnCtrReg1,[regX;regY;regZ])); algnCtrReg1 = [0;0;0]; end

