function mont = stak2mont(stak)

[stakR,stakC,stakZ] = size(stak);
% older code for making column-wise montages
% montageCols = sqrt(stakR * stakZ / stakC);
% 
% % Make sure montage rows and columns are integers. The order in
% % the adjustment matters because the montage image is created
% % vertically across columns.
% 
% montageRows = ceil(stakZ / montageCols);
% montageCols = ceil(montageCols);
% %montageSize = [montageRows montageCols];
% 
% %montR = ceil(sqrt(stakZ)); montC = round(sqrt(stakZ));
% mont = zeros(stakR*montageRows, stakC*montageCols);
% 
% for i0 = 1:stakZ
%     [r,c] = ind2sub([montageRows, montageCols],i0);
%     mont(1+(r-1)*stakR:r*stakR,1+(c-1)*stakC:c*stakC) = ...
%                                          stak(:,:,i0);
% end
montageRows = sqrt(stakC * stakZ / stakR);
% Make sure montage rows and columns are integers. The order in
% the adjustment matters because the montage image is created
% horizontally across rows.

montageCols = ceil(stakZ / montageRows);
montageRows = ceil(montageRows);
%montageSize = [montageRows montageCols];

%montR = ceil(sqrt(stakZ)); montC = round(sqrt(stakZ));
mont = zeros(stakR*montageRows, stakC*montageCols);

for i0 = 1:stakZ
    [c,r] = ind2sub([montageCols, montageRows],i0);
    mont(1+(r-1)*stakR:r*stakR,1+(c-1)*stakC:c*stakC) = ...
                                         stak(:,:,i0);
end