function suite_plotEllfit(c0,r0,z0,center,radii,v)

figure, plot3( c0, r0, z0, '.r' );
axis equal
hold on;
maxd = max( [ radii(1) radii(2) radii(3) ] );
step = maxd / 50;
shiftx = center(1);
shifty = center(2);
shiftz = center(3);
[ x, y, z ] = meshgrid( -maxd:step:maxd + shiftx, -maxd:step:maxd + shifty, -maxd:step:maxd + shiftz );
Ellipsoid = v(1) *x.*x +   v(2) * y.*y + v(3) * z.*z + ...
2*v(4) *x.*y + 2*v(5)*x.*z + 2*v(6) * y.*z + ...
2*v(7) *x    + 2*v(8)*y    + 2*v(9) * z;
p = patch( isosurface( x, y, z, Ellipsoid, 1 ) );
set( p, 'FaceColor', 'g', 'EdgeColor', 'none','FaceAlpha',0.5 );
view( -70, 40 );
axis vis3d;
camlight;
lighting phong;
