function s = Conv2(m,n,s);
% function s = Conv2(m,n,s);
% Computes a convolution with a filter m.'xn (m in rows and n in columns). The 
% offsets of the filters in taken into account for centering. Moreover, the
% signal is constant-padded on the edges to keep a constant size.

% Before convolving with a filter of size f, we add f-1 padding values to
% the signal. The centering is defined by how the padded values are spread
% between left and right end of the signal. Zero padding.

[h,w] = size(s);

%
% horizontal convolution
%

if (isa(n,'struct')),
  padleft  = length(n.filt)-n.offs-1;
  padright = n.offs;
  s = [zeros(h,padleft) s zeros(h,padright)];
  s = conv2(s,n.filt,'valid');
%  s = conv2(n.filt,s,'valid'); % crashes under 5.3
end

%
% vertical convolution
%

if (isa(m,'struct')),
  padtop = length(m.filt)-m.offs-1;
  padbottom = m.offs;
  s = [zeros(padtop,w); s; zeros(padbottom,w)];
  s = conv2(s,m.filt.','valid');
%  s = conv2(m.filt.',s,'valid'); % crashes under 5.3
end

% (c) Christophe BERNARD
% Read '00README' file for terms of use and copying
% permissions.
