function w = MakeSF(f,foffset,n,L);
% function w = MakeSF(f,foffset,n,L);
% construit une fonction d'chelle avec un filtre passe-bas f, d'offset foffset

if (mod(n,2)~=0),
  error('erreur: n<3> doit tre pair.');
end

s=zeros(1,n);
s(n/2+1)=1;

for i=1:L,
  sn=zeros(1,2*length(s));
  sn(1:2:length(sn)) = s;
  s = iconv(f,sn);
  ls = length(s);
  s = [s((foffset+1):ls) s(1:foffset)];
end

w=s;


% (c) Christophe BERNARD
% Read '00README' file for terms of use and copying
% permissions.
