function OpticFlow(i1,i2,Nscales);
% function OpticFlow(i1,i2,Nscales);
%
% Computes the optic flow between two successive images i1 and i2 on
% <Nscales> different scales.
% The output is stored in a global variable 'wt'
%
% (c) Christophe BERNARD
% Read '00README' file for terms of use and copying
% permissions.


%
%
%	VARIABLE SET TO GLOBAL FOR EXTERNAL LOOKUP
%
%

global wt

%
%
%       TUNED PARAMETERS
%
%

maxCond = 1e5; %% bug corrig
aliasLimit = 0.4;

%
%       NUMBER OF SCALES OF ANALYSIS
%

%Nscales = 1;

%
%
%       FILTER DEFINITION
%
%
        
	%
	%       BASIC FILTERS
	%

M0.filt=[3 0 -25 0 150 256 150 0 -25 0 3]/256;
M0.offs=6;

m1.filt=[-3 0 25 0 -150 256 -150 0 25 0 -3]/256;
m1.offs=5;

        %
	%       DERIVATIVE FILTERS
	%
	
derivative.filt = [-1 1]*2; derivative.offs=0;
integral.filt =[1 1]/2; integral.offs=0;

m0 = Conv(integral, M0);
M1 = Conv(derivative, m1);

M0final = Conv(derivative, m0);

        %
	%       ANALYTIC FILTER and CONJUGATES
	%

m2.filt = [3 0 -25 0 150 256 150 0 -25 0 3]/512.*(1i).^(-5:5);
m2.offs = 5;

M2.filt = conj(m2.filt); %4
M2.offs = m2.offs;       %4

mp0 = Conv(m0,m2);
Mp0 = Conv(M0,m2);

mP0 = Conv(m0,M2); %4
MP0 = Conv(M0,M2); %4


        %
	%       PREFILTERS
	%

prem0 = SubSample1(m0);
preM0 = SubSample1(M0);

premp0 = SubSample2(m0,mp0);
preMp0 = SubSample2(M0,Mp0);

premP0 = SubSample2(m0,mP0); %4
preMP0 = SubSample2(M0,MP0); %4

%
%       BASIC DEFINITIONS
%

[sy, sx] = size (i1);

disp(sprintf('Image size : %d x %d',sx,sy));

%
%       PUTTING ALL IN A TIME-TABLE
%

inputs(1).pict = i1;
inputs(2).pict = i2;

%
%
%       PREFILTERING (LOW-PASS)
%
%

for t=1:2,
  disp(sprintf('Prefiltering picture #%d',t)); 

  %
  %       m x m
  %

  wt(t,1).aann = OneofTwo(Conv2(prem0, prem0, inputs(t).pict));
  wt(t,1).aanp = OneofTwo(Conv2(premp0,prem0, inputs(t).pict));
  wt(t,1).aapn = OneofTwo(Conv2(prem0, premp0,inputs(t).pict));
  wt(t,1).aapp = OneofTwo(Conv2(premp0,premp0,inputs(t).pict));
  wt(t,1).aapP = OneofTwo(Conv2(premP0,premp0,inputs(t).pict)); %4
  
  %
  %       m x M
  %
  
  wt(t,1).aAnn = OneofTwo(Conv2(preM0, prem0, inputs(t).pict));
  wt(t,1).aAnp = OneofTwo(Conv2(preMp0,prem0, inputs(t).pict));
  wt(t,1).aApn = OneofTwo(Conv2(preM0, premp0,inputs(t).pict));
  wt(t,1).aApp = OneofTwo(Conv2(preMp0,premp0,inputs(t).pict));
  wt(t,1).aApP = OneofTwo(Conv2(preMP0,premp0,inputs(t).pict)); %4

  %
  %       M x m
  %

  wt(t,1).Aann = OneofTwo(Conv2(prem0, preM0, inputs(t).pict));
  wt(t,1).Aanp = OneofTwo(Conv2(premp0,preM0, inputs(t).pict));
  wt(t,1).Aapn = OneofTwo(Conv2(prem0, preMp0,inputs(t).pict));
  wt(t,1).Aapp = OneofTwo(Conv2(premp0,preMp0,inputs(t).pict));
  wt(t,1).AapP = OneofTwo(Conv2(premP0,preMp0,inputs(t).pict)); %4

end

%
%
%       LOW PASS FILTERINGS
%
%

%
%       The two first letters denote the multiresolution scheme
%       ie either a=[m0,m1] or A=[M0,M1]
%
%       The two next letters indicate whether progressive prefilering
%       has occurred
%

for scale = 2:Nscales+1,
  
  disp(sprintf('Low pass filtering at scale %d',scale));
  
  for t=1:2,
    
    %
    %       NON DERIVATIVE
    %
    
    wt(t,scale).aann = OneofTwo(Conv2(m0, m0, wt(t,scale-1).aann));
    wt(t,scale).aanp = OneofTwo(Conv2(mp0,m0, wt(t,scale-1).aann));
    wt(t,scale).aapn = OneofTwo(Conv2(m0, mp0,wt(t,scale-1).aann));
    wt(t,scale).aapp = OneofTwo(Conv2(mp0,mp0,wt(t,scale-1).aann));
    wt(t,scale).aapP = OneofTwo(Conv2(mP0,mp0,wt(t,scale-1).aann)); %4
    
    %
    %       PRE-DERIVATIVE
    %
    
    wt(t,scale).Aann = OneofTwo(Conv2(m0, M0, wt(t,scale-1).Aann));
    wt(t,scale).Aanp = OneofTwo(Conv2(mp0,M0, wt(t,scale-1).Aann));
    wt(t,scale).Aapn = OneofTwo(Conv2(m0, Mp0,wt(t,scale-1).Aann));
    wt(t,scale).Aapp = OneofTwo(Conv2(mp0,Mp0,wt(t,scale-1).Aann));
    wt(t,scale).AapP = OneofTwo(Conv2(mP0,Mp0,wt(t,scale-1).Aann)); %4

    wt(t,scale).aAnn = OneofTwo(Conv2(M0, m0, wt(t,scale-1).aAnn));
    wt(t,scale).aAnp = OneofTwo(Conv2(Mp0,m0, wt(t,scale-1).aAnn));
    wt(t,scale).aApn = OneofTwo(Conv2(M0, mp0,wt(t,scale-1).aAnn));
    wt(t,scale).aApp = OneofTwo(Conv2(Mp0,mp0,wt(t,scale-1).aAnn));
    wt(t,scale).aApP = OneofTwo(Conv2(MP0,mp0,wt(t,scale-1).aAnn)); %4

  end; % loop in {t}
  
end; % loop in {scale}

%
%
%       HIGH-PASS FILTERINGS
%
%

%
%       The two last letters indicate whether we have a low pass (n)
%       or a high pass (p/P) at the last filtering step
%

for scale = Nscales+1:-1:2,
  
  disp(sprintf('High-pass filtering at scale %d',scale));
  
  for t=1:2,

    % aann already OK
    wt(t,scale).aanp = OneofTwo(Conv2(m1,     m0,     wt(t,scale-1).aanp));
    wt(t,scale).aapn = OneofTwo(Conv2(m0,     m1,     wt(t,scale-1).aapn));
    wt(t,scale).aapp = OneofTwo(Conv2(m1,     m1,     wt(t,scale-1).aapp));
    wt(t,scale).aapP = OneofTwo(Conv2(m1,     m1,     wt(t,scale-1).aapP)); %4
    
    wt(t,scale).Aann = OneofTwo(Conv2(m0,     M0final,wt(t,scale-1).Aann));
    wt(t,scale).Aanp = OneofTwo(Conv2(m1,     M0final,wt(t,scale-1).Aanp));
    wt(t,scale).Aapn = OneofTwo(Conv2(m0,     M1,     wt(t,scale-1).Aapn));
    wt(t,scale).Aapp = OneofTwo(Conv2(m1,     M1,     wt(t,scale-1).Aapp));
    wt(t,scale).AapP = OneofTwo(Conv2(m1,     M1,     wt(t,scale-1).AapP)); %4
    
    wt(t,scale).aAnn = OneofTwo(Conv2(M0final,m0,     wt(t,scale-1).aAnn));
    wt(t,scale).aAnp = OneofTwo(Conv2(M1,     m0,     wt(t,scale-1).aAnp));
    wt(t,scale).aApn = OneofTwo(Conv2(M0final,m1,     wt(t,scale-1).aApn));
    wt(t,scale).aApp = OneofTwo(Conv2(M1,     m1,     wt(t,scale-1).aApp));
    wt(t,scale).aApP = OneofTwo(Conv2(M1,     m1,     wt(t,scale-1).aApP)); %4
    
  end; % loop in {t}
  
end; % loop in {scale}

%
%       REMOVING USELESS DATA
%

wt = wt(:,2:Nscales+1);

%
%
%       SECOND PASS: EXTRACTING THE FLOW FIELD
%
%


%
%       NOTE: THE VELOCITY MEASURED FROM THE LINEAR SYSTEM AT A GIVEN SCALE
%       IS GIVEN IN TERMS OF GRID STEPS
%


%
%       HIGHER SCALE PREDICTION IS V=0 AT THE HIGHEST SCALE
%

predict.x = zeros(ceil(size(wt(1,Nscales).aann)/2));
predict.y = predict.x;
predict.l = predict.x;

%
%       MULTISCALE MEASUREMENTS
%

for scale = Nscales:-1:1,
  
  disp(sprintf('Flow estimation at scale %d',scale+1)); % add 1 since 1 scale 
                                                        % has been dumped
  [h,w] = size(wt(1,scale).aann);
  
  wt(1,scale).vx=zeros(h,w);
  wt(1,scale).vy=zeros(h,w);
  wt(1,scale).l=zeros(h,w);
  
  for x=1:w,
    for y=1:h,
      
      xo2=ceil(x/2);
      yo2=ceil(y/2);
      
      xp = 2*predict.x(yo2,xo2);
      yp = 2*predict.y(yo2,xo2);
      
      if ((abs(xp)>aliasLimit)|(abs(yp)>aliasLimit)),
	% aliasing limit reached 
	V = [xp yp predict.l(yo2,xo2)].';
      else
	%
	%    MAKE POINTERS TO THE PICS
	%
	p1 = wt(1,scale);
	p2 = wt(2,scale);
	
	M1 = [p1.Aann(y,x) p1.aAnn(y,x) p1.aann(y,x);
	  p1.Aapn(y,x) p1.aApn(y,x) p1.aapn(y,x);
	  p1.Aanp(y,x) p1.aAnp(y,x) p1.aanp(y,x);
	  p1.Aapp(y,x) p1.aApp(y,x) p1.aapp(y,x);
	  p1.AapP(y,x) p1.aApP(y,x) p1.aapP(y,x)]; %4
	
	M2 = [p2.Aann(y,x) p2.aAnn(y,x) p2.aann(y,x);
	  p2.Aapn(y,x) p2.aApn(y,x) p2.aapn(y,x);
	  p2.Aanp(y,x) p2.aAnp(y,x) p2.aanp(y,x);
	  p2.Aapp(y,x) p2.aApp(y,x) p2.aapp(y,x);
	  p2.AapP(y,x) p2.aApP(y,x) p2.aapP(y,x)]; %4
	
	Y1 = [p1.aann(y,x); p1.aapn(y,x); p1.aanp(y,x);
	  p1.aapp(y,x); p1.aapP(y,x)];
	
	Y2 = [p2.aann(y,x); p2.aapn(y,x); p2.aanp(y,x);
	  p2.aapp(y,x); p2.aapP(y,x)];
      
	
	%
	%     CLEAN UP THE POINTERS, OR ELSE MATLAB MAY DUP THEM
	%
	
	clear p1 p2
	
	M = (M1 + M2)/2;
	Y = Y2-Y1;
	
	%
	%     LS RESOLUTION
	%
	
	MLS = real(M'*M);
	
	if (cond(MLS)>maxCond),
	  % propagate. System badly conditioned
	  V = [2*predict.x(yo2,xo2) 2*predict.y(yo2,xo2) predict.l(yo2,xo2)].';
	else
	  V = inv(MLS)*real(M'*Y);
	end;
	
	%
	%     A POSTERIORI TEST
	%
	
	if ((abs(V(1))> 0.6) | (abs(V(2)> 0.6))),
	  % also propagate. Resulting measures over aliasing limit
	  V = [2*predict.x(yo2,xo2) 2*predict.y(yo2,xo2) predict.l(yo2,xo2)].';
	end
      end % test on aliasing at upper scale
      wt(1,scale).vx(y,x) = V(1);
      wt(1,scale).vy(y,x) = V(2);
      wt(1,scale).l(y,x)  = V(3);
    end % for y
  end %  for x
  predict.x = wt(1,scale).vx;
  predict.y = wt(1,scale).vy;
  predict.l = wt(1,scale).l;
end % for scale

% (c) Christophe BERNARD
% Read '00README' file for terms of use and copying
% permissions.
