function M = SubSample1(m);
% function M = SubSample1(m);
% computes a subsampling of the scaling function generated by the filter m
% and outputs the filter M.

L = 10;
s=32;

f = MakeSF(m.filt, m.offs, s, L);

% recentering

foffset = m.offs + (1-length(m.filt))/2;

% strategy for choosing foffset checked for symmetric filters

if (mod(foffset,1) == 0.5)
  f=iconv([1 1]/2,f);
  foffset=ceil(foffset);
end

f = [zeros(1,2^L-1) f];

f = f(2^L+foffset:2^(L-1):length(f));

offset = s;

% coring

b = min(find(f~=0));
B = max(find(f~=0));

M.offs = s-b+1;

M.filt=f(b:B);


% (c) Christophe BERNARD
% Read '00README' file for terms of use and copying
% permissions.
