function M = SubSample2(m0,m1);
% function M = SubSample2(m0,m1);
% computes the samples of a function generated by the discrete low-pass
% filter m0 and a discrete high-pass filter m1

L = 10;
s=32;

f = MakeWa(m0.filt, m1.filt, m0.offs, m1.offs, s, L);

% recentering

foffset = m0.offs + (1-length(m0.filt))/2;

% strategy for choosing foffset

if (mod(foffset,1) == 0.5)
  f=iconv([1 1]/2,f);
  foffset=ceil(foffset);
end

f = [zeros(1,2^L-1) f];

f = f(2^L+foffset:2^(L-1):length(f));

offset = s;

% coring

b = min(find(f~=0));
B = max(find(f~=0));

M.offs = s-b+1;

M.filt=f(b:B);

% (c) Christophe BERNARD
% Read '00README' file for terms of use and copying
% permissions.
