function y = iconv(filt, signal)
% iconv -- simpler clone of WaveLab's iconv.m
% for periodic convolutions.
% Use this script if you don't have WaveLab.
% Else, remove it.

filtered = conv(filt,signal);
s=length(signal);
os=length(filtered)-s;
y=filtered(1:s);
filtered=filtered(s+1:os+s);

while os>0,
  os2=min(os,s);
  y(1:os2)=y(1:os2)+filtered(1:os2);
  filtered=filtered(os2+1:os);
  os=os-os2;
end

% (c) Christophe BERNARD
% Read '00README' file for terms of use and copying
% permissions.
