% Quadratic curves and quadric surfaces in implicit form
% Copyright 2010 Levente Hunyadi
%
% Examples
%   example_conic      - Demonstrates plotting conic sections given as an implicit equation.
%   example_pqdist     - Sample code for distance of quadratic curve and point.
%
% Conic sections as an implicit equation
%   imconic            - Compute parameters of or plot conic section given in implicit form.
%   imconicdiscr       - Discriminant for conic section.
%   imconicisect       - Intersections of conic with window bounds.
%   imconicrotate      - Rotates a conic section given as an implicit equation.
%   imconicrotation    - Rotation matrix of a conic section given as an implicit equation.
%   imconictranslate   - Translates a conic section given as an implicit equation.
%   imconictranslation - Translation vector of a conic section given as an implicit equation.
%
% Distance of point and quadratic curve or quadric surface
%   pqdist             - Distance of point(s) and quadratic curve or quadric surface.
%   pqdistpoly         - Polynomial in parameter t for distance between point y and foot point x.
%
% Geometric transformations
%   invtransrot        - Apply translation and inverse rotation to a set of points.
%   transrot           - Apply translation and rotation to a set of points.
%
% Matrices in symbolic variables
%   example_symm       - Sample code for matrices in symbolic variables
%   symm               - Create a matrix of symbolic variables.
%   symmd              - Create a diagonal matrix of symbolic variables.
%   symms              - Create a symmetric matrix of symbolic variables.
%   sym2matlab         - Convert symbolic expression containing matrix entries into MatLab.
%   symmvars           - Parse parameters for symbolic matrix creation.
%
% Utility functions
%   intfilter          - Filters those elements of x that are outside a set of intervals.
%   strjoin            - Concatenates a cell array of strings.
