function example_conic
% Demonstrates plotting conic sections given as an implicit equation.
%
% See also: imconic

% Copyright 2010 Levente Hunyadi

% w = [-4 6 -4 6];
w = [];  % determine window bounds automatically

f = figure('Visible', 'off');
list = uicontrol(f, ...
    'Style', 'listbox', ...
    'Max', 2, ...  % multiple selections
    'Min', 0, ...
    'Units', 'normalized', ...
    'Position', [0 0 0.3 1], ...
    'Callback', @example_conic_onselection);
a = axes( ...
    'Parent', f, ...
    'Units', 'normalized', ...
    'OuterPosition', [0.3 0 0.7 1]);
hold('all');

lines = [ ...
    ... % circle
    example_conic_draw(a, [4 0 4 4 -36 -16], w) ...
    example_conic_draw(a, imconicrotate([4 0 4 4 -36 -16], pi/4), w) ...
    example_conic_draw(a, imconictranslate([4 0 4 4 -36 -16], [2 1]), w) ...
...
    ... % ellipse
    example_conic_draw(a, [1/25 0 1/9 0 0 -1], w) ...  % centered in origin, aligned with axis
    example_conic_draw(a, imconicrotate([1/25 0 1/9 0 0 -1], pi/4), w) ...  % center in origin but rotated
    example_conic_draw(a, imconictranslate([1/25 0 1/9 0 0 -1], [2,1]), w) ...  % aligned with axis but translated
    example_conic_draw(a, [1/49 0 1/25 -2*3/49 2/25 9/49+1/25-1], w) ...  % (x-3)^2/49 + (y+1)^2/25 - 1 = 0  % aligned with axes but translated
    example_conic_draw(a, [1 0 4 -6 8 9], w) ...  % aligned with axes but translated
    example_conic_draw(a, [9 0 16 90 -64 145], w) ...
    example_conic_draw(a, imconicrotate([9 0 16 90 -64 145], pi/6), w) ...  % translated & rotated
    example_conic_draw(a, imconicrotate([9 0 16 90 -64 145], pi/5), w) ...
    example_conic_draw(a, imconicrotate([9 0 16 90 -64 145], pi/4), w) ...
    example_conic_draw(a, imconicrotate([1/49 0 1/25 -2*3/49 2/26 9/49+1/25-1], 0.25*pi), w) ...  % (x-3)^2/49 + (y+1)^2/25 - 1 = 0
...
    ... % hyperbola centered in origin, rotated around the origin
    example_conic_draw(a, [1 0 -1 0 0 -1], w) ...
    example_conic_draw(a, imconicrotate([1 0 -1 0 0 -1], pi/8), w) ...
    example_conic_draw(a, imconicrotate([1 0 -1 0 0 -1], pi/4), w) ...
    example_conic_draw(a, imconicrotate([1 0 -1 0 0 -1], 3*pi/8), w) ...
    example_conic_draw(a, imconicrotate([1 0 -1 0 0 -1], pi/2), w) ...
    example_conic_draw(a, imconicrotate([1 0 -1 0 0 -1], 5*pi/8), w) ...
    example_conic_draw(a, imconicrotate([1 0 -1 0 0 -1], 3*pi/4), w) ...
    example_conic_draw(a, imconicrotate([1 0 -1 0 0 -1], 7*pi/8), w) ...
...
    ... % parabola
    example_conic_draw(a, [1 0 0 0 1 0], w) ...
    example_conic_draw(a, imconicrotate([1 0 0 0 1 0], pi/8), w) ...
    example_conic_draw(a, imconicrotate([1 0 0 0 1 0], pi/4), w) ...
    example_conic_draw(a, imconicrotate([1 0 0 0 1 0], 3*pi/8), w) ...
    example_conic_draw(a, imconicrotate([1 0 0 0 1 0], pi/2), w) ...
    example_conic_draw(a, imconicrotate([1 0 0 0 1 0], pi), w) ...
];
    
hold('off');
set(lines, 'Visible', 'off');
set(list, 'String', get(lines, 'Tag'));
set(f, 'Visible', 'on');

function line = example_conic_draw(a, p, w)

line = imconic(p, w, a);
p(abs(p) < 1e-15) = 0;
set(line, 'Tag', mat2str(p, 3));

function example_conic_onselection(src, evt) %#ok<INUSD>

items = get(src, 'String');
selection = get(src, 'Value');
f = ancestor(src, 'figure');
a = findobj(f, 'Type', 'axes');

% curves either consist of a single part (e.g. ellipses) or multiple parts (e.g. hyperbolas)
lines = findobj(a, '-depth', 1, 'Type', 'line', '-or', 'Type', 'hggroup');

% hide curves not selected
set(lines, 'Visible', 'off');

% show curves selected
for k = 1 : numel(selection)
    set(findobj(lines, 'flat', 'Tag', items{selection(k)}), 'Visible', 'on');
end
