function [mu,mask]=kmeans_oa_v(ima,idx,k)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%   kmeans image segmentation
%
%   Input:
%          ima: grey color image
%          k: Number of classes
%   Output:
%          mu: vector of class means 
%          mask: clasification image mask
%
%   Author: Jose Vicente Manjon Herrera
%    Email: jmanjon@fis.upv.es
%     Date: 27-08-2005
%   mod by OA: new input idx are the indices of the non-zero elements of
%              ima. 2012.04.12
%              assignment of mask indices vectorized. should run faster for
%              large inputs. 2013.06.09
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if isempty(idx)
    idx = 1:numel(ima);
end

% check image
ima=double(ima);
copy=ima;           % make a copy
ima=ima(idx);       % vectorize ima
mi=min(ima);      % deal with negative 
ima=ima-mi+1;     % and zero values

s=length(ima);

% create image histogram

m=max(ima)+1;
h=zeros(1,m);
hc=zeros(1,m);

for i=1:s
  if(ima(i)>0); h(ima(i))=h(ima(i))+1;end;
end
ind=find(h);
hl=length(ind);

% initiate centroids

mu=(1:k)*m/(k+1);

% start process

while(true)
  
  oldmu=mu;
  % current classification  
 
  for i=1:hl
      c=abs(ind(i)-mu);
      cc=find(c==min(c));
      hc(ind(i))=cc(1);
  end
  
  %recalculation of means  
  
  for i=1:k, 
      a=find(hc==i);
      mu(i)=sum(a.*h(a))/sum(h(a));
      if(isnan(mu(i)))
          mu(i) = i*m/(k+1);
      end
  end
  
  
  if(mu==oldmu);break;end;
  
end

copy_v = copy(idx);
mi_v = mi*ones(size(copy_v));
c_v = zeros(length(idx),k);
for j0 = 1:k
    c_v(:,j0) = abs(copy_v-mi_v-mu(j0)*ones(size(copy_v)));
end
[~,a_v] = min(c_v,[],2);
mask = zeros(size(copy));
mask(idx) = a_v;

mu=mu+mi-1;   % recover real range

