function s_ProcessSeries_Example % this is not a real function

% variable s input
SIv = struct('homeDrive','/Volumes/TwoPhotonC/',... % home drive
             'dateDir','2014_08_23/',... % dated directory
             'numFly',1,... % number of flies imaged on date
             'parFly','one',... % parity of the series to be processed. 'one', 'odd', or 'even.'
             'stagingDate','22-Aug-2014 14:00:00',... % when the fly was staged.
             'stagingMode','wpp',... % 'he': head eversion, add +12 to develeopmental time. 'wpp': white pre-pupa formation
             'numCh',2,... % number of channels in each series
             'voxAR',[1 1 1.667],... % voxel aspect ratio
             'xyRes', 0.24,... % XY resolution
             'anchorIdx',34,...% index of stack at 40 hAPF
             'ScaZ_stkLims',[],... % ScaZ(FIJI) stack top and bot lims, see below
             'TA_stkLims',[],... % TurnAngles stack top and bot lims
             'ZMIP_stkLims',[],... % input by user, after running xform(FIJI)
             'seedIdx',[],... % input by user, after running ShellzMIP
             'trakSpan',[],...
             'skelMIPIdx',[],... % input by user, required in PlotGCExtension;
             'gcDims',[18 12 3 6]); % dimensions, in microns, of the extracted GC volumes. used in AlignGCs and downstream.
             % gcDIms(1): 3D leg of the full extracted and saved GC volume.
             % gcDIms(2): 2D(XZ) leg for the YMIP montage
             % gcDIms(3): 2D(XZ) leg for the ZMIP montage. isolates the central GC.
             % gcDims(4): distance from centGCs, as defined in trackGCs, to the geometric center of the saved GC volume.

si = s_buildSIstruct_v1(SIv); % suite folder structure

SIv.ScaZ_stkLims = [1 350]; % input by user, after first run of scaZ(FIJI)
SIv.ZMIP_stkLims = []; % input by user, after running xform(FIJI)
SIv.anchorIdx = 34; % anchor is the template stack, 40 hrs APF
SIv.seedIdx = 64; % 45 hrs APF
SIv.skelMIPIdx = 124; % 55 hrs APF

s_getTimeStamps(si);
s_devTime(si,SIv);
s_StkFileNames_v2(si,'G'); % make a txt file of the stack names

% % run FIJI_sca

s_TurnAngles_v11(si,'G',SIv);
s_SliceRegister_v5(si,'G',SIv);
s_GlobalAlign_v6(si,'G',SIv);

% % run FIJI_xform

s_ShieldMask_v2(si,'G',SIv);
s_Shield2Shell_v1(si,'G',[5 -5]);
s_ShellzMIP_v3(si,'G');

s_DefineGCs_v4(si,'G',SIv);
s_TrackGCs_v2(si,'G',SIv);
s_AlignGCs_v7(si,'G',SIv);
s_PlotGCExtension_v10(si,'G',SIv,0);

