function dydt = colonial(t, yCur, ...
                         growthConst, alleeCap, capFunc)
% COLONIAL Differential equation for organisms in colonial mode
% t - current time
% yCur - current state vector
%   1st index - colonial population size, nCur
%   2nd index - colonial carrying capacity, K
% growthConst - growth rate in the absence of Allee or logistic effect
% alleeCap - capacity below which the Allee effect occurs in colonial mode
% capFunc - rate of change of K as function of nCur and K

nCur = yCur(1); % Current population size
K = yCur(2); % Current carrying capacity
A = min(K, alleeCap); % Eff. Allee capacity (makes sense when K < alleeCap)
effGrowthConst = growthConst * (nCur/A - 1) * (1 - nCur/K);

dndt = effGrowthConst * nCur;
dKdt = (K > 0) * capFunc(yCur);
dydt = [dndt; dKdt];

end

