function cSwitchLevel = maxlvl(nSwitchLevel, nGrowthConst, fudge)
% MAXLVL Compute maximal cSwitchLevel given nSwitchLevel and nGrowthConst
%   Finds cSwitchLevel that maximizes the time-averaged population
%   fudge - fudge factor to ensure cSwitchLevel doesn't exceed maximum

if ~exist('fudge', 'var')
  fudge = 1;
end

cSwitchLevel = nSwitchLevel + ...
    fudge * log(nSwitchLevel - conjlvl(nSwitchLevel))/(-nGrowthConst);

end

