function dydt = mixed(t, yCur, switchConst, ..., 
                       nSwitchLevel, cSwitchLevel, ...
                       nGrowthConst, cGrowthConst, ...
                       alleeCap, capFunc)
% MIXED Differential eqn. for organisms that have nomadic & colonial modes
% t - current time
% yCur - current state vector
%   1st index - nomadic population size, n1
%   2nd index - colonial population size, n2
%   3rd index - colonial carrying capacity, K
% switchConst - rate at which organisms switch modes (prob. per unit time)
% nSwitchLevel - level of K below which organisms switch to nomadic mode
% cSwitchLevel - level of K above which organisms switch to colonial mode
% nGrowthConst - rate at which nomadic organisms grow/die (= -r1)
% cGrowthConst - rate at which colonial organisms grow/die (= r2)
% alleeCap - capacity below which the Allee effect occurs in colonial mode
% capFunc - rate of change of K as function of nC (defined in simulation.m)

dydt = zeros(3,1);
dydt(1) = nomadic(t, yCur(1), nGrowthConst);
dydt(2:3) = colonial(t, yCur(2:3), cGrowthConst, alleeCap, capFunc);
if yCur(3) < nSwitchLevel
    migrateRate = switchConst * yCur(2);
    dydt(1) = dydt(1) + migrateRate;
    dydt(2) = dydt(2) - migrateRate;
elseif yCur(3) > cSwitchLevel
    migrateRate = switchConst * yCur(1);
    dydt(1) = dydt(1) - migrateRate;
    dydt(2) = dydt(2) + migrateRate;
end
               
end

