% SIMULATION.M Runs simulation for periodic alternation or extinction

% See mixed.m for detailed documentation of parameters
switchConst = 1000; % Speed at which organisms switch modes
nGrowthConst = -1; % Nomadic growth is negative (slow decay)
cGrowthConst = 10; % Colonial growth is high if alleeCap < n2 << K
alleeCap = 1.001; % When n2 < alleeCap, colonial growth is negative
capFunc = @(y) 1 - y(1); % K drops when n2 is high, grows when n2 is low

% Uncomment the following two lines to bound the carrying capacity K
% capMax = 20; % Maxmium value that K can rise to
% capFunc = @(y) (1 - y(1))*(1 - y(2)/capMax); % Equation for bounded K

nSwitchLevel = 3.0; % Switch to nomadic mode if K < nSwitchLevel
cSwitchLevel = ... % Switch back to colonial if K > cSwitchLevel
    maxlvl(nSwitchLevel, nGrowthConst, 0.9); % See maxlvl.m

n0 = [0; 2; 5]; % Initial population sizes / carrying capacity
tStart = 0; % Starting time
tEnd = 10; % Ending time

odeFunc = @(t, yCur) ... % Parameterize function for use in ODE solver
    mixed(t, yCur, switchConst, nSwitchLevel, cSwitchLevel, ...
    nGrowthConst, cGrowthConst, alleeCap, capFunc);

options = odeset('NonNegative',1, 'RelTol',1e-6,'AbsTol',1e-6);

sol = ode23(odeFunc, [tStart tEnd], n0, options);
tInt = linspace(tStart, tEnd, 1000);
nInt = deval(sol, tInt);

plot(sol.x, sol.y);
xlabel('Time');
ylabel('Population size');
legend('n_1', ...
       'n_2', ...
       'K');

if switchConst == 0
    titleStr = 'No switching';
    subStr = sprintf('No switching, A = %0.3f', alleeCap);    
else
    titleStr = 'Survival through periodic alternation';  
    subStr = ...
        sprintf(['Switch to nomadic if K < %0.2f; ', ...
                 'Switch to colonial if K > %0.2f'], ...
        nSwitchLevel, cSwitchLevel);
end
title({['\fontsize{12}', titleStr], ...
      ['\fontsize{10}\rm', subStr]});   