% Hist Analysis
% This function computes Max, hald width and area 
% of histograms from Nex

%-----------------------------
% Ver       Date        Who     Descr
%-----------------------------
% 15        16.06.15    UD     Disable Omri computation . 
% 14        02.06.15    UD     Vector Sum . 
% 13        21.05.15    UD     Vector Sum ???. 
% 12        19.05.15    UD     Omri's comments 2Theta. 
% 11        25.11.14    UD     for Mohamed. 
%-----------------------------


%%%
% Params for change
%%%
xlsFileName    = '31.3.16_summary_MUA.xlsx';    
xlsSheet       = '1stresponses_analysis';
figNum          = 1;

%%%
% Load All the data
%%%
% headerInfo      = xlsread(xlsFileName,xlsSheet,'B1:AH1');
% dataInfo        = xlsread(xlsFileName,xlsSheet,'B2:AH25');

[ndata, cellNames, alldata] = xlsread(xlsFileName,xlsSheet,'B1:P25');
% remove empty lines
ndata(any(isnan(ndata),2),:) = [];
cellNames       = cellNames(1,:);

% extract control and laser
cntrlData       = ndata(1:2:end,:);
laserData       = ndata(2:2:end,:);

cellNum         = size(cntrlData,2);
angleNum        = size(cntrlData,1);
angleResp       = (0:angleNum-1)'*45/180*pi;

% %%%
% % Checks : COMMENT IT WHEN DONE
% %%%
% cntrlData(1:8,1) = [1;.01;.01;.01;.01;.01;.01;.01];
% laserData(1:8,1) = [1;.01;.01;.01;.01;.01;.01;.01];
% cntrlData(1:8,2) = [1;.01;.01;.01;.01;.01;.01;.01];
% laserData(1:8,2) = [10;.01;.01;.01;.01;.01;.01;.01];
% cntrlData(1:8,3) = [1;.01;.01;.01;.01;.01;.01;.01];
% laserData(1:8,3) = [.01;1;.01;.01;.01;.01;.01;.01];


% %%%
% % Compute Response by summing Opposite angles
% %%%
% cntrlData(1:4,:) = cntrlData(1:4,:) + cntrlData(5:8,:);
% cntrlData(5:8,:) = cntrlData(1:4,:);
% laserData(1:4,:) = laserData(1:4,:) + laserData(5:8,:);
% laserData(5:8,:) = laserData(1:4,:);



%%%
% Show data
%%%
% showNum         = ceil(sqrt(cellNum));
% figure(figNum)
% for r = 1:showNum,
%     for c = 1:showNum,
%         ind         = (r-1)*showNum+c;
%         if ind > cellNum, break; end;
%         subplot(showNum,showNum,ind),
%         polar(angleResp,cntrlData(:,ind),'b'); hold on;
%         polar(angleResp,laserData(:,ind),'r'); hold off;
%         title(cellNames{ind},'interpreter','none')
%         axis equal; axis off;
%     end
% end
showInd      = [(1:angleNum) 1];
for k = 1:cellNum,
    figure(figNum + k),set(figNum + k,'Name', cellNames{k})
    polar(angleResp(showInd),cntrlData(showInd,k),'b'); hold on;
    polar(angleResp(showInd),laserData(showInd,k),'r'); hold off;
    title(cellNames{k},'interpreter','none')
    axis equal; axis off; legend('C','L')
end

%%%
% Show Average response vector
%%%
angleData   = exp(1i*repmat(angleResp,1,cellNum));
cntrlVect   = mean(cntrlData.*angleData);
laserVect   = mean(laserData.*angleData);


for k = 1:cellNum,
    figure(figNum + k),hold on;
    compass(cntrlVect(k),'b'); 
    compass(laserVect(k),'r'); 
    hold off;
end


%%%
% Compute Prob and Entropy
%%%
angleLC     = (angle(cntrlVect) - angle(laserVect))*180/pi;

cntrlArea   = sum(cntrlData);
laserArea   = sum(laserData);
cntrlProb   = cntrlData*diag(1./cntrlArea)+eps;
laserProb   = laserData*diag(1./laserArea)+eps;


% entropy
cntrlEntropy = -sum(cntrlProb.*log(cntrlProb),1);
laserEntropy = -sum(laserProb.*log(laserProb),1);

% KL distance symmetric
klDistance   = (sum(cntrlProb.*log(cntrlProb./laserProb)) + sum(laserProb.*log(laserProb./cntrlProb)))/2;

for k = 1:cellNum,
   txt = sprintf('%8s : Area : C %3.1f, L %3.1f, Entropy : C %4.3f, L %4.3f, KL : %4.3f, LC Angle : %3.1f\n',...
        cellNames{k},cntrlArea(k),laserArea(k),cntrlEntropy(k),laserEntropy(k),klDistance(k),angleLC(k));
    
   fprintf('%2d : %s\n',k,txt);
   
   % show on figures
   figure(figNum + k)
   title(txt)

end


return

%%%
% save Analysis and Results
%%%
%Original - FileName = 'CorrCoeff.xls';
% get the name of the experiment
SaveDirFile     = [userFileName];
xlsFileName     = [SaveDirFile,'.xls'];
if exist(xlsFileName,'file'),
    
    ButtonName = questdlg('Fadi how are you?. The XLS file is already exists. Overwrite?',   'File exists',   'Yes', 'No','Yes');
    if ~strcmp(ButtonName,'Yes'),
        fprintf('Save canceled by User\n')
        return;
    else
        delete(xlsFileName);
        fprintf('Old XLS file is deleted.\n')
    end;
end


warning off MATLAB:xlswrite:AddSheet;

stat = xlswrite(xlsFileName,[HistM'],                    'HistData');
stat = xlswrite(xlsFileName,[HistMax'],                  'HistMax');
stat = xlswrite(xlsFileName,[HalfWidth'],                'HalfWidth');

fprintf('Data is saved in %s\n',xlsFileName)
return

