library(philr); packageVersion("philr")
library(phyloseq); packageVersion("phyloseq")
library(ggplot2); packageVersion("ggplot2")
library(dplyr); packageVersion("dplyr")
library(tidyr); packageVersion("tidyr")
library(ggtree); packageVersion("ggtree")
library(matrixStats); packageVersion('matrixStats')
library(parallel); packageVersion("parallel")
library(magrittr); packageVersion("magrittr")
library(purrr); packageVersion("purrr")
library(ggrepel)

set.seed(4)

# BYSITE - Analyze -------------------------------------------------------

load('bysite.20000.40.RData')


# Get p-values
one.sided.pval <- bysite %>% 
  map(~ecdf(.x[['nmr']][['log_mdtt']])(.x[['lm']][['coefficients']][2,1])) %>%
  as_vector()
two.sided.pval <- ifelse(one.sided.pval < 0.5, one.sided.pval*2, (1-one.sided.pval)*2)

sink(file='results/permutation_pval.txt')
cat('BH corrected two-sided tests from Permutation:\n')
cat("\n")
(two.sided.pval <- p.adjust(two.sided.pval, method='BH'))
sink()
