clear all;
close all;
clc;

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%BASIC VERSION%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%DEFINE  MOVIE LOCATION AND PREFIXES%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

directory = 'D:\Backup_Analyzed_Movies\MtbMacs-2014-03-27pickup_backup20150624'; %%%DO NOT INCLUDE FOV FOLDER - IT WILL BE FOUND AUTOMATICALLY
movieDate = 20140327; 
prefixR = 'Mtb_w2 RFP 607_s';%constant perfixes on each file type
%prefixG = 'test20_w2GFP_s8_t';
prefixP = 'Mtb_w1phase_s';
prefixA = 'Mtb_w3 APC 685_s';

%%%%IS APC USED?
APCchannel =0;

%input first and last frames - USED FOR ALL FUNCTIONS WHICH WORK ON THE
%FULL FOV

fFirst = 1; 
fLast = 696;

FOVrange=[];%%%keep empty if want to go through all fovs
herdRange = 200:201;%%%don't look through all herds
 cellRange = 1:30;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%OPTIONS%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%WORKFLOW: SIMPLE CHOOSER PATH

%%%1) RUN deeqaNorm
%%%2) RUN deeqaEdgeDetector
%%%3) RUN makeOverlay
%%%4) DO CORRECTIONS
%%%5) RUN simpleChooser
%%%6) Modify cell info if neccesary
%%%7) RUN quantify pickup if pickups exist
%%%8) combine data using combiner

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
deeqaNorm = 0; %%%%%%%%%%%OPTION 1%%%%%%%%%%%%%

    flatfieldImage = ('H:\ToAnalyze\MtbMacs2014-04-03pickup\FFC 20140327movie RFP607 300ms50EMgain.tif');
    backgroundR = 126;%%%background mcherry INPUT FROM BACKGROUND CALCULATOR
    fudgeFactorFluor = 1; %%%for enhanced image thresholding
    backgroundA = 100; %%%background APC IF USED


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

deeqaEdgeDetector =0; %%%%%%%%%%%OPTION 2%%%%%%%%%%%%%
useOutOfFocus =0; %%%must have folder phaseLow
offsetToOutFocusFOV =20;%IF OUT OF FOCUS USED
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeOverlay =0; %%%%%%%%%%%OPTION 3 -USE AFTER EDGE DETECTOR FOR MANUAL CORRECTIONS%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

stegui = 0; %%%OPTION 4 -GUI FOR SEGMENTATION CORRECTIONS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%NON GUI SEGMENTATION CORRECTIONS
addBW = 0; %%%%%%%%%%OPTION 5-1
frameRangeAddBW = [1:10, 165]; 
zerosHalo =2; %%%this is the thickness of the parimeter of zeros around BW - make larger if want to erase everything nearby
usePloygon =0; %%%default shape is ellipse
fovToAddBW = 30;
addInvertedBW =0; %%%%this places 0's in BW instead of 1's - goog for erasing
addBWCorrectCycle = 1; %%%%%%%%this is the cycle number which correction takes place. if last frame, remember to double click

correctUndersegmentation = 0; %%%%%%%%%%%%OPTION 5-2%%%%%%%%%%%%%
imFeelingLucky = 0; %%%%%%%%%%%OPTION 7%%%%%%%%%%%%%
fovToCorrect = 22;
framesToCorrectUndersegmentation = [33];
feelingLuckyCorrectCycle =  5; %%%%%%%%this is the cycle number which correction takes place. if last frame, remember to double click

correctOversegmentation = 0;%%%%%%%%%%%OPTION 5-3%%%%%%%%%%%%%
fovToCorrectOverSeg = 22;
framesToCorrectOversegmentation = [22 23];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

simpleChooser = 0; %%%%%%%%%%%OPTION 6%%%%%%%%%%%%%note that cells analyzed with this option will be designated herd 200. REPLACES DEEQACHOOSER
fovChosen =30;
%%%INFO for the particular cell 
   deathFrameSimpleChooser = 208;%%%put in last frame if doesn't die, OTHERWISE MAKE SURE THAT AT LEAST ONE FRAME BEFORE LAST FRAME IN CASE OF DETACHMENT   
   firstFrameCell = 1;
   lastFrameCell = 521; 
   methodDeathDetermination = 2; %%%0 = doesn't die 1 = floats off, 2= cessesion internal movement
   cellInfected = 1; %%%is this cell infected at any point?
   staysAfterDeath = 1; %%%can cell be used for after death dynamics?
   %%%key: firstLastDeathMethod = [deathFrameSimpleChooser, firstFrameCell, lastFrameCell, methodDeathDetermination, cellInfected, staysAfterDeath];
%%%CORRECT CENTROID JUMP
framesModifyCentroid = [];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

modifyCellInfoOnly =0; %%%OPTION 7: if want to modify cell info without rerunning chooser. changes only firstLastDeathMethodData.mat
%%%INFO for the particular cell
fovMod =36;
herdFolderNumberMod = 99;
cellNumberToUseMod =27;
   deathFrameSimpleChooserMod = 520;%%%put in last frame if doesn't die, OTHERWISE MAKE SURE THAT AT LEAST ONE FRAME BEFORE LAST FRAME IN CASE OF DETACHMENT   
   firstFrameCellMod = 1;
   lastFrameCellMod = 520; 
   methodDeathDeterminationMod = 0; %%%0 = doesn't die 1 = floats off, 2= cessesion internal movement
   cellInfectedMod = 1; %%%is this cell infected at any point?
   staysAfterDeathMod = 0; %%%can cell be used for after death dynamics?
   %%%key: firstLastDeathMethod = [deathFrameSimpleChooser, firstFrameCell, lastFrameCell, methodDeathDetermination, cellInfected, staysAfterDeath];
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

quantifyPickup = 1;%%%%%%%%%%%OPTION 8%%%%%%%%%%%%%note: double click on ellipse FOR NEXT PICKUP. RUN SIMPLECHOOSER FIRST
fovChosenPickup = 11;
herdNumberPickup = 200;
cellNumberPickup = 7;
frameForPickup = [172];%%%if multiple pickups, list frames for all
efferocytosis =[0];%%%for each pickup, list if effero (1) or not (0)
overlaySingleHerdContainsOverlays =0; %%%images should NOT have time stamp. If they do, enter 0.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dataCombiner = 0; %%%%%%%%%%%OPTION 9: combines all files and filter data - USE WITH SIMPLE CHOOSER%%%%%%%%%%%%
applybFilt =1; %%%IF WANT TO FILTER DATA TO REMOVE SHARP PEAKS. option should be on for mtb fluor

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%END BASIC VERSION%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%ADVANCED%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%SEGMENTATION GENERAL%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%REDUCE FLATFIELD MATRIX SO THAT RESULT OF DIVISION IS NEVER <1. DO NOT
%%%DIVIDE FLATFIELD BY TOO LARGE OF A NUMBER SINCE IT WILL BECOME 2'S AND
%%%1'S SINCE NUMBERS SMALL. KEEP NUMBERS IN THE 10'S, SO DIVIDE BY FACTOR
%%%OF ORDER OF MAG LOWER

if numel(FOVrange)~=0;
        rangeToUse = FOVrange;
        
else
        rangeToUse = 1:200;
        
end

%%%DEFINE LOWER BOUND FOR CELLS - ANYTHING BELOW WILL BE ERASED FROM IMAGE

LB = 150;

%%%clockproperties
minutesBetweenFrames = 10;
x_clock = 1100;
y_clock =50;
clock_font_size = 25;
clock_color   = 'w';
x_pos = 900;
y_pos = 50;
text_font_size = 12;

%%%%%%%%%%%FOR SEGMENTATION%%%%%%%%%%%%%%%%%%%%%%

fudgeFactor = 0.95;

%%%%for death frame determination using APC

windowToMeasuredeathFrame = 5;
thresholdForDeath = 2;
lowerBoundAPC = 800;

%%%for filtering

medianWindow = 20;
filterThreshold = 2;
exclusionInterval = 10; %%%do not include values that are +/- exclusionInterval around value filtered

%%%markov cycles

numberOfMarkovCycles = 2;

%%%unfinished

areaProofreader =0;


%%%OTHER OPTIONS:

markovCutPropagation =0; %%%%%%%%%%%OPTION 3%%%%%%%%%%%%%
fovToCorrectMarkov = 1;
% % % % % % 
deeqaChooser = 0; %%%%%%%%%%%OPTION 9%%%%%%%%%%%%%MAY BE REPLACED BY SIMPLE CHOOSER: SEE BELOW
% % % % % % fovChosen = 12;
% % % % % % numberCellsInHerd = 1;
% % % % % % useEraseEllipse = 1;
% % % % % % overlapRequired = 1;
% % % % % % noNeedToPause = 1;


usePreviousImpolySeg =0; %%%if previous impoly present and BW folder created with impolyToBW
cellNumberPoly = 1; %%%choose cell number created in impolyToBW

   

%%
%%%%%%%%%%%%DEEQANORM1_1START%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%DEEQANORM1_1START%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%DEEQANORM1_1START%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cd(directory);

if deeqaNorm ==1;

    flatfield=imread(flatfieldImage);
    
    flatfieldSmall = flatfield./10;
    
        
    for fovNumber = rangeToUse;
        
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovNumber)]); 
    
    if exist(nameFOVfolder) ~=0;
    
    cd(nameFOVfolder);



%%%dir to find
directoryR = 'fluor';%red channel 
directoryP = 'phase';% phase 

if APCchannel ==1
directoryA = 'APC';
end

%%%dir to create
directoryRback = 'backFluor';%red channel background subtracted
directoryRenhanced = 'enhancedFluor';%red channel non-zero pixels saturated
if APCchannel ==1
directoryAback = 'backAPC';%APC channel background subtracted
end
directoryPnorm = 'normPhase';% phase 
if APCchannel ==1
directoryAshow = 'showAPC';%APC channel background subtracted
end
%%%directoryNoFlick = 'noFlick';

mkdir(directoryRback);
mkdir(directoryPnorm);
mkdir(directoryRenhanced);
if APCchannel ==1
mkdir(directoryAback);
mkdir(directoryAshow);
end
%mkdir(directoryNoFlick);


for im = fFirst:fLast;
    
    %%%outputNameRnoFlicker = ([directoryNoFlick '\'  'noFlick' num2str(im)  '.' 'TIF']);
    outputNameR = ([directoryRback '\'  'back' num2str(im)  '.' 'TIF']);
   outputNameP = ([directoryPnorm '\'   'normPhase' num2str(im)  '.' 'TIF']);
   if APCchannel ==1
   outputNameA = ([directoryAback '\'   'backAPC' num2str(im)  '.' 'TIF']);
   outputNameAshow = ([directoryAshow '\'   'showAPC' num2str(im)  '.' 'TIF']);
   end
   %reads in the files using the loop
   
   %red channel
    fileNameR=([directoryR '\' prefixR num2str(fovNumber) '_t' num2str(im) '.' 'TIF']);
    
    if APCchannel ==1
    %apc channel
    fileNameA=([directoryA '\' prefixA num2str(fovNumber) '_t' num2str(im) '.' 'TIF']);
    end
    %phase files
    fileNameP=([directoryP '\' prefixP num2str(fovNumber) '_t' num2str(im) '.' 'TIF']);
    
    phase = imread([fileNameP]);
    fluorImage = imread([fileNameR]);
    
    if APCchannel ==1
    apcImage = imread([fileNameA]);
    end
    
  %%%%%%%%%%%%%%%%%PHASE%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    phase2 =mat2gray(phase);
    
    ImNormP = imadjust(phase2,stretchlim(phase2),[]);
    
    
    imwrite(ImNormP,outputNameP, 'tif', 'Compression', 'none') ;
    
     %%%%%%%%%%%%%background subtracted FLUOR%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
  
  %%%first, subtract background (if do flatfield first, run risk of
  %%%positive pixels being below background value after division by
  %%%flatfield. eg, if real positive pixel is 1000, flatfiled for pixel is
  %%%100, flatfileding will give 10 for the pixel, below background level
  %%%which would be approx 100)
  
  backSubFluorPreImage = imsubtract(fluorImage,backgroundR);
    
  %%%%%%%%%%%flatfield normalization%%%%%%%%%%%%%%%%%%%%%%%%%%%  
    
    %this normalizes by flatfield matrix 
    %%%HAVE TO REDUCE FLATFIELD MATRIX BY FACTOR 10 OTHERWISE SIGNAL GETS
    %%%LOST AS RESULT OF DIVISION MAY BE <1 AND SO ROUNDED TO ZERO
    
backSubFluorPreImageFlat = imdivide(backSubFluorPreImage,flatfieldSmall);
 
%this sets any negative values to zero after background subtraction 
 backSubFluorPreImageFlat(find(backSubFluorPreImageFlat<0) ) = 0;
 
 %%%%%%%%%%%%%%%change data structure to double and save%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% backSubFluorImageNorm = mat2gray(backSubFluorPreImageFlat);
 
 imwrite(backSubFluorPreImageFlat ,outputNameR, 'tif', 'Compression', 'none') ;

 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%enhancement%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  fluorImage2=mat2gray(fluorImage);
 thresh_fluor=graythresh(fluorImage);
 
 %%%Use empirically determined fudgeFactorFluor to decrease threshold
  bw_fluor=im2bw(backSubFluorPreImage,(thresh_fluor+0.001)*fudgeFactorFluor);
  
   outputNameR2 = ([directoryRenhanced '\'   'enhanced' num2str(im)  '.' 'TIF']);
    
   imwrite(bw_fluor,outputNameR2, 'tif', 'Compression', 'none') ;
  
   %%%%%%%%%%%%%%%%%%%%APC%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   if APCchannel ==1;
  %subtract background APC
backSubApcPreImage = imsubtract(apcImage,backgroundA);

%this sets any negative values to zero after background subtraction 
 backSubApcPreImage(find(backSubApcPreImage<0) ) = 0;
  
  %%%backSubApcImage = mat2gray(backSubApcPreImage);
  
   backSubApcImage = backSubApcPreImage;
  
  imwrite(backSubApcImage,outputNameA, 'tif', 'Compression', 'none') ;
  
  %%%rescales for display
   backSubAPCforEnhanced = mat2gray(backSubApcImage);
   
   imwrite(backSubAPCforEnhanced, outputNameAshow, 'tif', 'Compression', 'none') ;
   
   end
 end
  cd('../');  
end
  
    end


end
%%%%%%%%%%%%DEEQANORM1_1END%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%DEEQANORM1_1END%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%DEEQANORM1_1END%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%   SEMIAUTOMATED CELL ANALYSIS START  %%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


if deeqaEdgeDetector == 1;
    
 tic   
directoryPnorm = 'normPhase';% phase 

directoryPlow = 'phaseLow';

prefixPnorm = 'normPhase';

   
    cd(directory);
for fovNumber = rangeToUse
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovNumber)]); 
    
    if exist(nameFOVfolder) ~=0;
    
    cd(nameFOVfolder);    
    
    mkdir('BW');
    
   
   

for image = fFirst:fLast;
    
   
    fileNamePnorm=([directoryPnorm '\' prefixPnorm  num2str(image) '.' 'TIF']);
    
    %out of focus phase files
    fileNamePlow=([directoryPlow '\' prefixP num2str(fovNumber+offsetToOutFocusFOV) '_t' num2str(image) '.' 'TIF']);
        
        phaseNorm=imread(fileNamePnorm);
        
        if useOutOfFocus ==1;
            
       phaseLow=imread(fileNamePlow);
        end
 
        if useOutOfFocus ==1;
            numberFocus =2;
            
        else 
            numberFocus =1;
        end
            
        for imageSet = 1:numberFocus;
            
           if imageSet ==2
        
       phase2 =mat2gray(phaseLow);
       
           else
 phase2 =phaseNorm;
 
           end
 
 if image ==1;
 figure, imshow(phase2);
 end
    
ImNormPlow = imadjust(phase2,stretchlim(phase2),[]);
         
 %f = imcomplement(ImNormP);
       
f = ImNormPlow;

        
        %%%threshold based on intensity, check if this is derived
        %%%automatically from image or not used
        [~, threshold] = edge(f, 'sobel');
        
        edgeObj = edge(f,'sobel', threshold * fudgeFactor);
if image ==1;
         figure, imshow(edgeObj);
end
      
         %%%step2: %# Try to close contours. check if this helps
         
         se90 = strel('line', 1, 90);
        se0 = strel('line', 1, 0);
   dilateObj = imdilate(edgeObj, [se90, se0]);
         
% %          closeEdgeObj = imclose(edgeObj,ones(6)); 
% %          
     if image ==1;   
         figure, imshow(dilateObj);
     end          
       
         %%%step 2: dilates contour lines to get partially filled object
         %%%the big advantage to dilating is creating closed objects which
         %%%have holes that can be automatically filled. After filling
         %%%holes, objects can be eroded to original size
        
      closeObj = imclose(dilateObj, ones(6));
 
         
        if image ==1;
        figure, imshow(closeObj);
        end
        
        %%%step 3: fills in holes

% % % %         fillObj = imfill(dilateObj, 'holes');

fillObj = imfill(closeObj, 'holes');
        
        if image ==1;
         figure, imshow(fillObj);
        end

       
       %%%step 4: slightly erodes obj border in attempt to seperate
         %%%objects

        seD = strel('diamond',1);
% % % %         erodeObj = imerode(fillObj,seD);

erodeObj = imerode(fillObj, seD);
       
        if image ==1;
       figure, imshow(erodeObj);
        end
        
        %%%step 5: gates out objects which are too small to be cells (LB =
         %%%lower bound)
        %LB = 100;
        %UB = 8000;
        BW = bwareaopen(erodeObj,LB);
        
        if image ==1;
        figure, imshow(BW); 
        end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%WATERSHED%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%1) DILATE BW TO SOFTEN OVERSEGMENTATION BY WATERSHED
se90 = strel('line', 15, 90);
        se0 = strel('line', 15, 0);
         bwImageDilate = imdilate(BW, [se90 se0]);
%%%bwImageDilate = BW;
     
       %%%% figure, imshow(bwImageDilate);
    

%bwImageDilate = BW;

%%%2) find perimeter

perimBwImageDilate = bwperim(bwImageDilate);

    if image ==1;
        figure, imshow(perimBwImageDilate);
    end

%%%3) find distance of each point inside cell from parimeter CREATES GRADIENT

gredientFromPerimDist = bwdist(perimBwImageDilate, 'euclidean');

%gredientFromPerimDist = gredientFromPerimDist.^0.1;

%gredientFromPerimDist(~bwImageDilate) = 200;

if image ==1;
figure;imagesc(gredientFromPerimDist);
end

%%%%%THIS IS A CRITICAL PARAMETER!!!! THE SECOND INPUT DETERMINES SIZE OF
%%%%%WATERSHED SEEDS AND SHOULD BE OPTIMIZED. RANGE 1 TO ????
mask_em = imextendedmax(gredientFromPerimDist, 2);

if image ==1;
figure;imshow(mask_em);
end

I_eq_c = imcomplement(gredientFromPerimDist);

I_mod = imimposemin(I_eq_c, ~bwImageDilate | mask_em);



%%%% 4) WATERSHED: a) reduce OVERSEGMENTATION USING ARBITRARY SCALAR howAggressiveThreshold, to eliminate
%%%% minima less than the depth howAggressiveThreshold

%%%NOTE THAT GRADIENT IS INVERTED TO GET MINIMA, IE -gredientFromPerimDist

% howAggressiveThreshold = -50;
% g=imhmin(gredientFromPerimDist,howAggressiveThreshold);


%%%b) watershed transform OF NEGATIVE GRADIENT
watershedTransformedIm = watershed(I_mod, 8);

%D_2 = watershed(-dd, 8);

if image ==1;
figure;imagesc(watershedTransformedIm);
end

%%%5) get rid of background segmentation by using BW image to multiply
%%%background pixels by zero - NO LONGER NEED THIS STEP WITH MARKER BASED
%%%WATERSHED

noBackgroundWatershed = single(watershedTransformedIm).*single(bwImageDilate);

noBackgroundWatershedBW = im2bw(noBackgroundWatershed);

%%LB = 100;
        %UB = 8000;
        noBackgroundWatershedBW = bwareaopen(noBackgroundWatershedBW,LB);
       %%% figure, imshow(BW); 
        
if image ==1;        
figure;imshow(noBackgroundWatershedBW);
end

% % outputNameBWwatershed =(['noBackgroundWatershed'   '.' 'TIF' ]);
% % 
% % imwrite(noBackgroundWatershedBW, outputNameBWwatershed, 'tif', 'Compression', 'none');


%%%6) SEPERATE AND LABEL OBJECTS, FIND CENTROIDS
        
        
        s =regionprops(noBackgroundWatershedBW,'Centroid');
        
        %%%%FOR THIS POINT ON, OBJECTS LABELLED
        %%%%CAN ALSO USE bwlabel
        %%%% TO GET AT SPECIFIC OBJECT IN LABELLED IMAGE, USE
        %%%% imshow(bw==26)FOR OBJECT 26 FOR EXAMPLE
% % % % % % % %      
% % % % % % % %     %%%some weird code needed to make the centriod a usable vector
   centroidXY = cat(1, s.Centroid);
   
   
if imageSet ==1
    
    BW1 = noBackgroundWatershedBW;
    
else
    BW2 = noBackgroundWatershedBW;

end
        end

if useOutOfFocus ==1;
multImage = BW1.*BW2;

else
    
    multImage = BW1;
    
end

%%multImage = BW1;

%%multImage = BW2;

%%%%LB = 100;
        %UB = 8000;
        multImage2 = bwareaopen(multImage, LB);
        
        outputNamemultImage2 = (['BWcombined' num2str(image) '.TIF']);
        
        cd('BW');
        
  imwrite(multImage2,outputNamemultImage2, 'tif', 'Compression', 'none')      
        
     cd('../');    
        
        
        
if image ==1
figure,

imshow(multImage2);

end

end
cd('../');  
    end
    
end

toc
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% make overlay of all fluor channels and cell outlines
if makeOverlay ==1;
  tic  
    cd(directory);
for fovNumber = rangeToUse
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovNumber)]); 
    
    if exist(nameFOVfolder) ~=0;
    
    cd(nameFOVfolder);    
%%%%%Create New Directories

 dirNameOverlay = (['outlines' 'FOV' num2str(fovNumber)]);
 dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovNumber)]);

%if firstTimeAnalysed == 1
    
    cd(directory);
    cd(nameFOVfolder);  
    
    mkdir(dirNameOverlay);
   mkdir(dirNameFinalOverlay);
    
%end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Overlay on Enchanced Fluor Image
    
    for im = fFirst:fLast
        
        %%%%calculate hours and minutes for clock
    
exactTimeInHours = (im*minutesBetweenFrames)/60;

hours = floor(exactTimeInHours);

minutes = round((exactTimeInHours - hours)*60);

hours_str = num2str(hours);
    
 if minutes ==0 
         minutes_str = '00';
   else
        minutes_str = num2str(minutes);
        
 end
      
   %1) LOAD normalized modified phase (1:255 range) 
        
        fileNameP = (['normPhase' '\' 'normPhase'  num2str(im) '.' 'TIF']);
        fileNameE = (['enhancedFluor' '\' 'enhanced'  num2str(im) '.' 'TIF']);
        fileNameBW = (['BW' '\' 'BWcombined' num2str(im) '.' 'TIF']);
        fileNameAPC = (['showAPC' '\' 'showAPC' num2str(im) '.' 'TIF']);
        
        phaseImage = imread(fileNameP);
        fluorImage = imread(fileNameE);
        bwImage = imread(fileNameBW);
        
        if APCchannel ==1;
        apcImage = imread(fileNameAPC);
        end
       
    %2) convert regions of bacteria to red
       %%%BW OF ENHANCED FLUOR!
        bwfluor = im2bw(fluorImage);
        if APCchannel ==1;
        apcImage(find(apcImage>0) ) = 255;
        bwAPC = im2bw(apcImage);
        end
    
        red = phaseImage./1.4;
        green = phaseImage./1.4;
        blue = phaseImage./1.4;
        
        red(bwfluor) = 255;
        green(bwfluor) = 0;
        if APCchannel ==1;
        blue(bwAPC) = 255;
        
        end
            
            
        bacteriaImage = cat(3,red,green,blue);
        
    %3) show fluor image and overlay object boundary
                   
        boundaries = bwboundaries(bwImage); 
       
       numberObjects = numel(boundaries);
       
       figure1 = figure(1);
        imshow(bacteriaImage);
        
        hold on;
       
       for k2=1:numberObjects;
b = boundaries{k2};
plot(b(:,2),b(:,1),'g','LineWidth',1);


       end
       
       %%%add the clock%%%%%%

text(x_clock, y_clock, [hours_str, ':', minutes_str], 'fontsize', clock_font_size, 'color', clock_color);

%%%%%%%%%%%%%%%%%%%%%%%%%
                      
    hold off; 
        
                   
    %4) save the image    
                       
        
        cd(dirNameOverlay);
         
        outputNameOverlay =(['outlines'  num2str(im)]);

        dialog.outputPath = cd;
        dialog.outputFilename = outputNameOverlay;
        ext = '.tif';
        print(['-f',int2str(figure1)],'-dtiff',fullfile(dialog.outputPath,[dialog.outputFilename,ext]))
        
        close all;
        
         cd('../'); 
        
    end
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 3) Resize Image for Analysis


    for im = fFirst:fLast
        
     
     cd(dirNameOverlay);
         
     inputNameOverlay =(['outlines'  num2str(im) '.' 'TIF']);
     
     overlayImage = imread(inputNameOverlay);
     
%      cropImage = overlayImage(52:800,226:974,:);
     cropImage = overlayImage(36:834,201:1000,:);
     
     finalImage = imresize(cropImage,[1024 1024]);
     
     cd('../'); 
     cd(dirNameFinalOverlay);
     
     finalOverlayName = (['finalOverlay' num2str(im) '.' 'TIF']);
     
     imwrite(finalImage,finalOverlayName,'tif','Compression','none');
     
     cd('../'); 
    
    end
    

 close all;
    
   cd('../');   
    end
end
toc
end

%%%%%%%%%%%%%ADD NEW BW FOR CELL-FREE

if addBW == 1;
    
    cd(directory);
    
    numberFramesAddBW = numel(frameRangeAddBW);
    
    fFirst = frameRangeAddBW(1); 
    fLast = numberFramesAddBW; 

    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovToAddBW)]); 
  
    cd(nameFOVfolder);
    
    for imageCount = fFirst:fLast;
        
        image = frameRangeAddBW(imageCount);
    
    outputNamemultImage2 = (['BWcombined' num2str(image) '.TIF']);
        
        cd('BW');
        
  BWimage = imread(outputNamemultImage2);      
        
     cd('../');  
     
      dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovToAddBW)]);
          
          cd(dirNameFinalOverlay);
     
     finalOverlayName = (['finalOverlay' num2str(image) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
          
      cd('../'); 
      
      figure1 = figure;
      
    imshow(overlayToDisplay);
    
    if image == fFirst;
        
        if usePloygon ==1;
            
            h= impoly(gca);
            
        else
        
     h= imellipse(gca);
     
        end
          
          %waits for user to modify ellipse
          position = wait(h);
          
          pos = getPosition(h);
          
          elseif image/addBWCorrectCycle == floor(image/addBWCorrectCycle);%%%%%%%%%lets you correct
              
              if usePloygon ==1;
            
            h= impoly(gca, pos);
            
              else
        
            h= imellipse(gca, pos);
        
              end
          
          position = wait(h);
          
           pos = getPosition(h);
          
    
    else %%%%reads off previous position 
        
        if usePloygon ==1;
            
            h= impoly(gca, pos);
            
        else
        
        h= imellipse(gca, pos);
        
        end
        
    end
    
    BWregion = createMask(h);
    
    if addInvertedBW ==1;
        
        BWimage(BWregion) = 0;
        
    else
    
    BWimage(BWregion) = 1;
    
    perimBWimage = bwperim(BWregion);
    
    se90 = strel('line', zerosHalo, 90);
        se0 = strel('line', zerosHalo, 0);
   dilatePerimBWimage = imdilate(perimBWimage, [se90, se0]);
    
    BWimage(dilatePerimBWimage) =0;
    
    end
    
    cd('BW');
        
  imwrite(BWimage,outputNamemultImage2, 'tif', 'Compression', 'none')      
        
     cd('../');  
     
     close all;
    
    end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%GUI%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if stegui ==1;

conceptGUIv2;

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%CORRECT UNDERSEGMENTATION 


    if correctUndersegmentation == 1;
        
        tic 
    
    
    cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovToCorrect)]); 
    
    cd(nameFOVfolder);
    
    posX1vector = [];
         posX2vector = [];
         posY1vector = [];
         posY2vector = [];
    
  for imageToCorr = 1:numel(framesToCorrectUndersegmentation);
      cd(directory);
      cd(nameFOVfolder);
        
          dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovToCorrect)]);
          
          cd(dirNameFinalOverlay);
          
          imageNumber = framesToCorrectUndersegmentation(imageToCorr);
     
     finalOverlayName = (['finalOverlay' num2str(imageNumber) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
          
      cd('../'); 
      
      cd('BW');
      
      BWfileName = (['BWcombined' num2str(imageNumber) '.' 'TIF']);
      
      BWfileNameNextFr = (['BWcombined' num2str(imageNumber+1) '.' 'TIF']);
      
      if imageNumber ~=1;
      BWfileNamePrevFr = (['BWcombined' num2str(imageNumber-1) '.' 'TIF']);
      end
      
      
      BWtoCorrect = imread(BWfileName);
      
      BWtoCorrectNextFr = imread(BWfileNameNextFr);
      
      if imageNumber ~=1;
      BWtoCorrectPrevFr = imread(BWfileNamePrevFr);
      end
      
      figure1 = figure;
      
     
        
        imshow(overlayToDisplay);
        
        
        text(x_pos, y_pos, ['frame' num2str(imageNumber)], 'fontsize', text_font_size, 'color', clock_color);
        
        hold on;
        
        %%%add lines from previous frames NOT EQUAL FIRST IMAGE
        if imageToCorr ~=1
            
            for line = 1:numel(posX1vector);
            
            pos(1,1)=  posX1vector(line);
           pos(2,1)=  posX2vector(line);
          pos(1,2)=  posY1vector(line);
          pos(2,2)=  posY2vector(line);
          
           h= imline(gca, pos);
           
          
            end
            
            %%%zero pos vectors for next round
           
           posX1vector = [];
         posX2vector = [];
         posY1vector = [];
         posY2vector = [];
        end
            
        
         for corr = 1:100;
             
              w = waitforbuttonpress;
              pause(0.0001);
               if w == 1;
                  
                  break;
                  
              end
       h= imline(gca);
          
          %waits for user to modify polygon
          position = wait(h);
          
           pos = getPosition(h);
          
     %%%each entry for pos has 4 elements x1, x2, y1, y2
         posX1vector = [posX1vector; pos(1,1)];
         posX2vector = [posX2vector; pos(2,1)];
         posY1vector = [posY1vector; pos(1,2)];
         posY2vector = [posY2vector; pos(2,2)];
        
          %%%creates mask out of impoly defined region
 BWzeroRegion = createMask(h);
 
 %%%%KEY STEP - PUT pixel VALUES WITHINN IMPOLY TO 0
 
  se90 = strel('line', 3, 90);
        se0 = strel('line', 3, 0);
        
        
  
        BWzeroRegion = imdilate(BWzeroRegion , [se90 se0]);
        
        %%%%writes in changes to current and next frame BW - popogates
        %%%%changes 1 frame
 
 BWtoCorrect(BWzeroRegion)= 0;
 BWtoCorrectNextFr(BWzeroRegion)= 0;
 
 if imageNumber ~=1;
 BWtoCorrectPrevFr(BWzeroRegion)= 0;
 end
       end
       
   hold off; 
          
close all;


%%%LB = 100;
        %UB = 8000;
        multImage2 = bwareaopen(BWtoCorrect,LB);
        
      multImage2 = BWtoCorrect;
      multImage3 = bwareaopen(BWtoCorrectNextFr,LB);
      
      if imageNumber ~=1;
      multImage4 = bwareaopen(BWtoCorrectPrevFr,LB);
      end
        
        outputNamemultImage2 = (['BWcombined' num2str(imageNumber) '.TIF']);
        outputNamemultImage3 = (['BWcombined' num2str(imageNumber+1) '.TIF']);
        
        if imageNumber ~=1;
        outputNamemultImage4 = (['BWcombined' num2str(imageNumber-1) '.TIF']);
        end
        
        
  imwrite(multImage2,outputNamemultImage2, 'tif', 'Compression', 'none');
  imwrite(multImage3,outputNamemultImage3, 'tif', 'Compression', 'none'); 
  
  if imageNumber ~=1;
   imwrite(multImage4,outputNamemultImage4, 'tif', 'Compression', 'none');
  end
  
  cd('../');
        
  end
  
    end
  
    
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%CORRECT UNDERSEGMENTATION SPECIAL CASE 


    if imFeelingLucky == 1;
      
    cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovToCorrect)]); 
    
    cd(nameFOVfolder);
    
    
    
  for imageToCorr = 1:numel(framesToCorrectUndersegmentation);
      cd(directory);
      cd(nameFOVfolder);
        
          dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovToCorrect)]);
          
          cd(dirNameFinalOverlay);
          
          imageNumber = framesToCorrectUndersegmentation(imageToCorr);
     
     finalOverlayName = (['finalOverlay' num2str(imageNumber) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
          
      cd('../'); 
      
      cd('BW');
      
      BWfileName = (['BWcombined' num2str(imageNumber) '.' 'TIF']);
      
      
      BWtoCorrect = imread(BWfileName);
      
      figure1 = figure;
        
        imshow(overlayToDisplay);
        
        
        text(x_pos, y_pos, ['frame' num2str(imageNumber)], 'fontsize', text_font_size, 'color', clock_color);
        
        hold on;
        
        %%%add lines from previous frames NOT EQUAL FIRST IMAGE
        if imageToCorr ==1
            
             h= imline(gca);
            
            %waits for user to modify polygon
          position = wait(h);
          
           pos = getPosition(h);
           
        elseif imageToCorr/feelingLuckyCorrectCycle == floor(imageToCorr/feelingLuckyCorrectCycle);
          
           h= imline(gca, pos);
           
           position = wait(h);
          
           pos = getPosition(h);
            
          else  
        
         h= imline(gca, pos);
         
         pos = getPosition(h);
                  
              end
      
    
          %%%creates mask out of impoly defined region
 BWzeroRegion = createMask(h);
 
 %%%%KEY STEP - PUT pixel VALUES WITHINN IMPOLY TO 0
 
  se90 = strel('line', 3, 90);
        se0 = strel('line', 3, 0);
        
 
        BWzeroRegion = imdilate(BWzeroRegion , [se90 se0]);
        
        %%%%writes in changes to current and next frame BW - popogates
        %%%%changes 1 frame
 
 BWtoCorrect(BWzeroRegion)= 0;

       
   hold off; 
          
close all;

%%%LB = 100;
        %UB = 8000;
        multImage2 = bwareaopen(BWtoCorrect,LB);
       
        outputNamemultImage2 = (['BWcombined' num2str(imageNumber) '.TIF']);
        
        
        
  imwrite(multImage2,outputNamemultImage2, 'tif', 'Compression', 'none');
  
  
  cd('../');
        
  end
  
  end
    
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
  if markovCutPropagation ==1;
      
     %%%propagate from image to image +1. this way can correct first image 
   tic 
     
    cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovToCorrectMarkov)]); 
    
    cd(nameFOVfolder);
    
    %%%mkdir('BWmarkov')
    
    
   for cycleNumber = 1:numberOfMarkovCycles;
       
  for imageToCorrMarkov = fFirst:fLast-1;
      cd(directory);
      cd(nameFOVfolder);
       
     
      cd('BW');
      
      BWfileNameCurrent = (['BWcombined' num2str(imageToCorrMarkov) '.' 'TIF']);
      
      BWfileNameNext = (['BWcombined' num2str(imageToCorrMarkov +1) '.' 'TIF']);
      
      
      BWcurrent = imread(BWfileNameCurrent);   
      
      BWNext = imread(BWfileNameNext);
     
     BWcurrent(~BWNext) = 0;
      
      BWcurrentNewNoSmall = bwareaopen(BWcurrent,LB);
      
      outputNameBWcurrentNew = BWfileNameCurrent;
      
      imwrite(BWcurrentNewNoSmall,outputNameBWcurrentNew, 'tif', 'Compression', 'none');
      
      
  end 
         
   end 
  toc
  end
  
  %%%%%%%%%%%%%%%%%%%%%%CORRECT OVERSEGMENTATION%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
  if correctOversegmentation == 1;
    
    %%%%%STRATEGY: USE IMCLOSE TO CLOSE OVERSEGMENTATION (WHICH USUALLY APPEARS
%%%%%AS THIN LINES) ON DILATED IMAGE

%%%%HOWEVER, DON'T WANT TO USE IMCLOSE ON FULL FIELD AS IT WILL ALSO CLOSE
%%%%OFF CORRECT SEGMENTATIONS. THEREFORE, DEFINE REGION TO USE IMCLOSE BY
%%%%IMPLOY

%%%%THEN, SET EVERYTHING OUTSIDE IMPOLY REGION TO 0 AND USE IMCLOSE

%%%%TO RETRURN CORRECTED REGION, MAKE IMAGE THAT CONTAINS EVERYTHING
%%%%OUTSIDE THE IMPOLY. THEN CONCATENATE CORRECTED IMAGE WITH IMAGE WHICH
%%%%CONTAINS EVERYTHING OUTSIDE IMPOLY
    
     
    tic
    
    cd(directory);
    
    cd([num2str(movieDate) 'FOV' num2str(fovToCorrectOverSeg)]);
    
    for imageToCorr = 1:numel(framesToCorrectOversegmentation);
        
          
          imageNumber = framesToCorrectOversegmentation(imageToCorr);
          
        
        %%%%1) LOAD FILES
        
   %i) LOAD normalized modified phase (1:255 range) 
     
  fileNameOverlay=(['finalOverlay'  num2str(imageNumber) '.' 'TIF']);
  
  cd('finalOverlayCompleteFOV22');
              
  image = imread([fileNameOverlay]);
    
  cd('../');
  
    %ii)    LOAD BW
          
cd('BW');

outputNameBWwatershed =(['BWcombined'  num2str(imageNumber) '.' 'TIF' ]);

%%%this will be the working image
bw = imread(outputNameBWwatershed);

cd('../');

 %%%for impoly and imclose 
 bw1 = bw;
 
 %%%everything outside imploy
  bw2 = bw;
  
  figure1 = figure;
  
  nameOfFigure = (['image' num2str(imageNumber)]);
set(figure1,'name',nameOfFigure,'numbertitle','off');
 
 imshow(image);
          
        h = impoly(gca);
        
         %h = imellipse(gca);
        
        position = wait(h);
        
          %%%creates mask out of impoly defined region
 BWimploy = createMask(h);
 %%%sets everything outside of imploy to 0 in bw1
 bw1(~BWimploy) = 0;
 
  %%%sets everything outside of imploy to 0 in bw2
 bw2(BWimploy) = 0;
 
 impolyOnlyImage = bw1;
 
 nonImployImage = bw2;
 
%%%THE KEY OPERATION - IMPLOSE OF OBJECTS IN IMPLOY
closeImploy = imclose(impolyOnlyImage,ones(6));

%%%%CONCATENATION OF MODIFIED IMPLOY REGION WITH UNMODIFIEED NON-IMPOLY
%%%%REGION IMAGE
imagebuilder = imadd(nonImployImage, closeImploy);

%%%ABOVE IMAGE IS DOUBLE IE 0, 255. NEED TO CONVERT TO 0, 1
imagebuilder = im2bw(imagebuilder);

%%%%%USES NEW SEGMENTATION TO REPLACE OLD noBackgroundWaterShed FILES AND
%%%%%RUN THROUGH REST OF ROUTINE

cd('BW');

newBWname =(['BWcombined'  num2str(imageNumber) '.' 'TIF' ]);

%%%this will be the working image
imwrite(imagebuilder, newBWname, 'tif', 'Compression', 'none');

cd('../');


%%%REDO OVERLAYS

dirNameOverlay = (['outlines' 'FOV' num2str(fovToCorrectOverSeg)]);
 dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovToCorrectOverSeg)]);

exactTimeInHours = (imageNumber*minutesBetweenFrames)/60;

hours = floor(exactTimeInHours);

minutes = round((exactTimeInHours - hours)*60);

hours_str = num2str(hours);
    
 if minutes ==0 
         minutes_str = '00';
   else
        minutes_str = num2str(minutes);
        
 end
      
   %1) LOAD normalized modified phase (1:255 range) 
        
        fileNameP = (['normPhase' '\' 'normPhase'  num2str(imageNumber) '.' 'TIF']);
        fileNameE = (['enhancedFluor' '\' 'enhanced'  num2str(imageNumber) '.' 'TIF']);
        fileNameBW = (['BW' '\' 'BWcombined' num2str(imageNumber) '.' 'TIF']);
        fileNameAPC = (['showAPC' '\' 'showAPC' num2str(imageNumber) '.' 'TIF']);
        
        phaseImage = imread(fileNameP);
        fluorImage = imread(fileNameE);
        bwImage = imread(fileNameBW);
        
        if APCchannel ==1;
        apcImage = imread(fileNameAPC);
        end
       
    %2) convert regions of bacteria to red
       %%%BW OF ENHANCED FLUOR!
        bwfluor = im2bw(fluorImage);
        if APCchannel ==1;
        apcImage(find(apcImage>0) ) = 255;
        bwAPC = im2bw(apcImage);
        end
    
        red = phaseImage./1.4;
        green = phaseImage./1.4;
        blue = phaseImage./1.4;
        
        red(bwfluor) = 255;
        green(bwfluor) = 0;
        if APCchannel ==1;
        blue(bwAPC) = 255;
        
        end
            
            
        bacteriaImage = cat(3,red,green,blue);
        
    %3) show fluor image and overlay object boundary
                   
        boundaries = bwboundaries(bwImage); 
       
       numberObjects = numel(boundaries);
       
       figure1 = figure(1);
        imshow(bacteriaImage);
        
        hold on;
       
       for k2=1:numberObjects;
b = boundaries{k2};
plot(b(:,2),b(:,1),'g','LineWidth',1);


       end
       
       %%%add the clock%%%%%%

text(x_clock, y_clock, [hours_str, ':', minutes_str], 'fontsize', clock_font_size, 'color', clock_color);

%%%%%%%%%%%%%%%%%%%%%%%%%
                      
    hold off; 
        
                   
    %4) save the image    
                       
        
        cd(dirNameOverlay);
         
        outputNameOverlay =(['outlines'  num2str(imageNumber)]);

        dialog.outputPath = cd;
        dialog.outputFilename = outputNameOverlay;
        ext = '.tif';
        print(['-f',int2str(figure1)],'-dtiff',fullfile(dialog.outputPath,[dialog.outputFilename,ext]))
        
        close all;
        
         cd('../'); 
        
    end
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 3) Resize Image for Analysis


    for im = fFirst:fLast
        
     
     cd(dirNameOverlay);
         
     inputNameOverlay =(['outlines'  num2str(imageNumber) '.' 'TIF']);
     
     overlayImage = imread(inputNameOverlay);
     
%      cropImage = overlayImage(52:800,226:974,:);
     cropImage = overlayImage(36:834,201:1000,:);
     
     finalImage = imresize(cropImage,[1024 1024]);
     
     cd('../'); 
     cd(dirNameFinalOverlay);
     
     finalOverlayName = (['finalOverlay' num2str(imageNumber) '.' 'TIF']);
     
     imwrite(finalImage,finalOverlayName,'tif','Compression','none');
     
     cd('../'); 
    
    end
    

 close all;
    
   cd('../');   
    end


   

%%%%CHOOSER%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  %%% start deeqaChooser  

if deeqaChooser == 1;
    tic
    
    %%%%DO ON MULTIPLE CELLS
    
    xpointVector = [];

    ypointVector = [];
    
    cd(directory);
    
    %%%%GATHER POINTS USING IMPOINT%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
       nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovChosen)]); 
    
    cd(nameFOVfolder);
    
    mkdir('cellPositions');
    
     dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovChosen)]);
          
          cd(dirNameFinalOverlay);
          
     finalOverlayName = (['finalOverlay' num2str(1) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
     
     cd('../')
     
     %%%LOAD PREVIOUS HERDS TO SHOW PREVIOUSLY PICKED CELLS
     
     %%%%LOAD PREVIOUS HERDS
        
        herds = 0;
        for previousHerds =1:50;
        if exist(['cellHerdBW' num2str(previousHerds)])~=0;
            herds = herds+1;
             
            cd(['cellHerdBW' num2str(previousHerds)])
            %%%use cell array to store images (can aslo use eval function
            %%%to change name, eg eval(['A' 'B' '=10']) has the same effect as AB=10
            %%%not nerccesary as modify image sequentially anyway
         %%%%prevHerdBW{previousHerds} = imread(['BWcombinedHerd' num2str(1)]);
         prevHerdBW = imread(['BWcombinedHerd' num2str(1) '.TIF']);
         
         prevHerdBW = im2bw(prevHerdBW);
         overlayToDisplay(prevHerdBW)=255;
         
        cd('../')
        end
        end
        
          
    
%%%%3) use impoint to gather points
        %%%%%%%%%%%%%%%%%%%%%%%%%  IMPOINT  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
              
            figure1 = figure;
        
        imshow(overlayToDisplay);
        
        hold on;
        
        
            
            for pointsToAdd = 1:numberCellsInHerd;
        
             h = impoint(gca);
             
              %%%get position of point
      %%%IF FIRST FRAME, GET POSITION FROM IMPOINT
            pos = getPosition(h);
            
            %%%%GATHER MULTIPLE POSITIONS, X = POS(1), Y= POS(2)
            
            % % % %%%get x and y coord of position 
                xpoint = pos(1);

                ypoint = pos(2);
                
                
                
                % % % %%%store in vector 
                xpointVector = [xpointVector, xpoint];
                
                cd(directory);
                 cd(nameFOVfolder);
                cd('cellPositions');
                save('xpoint', 'xpointVector');

                ypointVector = [ypointVector, ypoint];
                
                
                save('ypoint', 'ypointVector');
                
                cd('../');
            
            end

             close all;
             
             
             
%%%%%%%%%%%%%PERFORM HERDING OF CELLS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


  centroidXYlist =[];
   
   cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovChosen)]); 
    
    cd(nameFOVfolder);
%%%%%Create New Directories

%%%make new folder for herd thats seperate from the other herds

for herdFolderNumber = 1:50;
    nameHerdfolder = (['cellHerdBW' num2str(herdFolderNumber)]); 
    
    if exist(nameHerdfolder) ==0;
        
        mkdir(['cellHerdBW' num2str(herdFolderNumber)]);
        
        break;
        
    end
    
end
  
 
  for imageNumber = fFirst:fLast;
      
% % % %     %%%  IMPORTANT!!! -ZERO CENTROID XY LIST SINCE CONCATANATING, OTHERWISE
% % % %     %%%  WILL JUST APPEND
% % % %     if imageNumber>1;
% % % %     centroidXYlistPrev = centroidXYlist;
% % % %     end
   
        
          dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovChosen)]);
          
          cd(dirNameFinalOverlay);
          
          
     finalOverlayName = (['finalOverlay' num2str(imageNumber) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
          
      cd('../'); 
      
      cd('BW');
      
      BWfileName = (['BWcombined' num2str(imageNumber) '.' 'TIF']);
      
      BW2 = imread(BWfileName);
      
      %%%use this to insert ellipse 
      
      if imageNumber <fLast;
      BWfileNameNext = (['BWcombined' num2str(imageNumber+1) '.' 'TIF']);
      BW2next = imread(BWfileNameNext);
      end
      
      
      cd('../'); 
      
      fileNamePreviousBWherd = (['cellHerdBW' num2str(herdFolderNumber) '\' 'BWcombinedHerd' num2str(imageNumber-1) '.' 'TIF']);
      if imageNumber>1
        previousBWHerdPre = imread(fileNamePreviousBWherd);
        
        %%%DON'T KNOW WHY IT STOPS BEING A BW BUT IT DOES
         previousBWHerd = im2bw(previousBWHerdPre);
      end
      
  
% % % %       %%%KEEP OLD BWBASE
% % % %       
% % % %       if imageNumber>1;
% % % %       BWbasePrevious = BWbase;
% % % %       end
      
      %%%MAKE BLACK BW INTOWHICH INDIVIDUAL OBJECTS WILL BE ADDED - zero it
        BWbase = BW2.*0;
      
      %%%GET CENTROID POSITIONS FOR OBJECTS IN BW2
% % %       if imageNumber==1;
      L = bwlabel(BW2);
       s = regionprops(BW2, 'Centroid');
       
% % % %        if imageNumber>1;
% % % %        LL = bwlabel(BWbasePrevious);
% % % %        ss = regionprops(BWbasePrevious, 'Centroid');
% % % %        end
       
% % % %        if imageNumber == fFirst;
           
       numberCellsToChoose =   numberCellsInHerd;
       
% % % %        else
           
% % % %            numberCellsToChoose = numel(ss);
           
% % % %        end
% % %       end
% % %       
% % %       else
% % %           
% % %           L = bwlabel(BWbase);
% % %        s = regionprops(BWbase, 'Centroid');
      %%%%do operation for all chosen cells
      for cellToDo = 1:numberCellsToChoose ;
          
        %%%  for cellToDo = 1:numel(s) ;
          
          %%%ZERO HERE AS CALCULATED FOR EVERY CELL
       distVector =[];
      
    if imageNumber == fFirst;
        
       %%% imageNumber == fFirst && cellToDo <= numberCellsToChoose;
            
            cd(directory);
             cd(nameFOVfolder);
            cd('cellPositions');
            
            load('xpoint')
            load('ypoint')
            
            pos = ([xpointVector(cellToDo), ypointVector(cellToDo)]); 
            
      cd('../');
      
      %%%cd('BW');
             
             else
             
            
           %%% get position from previous centriod position - each cell is one row, order doesn't change 
          pos = centroidXYlist(cellToDo, 1:2);

        end
        
% % %         close all;
        
        xpointToUse = pos(1);
        
        ypointToUse = pos(2);
        
        
        %%%store centroid location
        centroidPos = [xpointToUse; ypointToUse];
        %centroidMatrix = [centroidMatrix, centroidPos];
       
        %%%%%%%%%%%%%%%%%%%  Calculating nearest centroid %%%%%%%%%%%%%%%%%
        for k3 = 1:numel(s)
            c = s(k3).Centroid;
      
        %%%FIND RMS DISTANCE BETWEEN CENTROID AND IMPOINT
            dist = sqrt((c(1)-xpointToUse)^2 + (c(2)-ypointToUse)^2);

            distVector = [distVector, dist];
        end
       % hold off

        
        %%%FIND MINIMUM RMS
        minRMS= min(distVector);

        %%%FIND THE CENTROID CORRESPONDING TO MIN RMS

        for i = 1: numel(distVector)

            if distVector(i) == minRMS;

                centroidMinRMS = i;
        %       k = [k, i];
                break;

            end
        end  
      
      
      cd('../'); 
% % %         %%%%THIS CELL NAME WILL BE USED TO LABEL CELL
% % %        if imageNumber == fFirst;
% % %         cellNumber = centroidMinRMS;
       
    %%%%1) FIND CLOSEST BW -NOTE centroidMinRMS IS THE OBJECT NUMBER!   
   %%%%%%%%%%%%%%%KEY STEP%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    %%%define the right cell - the one closest to impoint
            BWsingleCell = L==centroidMinRMS;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   
       
    
    
       
       if overlapRequired ==1 && imageNumber>1;
            
            overlapBetweenCurrPrev = sum(sum(previousBWHerd(BWsingleCell)));
            
            %%%WILL ONLY WORK IF YOU TAKE INCORRECT OBJECT OUT, OTHERWISE,
            %%%OVERLAP WILL COME BACK AFTER INSERTED OBJECT FROM HERD, BUT
            %%%SINCE IN NEXT FRAME HERD WILL HAVE BOTH OBJECTS
            
            %%%regions don't overlap - most likely centroid jump. THEREFORE
            %%%USE PREV BW HERD TO FIND CLOSEST LOCATION - BASICALLY WHAT
            %%%WE HAVE AS INPUT, THEREFORE OBJECT BOUNDARY DOES NOT CHANGE
        if overlapBetweenCurrPrev ==0;
            
            L1 = bwlabel(previousBWHerd);
       s1 = regionprops(previousBWHerd, 'Centroid');
       
       %%%FIND OBJECT NYUMBER CORRESPONDING TO STORED CENTROID LOCATION.
       %%%NOTE L==OBJECT NUMBER!
       
       for p = 1:numel(s1)
            c1 = s1(p).Centroid;
      if c1 == pos;
          correctObjectNumber =p;
          
          break;
        
        end
       end
       
    %%%%1) FIND  BW  from previous herd frame
   %%%%%%%%%%%%%%%KEY STEP%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    %%%define the right cell - the one closest to impoint
            BWsingleCellPrev = L1==correctObjectNumber;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   
      
     
        end
       
       end
       
       
                
                %%%store centroid for each cell in same order
                
                if overlapRequired ==1 && imageNumber>1 && overlapBetweenCurrPrev ==0;
                    %%%take previous centroid position for this frame
                    centroidXYlist(cellToDo, :) = centroidPos;
                    
                     BWbase(BWsingleCellPrev) = 1;
                    
                else
                    
                    %%%%ADD THE OBJECT TO THE BLACK BW
       BWbase(BWsingleCell) = 1;
       
    %%%FIND CENTROID OF FOUND BW
centroidCurrentCell =regionprops(BWsingleCell,'Centroid');
     
    %%%some weird code needed to make the centriod a usable vector
%             preCentroidXY = cat(1, kappa.Centroid);
             
%             centroidXY = preCentroidXY(1, :);

                centroidXY = [centroidCurrentCell.Centroid];  
% % % %        centroidXYlist = [centroidXYlist; centroidXY];
       centroidXYlist(cellToDo, :) = centroidXY;
       
                end
       
      %%%end of loop going through the picked cells
      end
      
      %%%%MAKE OVERLAY WITH NEW BW, include previous cell location to
      %%%%better visualize if cell moved or centroid jumped
      
       cd(directory);
    
    cd(nameFOVfolder);
       
      %1) LOAD normalized modified phase (1:255 range) 
        
        fileNameP = (['normPhase' '\' 'normPhase'  num2str(imageNumber) '.' 'TIF']);
        fileNameE = (['enhancedFluor' '\' 'enhanced'  num2str(imageNumber) '.' 'TIF']);
        
        fileNameAPC = (['backAPC' '\' 'backAPC' num2str(imageNumber) '.' 'TIF']);
        
        phaseImage = imread(fileNameP);
        fluorImage = imread(fileNameE);
        if APCchannel ==1;
        apcImage = imread(fileNameAPC);
        end
        
    %2) convert regions of bacteria to red
       %%%BW OF ENHANCED FLUOR!
        bwfluor = im2bw(fluorImage);
        if APCchannel ==1;
        apcImage(find(apcImage>0) ) = 255;
        bwAPC = im2bw(apcImage);
        end
        red = phaseImage./1.4;
        green = phaseImage./1.4;
        blue = phaseImage./1.4;
        
        red(bwfluor) = 255;
        green(bwfluor) = 0;
        if APCchannel ==1;
        blue(bwAPC) = 255;
        end
        if imageNumber>1
        %%%overlay previous BW herd in blue
      previousObjects = bwlabel(previousBWHerd);
       perimPrevObj = bwperim(previousObjects);
       se90 = strel('line', 3, 90);
        se0 = strel('line', 3, 0);
   dilatePerimPrevObj = imdilate(perimPrevObj, [se90, se0]);
       blue(dilatePerimPrevObj) = 255;
        end
        
        bacteriaImage = cat(3,red,green,blue);
        
    %3) show fluor image and overlay object boundary
         BWbase = im2bw(BWbase);
         
         %%%%SHOW bw HERD FOR TROUBLESHOOT
         %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % % %          figure, imshow(BWbase), hold on;
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        % BWbase = bwareaopen(BWbase,LB);
         
        boundaries = bwboundaries(BWbase);
        
         
        s =regionprops(BWbase,'Centroid');
         
       
       %%%%%%numberObjects = numel(boundaries);
       
       numberObjects = numel(s);
       
       figure1 = figure;
        imshow(bacteriaImage);
        
        hold on;
 %%%current BW herd      
       for k2=1:numberObjects;
b = boundaries{k2};


c = s(k2).Centroid;

plot(b(:,2),b(:,1),'g','LineWidth',1);


text(c(1)+20,c(2)+20,([num2str(herdFolderNumber) '.' num2str(k2)]),'backgroundcolor','g');

       end
  
       
       cropImage = bacteriaImage(36:834,201:1000,:);
     
     finalImage = imresize(cropImage,[1024 1024]);
     
% % %      close(figure1);
% % %      
% % %      figure2 = figure;
% % %         imshow(finalImage);
% % %         
% % %         hold on;
       if noNeedToPause == 0;
      usedEllipse =0;
      for corr = 1:numberCellsToChoose;
          
           w = waitforbuttonpress;
              pause(0.0001);
               if w == 1;
                  
                  break;
                  
                  else
                   
                   usedEllipse = usedEllipse+1;
                  
               end
              
               
             
        if useEraseEllipse ==1;
          
         
       h= imellipse(gca);
          
          %waits for user to modify polygon
          position = wait(h);
          
          %%% pos = getPosition(h);
      
      BW1region = createMask(h);
      
      
      %%%erases previous object
      BWbase(BW1region) =0;
      
      end
      
      h2= imellipse(gca);
          
          %waits for user to modify polygon
          position = wait(h2);
          
          %%% pos = getPosition(h);
      
      BW2region = createMask(h2);
      
      BWbase = im2bw(BWbase);
      
      BWbase(BW2region) =1;
      
      %%%%also write it in to the next main BW
      
      if imageNumber<fLast
      BW2next(BW2region) =1;
      end
      
      perimBWimage = bwperim(BW2region);
    
    se90 = strel('line', 2, 90);
        se0 = strel('line', 2, 0);
   dilatePerimBWimage = imdilate(perimBWimage, [se90, se0]);
    
    BWbase(dilatePerimBWimage) =0;
    
    %%%%also write it in to the next main BW
      
      if imageNumber<fLast
      BW2next(dilatePerimBWimage) =0;
      end
    
    
    %%%%FIND CENTROID POSITION OF ELLIPSE. REPLACE CLOSEST CENTROID TO
    %%%%ELLIPSE BT ELLIPSE CENTROID
      centroidEllipse =regionprops(BW2region,'Centroid');

                centroidXYellipse = [centroidEllipse.Centroid];  
                
                 pos = centroidXYellipse(1, 1:2);
        
        xpointToUse = pos(1);
        
        ypointToUse = pos(2);
        
        
        %%%store centroid location
        centroidPos = [xpointToUse, ypointToUse];
        %centroidMatrix = [centroidMatrix, centroidPos];
       
        %%%%%%%%%%%%%%%%%%%  Calculating nearest centroid %%%%%%%%%%%%%%%%%
        
       %%%store centroid location
        centroidPos = [xpointToUse, ypointToUse];
        %centroidMatrix = [centroidMatrix, centroidPos];
       
        %%%%%%%%%%%%%%%%%%%  Calculating nearest centroid %%%%%%%%%%%%%%%%%
        
        distVector2 =[]
        for k4 = 1:numberCellsToChoose;
            
          c =  centroidXYlist(k4, :); 
         
        %%%FIND RMS DISTANCE BETWEEN CENTROIDs AND Ellipse centroid
            dist = sqrt((c(1)-xpointToUse)^2 + (c(2)-ypointToUse)^2);

            distVector2(k4) = dist;
        end

   %%%FIND MINIMUM RMS
        closestCentroidToEllipse= min(distVector2);
        
        %%%find index of closest centroid
        
        indexOfClosestCentroid = find(distVector2 == closestCentroidToEllipse);
        
        
        %%%%erase closest BW  - not done yet
        
% % %         L = bwlabel(BWbase);
% % %         
% % %         s = regionprops(BWbase, 'Centroid');
% % %        
% % %             BWsingleCellToErase = L==closestCentroidToEllipse;
% % %             
% % %             BWbase(BWsingleCellToErase) = 0;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   
        
        %%%replace that centroid with centroid of new object
        
        centroidXYlist(indexOfClosestCentroid, :) = centroidPos;
        
        
        
        
    
      end
      
       
  close all
     cd(['cellHerdBW' num2str(herdFolderNumber)]); 
     
      
      BWfileNameHerd = (['BWcombinedHerd' num2str(imageNumber) '.' 'TIF']);
      
      imwrite(BWbase,BWfileNameHerd, 'tif', 'Compression', 'none') ;

cd('../'); 

%%%write the next BW main with ellipse

cd('BW');
      
      
      %%%write ellipse 
      
      if imageNumber <fLast && usedEllipse>0;
      
      imwrite(BW2next,BWfileNameNext, 'tif', 'Compression', 'none') ;
       
      end
      
      
      cd('../'); 

       else
           
           close all
     cd(['cellHerdBW' num2str(herdFolderNumber)]); 
     
      
      BWfileNameHerd = (['BWcombinedHerd' num2str(imageNumber) '.' 'TIF']);
      
      imwrite(BWbase,BWfileNameHerd, 'tif', 'Compression', 'none') ;

cd('../'); 

       end
  
  end
      
 %%%%%%%%%%%%%%%%ACQUIRE BW AND FLUOR FOR EACH CELL INDIVIDUALLY%%%%%%%%%%%%%%    
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovChosen)]); 
    
    cd(nameFOVfolder);  
 
 
    
   for cellToDo = 1:numberCellsToChoose ;
    tic
    
    areaCellVect =[];
    sumSigBackVect = [];  
    centroidMatrix =[];
    pos=[];
   
   cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovChosen)]); 
    
    cd(nameFOVfolder);
    
    
  for imageNumber = fFirst:fLast;
        
          dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovChosen)]);
          
          cd(dirNameFinalOverlay);
          
          
     finalOverlayName = (['finalOverlay' num2str(imageNumber) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
          
      cd('../'); 
      
% % %       dirmCherrySignalbackFlick = 'noFlick';
      
       dirmCherrySignalback = 'backFluor';
      
% % %       mCherryFileNameFlick = (['noFlick' num2str(imageNumber) '.' 'TIF']);
      
      mCherryFileName = (['back' num2str(imageNumber) '.' 'TIF']);
      
      
      cd(dirmCherrySignalback);
      
      imNormRback = imread(mCherryFileName);
      
      cd('../');
      
      
% % %       cd(dirmCherrySignalbackFlick);
      
% % %       imNormRbackFlick = imread(mCherryFileNameFlick);
      
% % %       cd('../');
      
      cd(['cellHerdBW' num2str(herdFolderNumber)]);
      
      BWfileName = (['BWcombinedHerd' num2str(imageNumber) '.' 'TIF']);
      
      BW2 = imread(BWfileName);
      
       BW2 = im2bw(BW2);
      
      L = bwlabel(BW2);
       s = regionprops(BW2, 'Centroid');
       
       
       %%%ZERO HERE AS CALCULATED FOR EVERY FRAME
       distVector =[];
       
     

%%%%3) read out the previously stored impoint coord on first
%%%%frame
        
       
        
        if imageNumber == fFirst
            
            cd(directory);
             cd(nameFOVfolder);
            cd('cellPositions');
            
            load('xpoint')
            load('ypoint')
            
            pos = ([xpointVector(cellToDo), ypointVector(cellToDo)])
            
      cd('../');
      
      cd('BW');
             
             else
             
            
           %%% if not first frame OR CENTROID NEEDS NO MODIFICATION, get position from previous centriod position 
          pos = centroidXY(1, 1:2);

        end
        
% % %         close all;
        
        xpointToUse = pos(1);
        
        ypointToUse = pos(2);
        
        
        %%%store centroid location
        centroidPos = [xpointToUse; ypointToUse];
        centroidMatrix = [centroidMatrix, centroidPos];
       
        %%%get x, y coord for centroids, will be contained in c
        for k3 = 1:numel(s)
            c = s(k3).Centroid;

        

        %%%%%%%%%%%%%%%%%%%  Calculating nearest centroid %%%%%%%%%%%%%%%%%

     
      
        %%%FIND RMS DISTANCE BETWEEN CENTROID AND IMPOINT
            dist = sqrt((c(1)-xpointToUse)^2 + (c(2)-ypointToUse)^2);

            distVector = [distVector, dist];
        end
       % hold off

        
        %%%FIND MINIMUM RMS
        minRMS= min(distVector);

        %%%FIND THE CENTROID CORRESPONDING TO MIN RMS

        for i = 1: numel(distVector)

            if distVector(i) == minRMS;

                centroidMinRMS = i;
        %       k = [k, i];
                break;

            end
        end

        cd('../'); 
        %%%%THIS CELL NAME WILL BE USED TO LABEL CELL
       if imageNumber == fFirst;
        cellNumber = centroidMinRMS;
    
        
    mkdir(['BWsingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumber)]);
    mkdir(['analysis' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumber)]);
    mkdir(['overlaySingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumber)]);
  
       end
    
    %%%%1) FIND CLOSEST BW   
   %%%%%%%%%%%%%%%KEY STEP%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    %%%define the right cell - the one closest to impoint
            BWsingleCell = L==centroidMinRMS;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %%%%save the single cell phase image, and the single cell BW image
    
    
 %%%2) SET EVERYTHING OUTSIDE FOUND BW TO ZERO   

BW2(~BWsingleCell) = 0;

%%%3) CHECK IF AREA DIDN'T DOUBLE OR HALF- IF DOUBLED, MOST LIKELY FUSED BW
%%%WITH ANOTHER CELL, IF HALVED, MOST LIKELY CENTROID JUMP

areaCell = bwarea(BWsingleCell);
areaCellVect =  [areaCellVect, areaCell];


if areaProofreader ==1 && imageNumber >fFirst && areaCell > 2*areaCellVect(imageNumber-1) ; %%%use previous image so have to start first image +1
%%%&& imageNumber/2 == floor(imageNumber/2) 
    cd(['BWsingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumber)]);
    
    %%%replace current object with last object
    BW2 = imread(['BWsinglecell' num2str(imageNumber-1) '.TIF']);
    
   %%%% find centroid of last good BW - ie BW for this frame will be copied
   %%%% from BW of previous frame
    centroidCurrentCell =regionprops(BW2,'Centroid');
  
 centroidXY = [centroidCurrentCell.Centroid];
                
 outputNameBW2 = (['BWsinglecell' num2str(imageNumber) '.TIF']);

imwrite(BW2,outputNameBW2, 'tif', 'Compression', 'none') ;

cd('../'); 

else

%%%4) FIND CENTROID OF FOUND BW
centroidCurrentCell =regionprops(BWsingleCell,'Centroid');
     
    %%%some weird code needed to make the centriod a usable vector
%             preCentroidXY = cat(1, kappa.Centroid);
             
%             centroidXY = preCentroidXY(1, :);

                centroidXY = [centroidCurrentCell.Centroid];
                
                 %%%%will give a matrix of fLast rows and 2 columns per row
            %%%centroidXYmatrix = [centroidXYmatrix; centroidXY(1, 1:2)];

outputNameBW2 = (['BWsinglecell' num2str(imageNumber) '.TIF']);

cd(['BWsingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumber)]);

imwrite(BW2,outputNameBW2, 'tif', 'Compression', 'none') ;

cd('../'); 

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Overlay on Enchanced Fluor Image


    
    %dirNameOverlay = (['OverlayForPick-upCell' num2str(cellNumber)]);
    
    
        
        %%%%calculate hours and minutes for clock
    
exactTimeInHours = (imageNumber*minutesBetweenFrames)/60;

hours = floor(exactTimeInHours);

minutes = round((exactTimeInHours - hours)*60);

hours_str = num2str(hours);
    
 if minutes ==0 
         minutes_str = '00';
   else
        minutes_str = num2str(minutes);
        
 end
        
     
               
   %1) LOAD normalized modified phase (1:255 range) 
        
        fileNameP = (['normPhase' '\' 'normPhase'  num2str(imageNumber) '.' 'TIF']);
        fileNameE = (['enhancedFluor' '\' 'enhanced'  num2str(imageNumber) '.' 'TIF']);
        %fileNameBW = (['cellHerdBW' '\' 'BWcombinedHerd' num2str(imageNumber) '.' 'TIF']);
        fileNameAPC = (['backAPC' '\' 'backAPC' num2str(imageNumber) '.' 'TIF']);
        
        phaseImage = imread(fileNameP);
        fluorImage = imread(fileNameE);
        bwImage = BW2;
        if APCchannel ==1;
        apcImage = imread(fileNameAPC);
        end
    %2) convert regions of bacteria to red
       %%%BW OF ENHANCED FLUOR!
        bwfluor = im2bw(fluorImage);
        if APCchannel ==1;
        apcImage(find(apcImage>0) ) = 255;
        bwAPC = im2bw(apcImage);
        end
        red = phaseImage./1.4;
        green = phaseImage./1.4;
        blue = phaseImage./1.4;
        
        red(bwfluor) = 255;
        green(bwfluor) = 0;
        if APCchannel ==1;
        blue(bwAPC) = 255;
        end
        bacteriaImage = cat(3,red,green,blue);
        
    %3) show fluor image and overlay object boundary
                   
        boundaries = bwboundaries(bwImage); 
        
        
      
       
       
%        numberObjects = numel(boundaries);
       
       figure1 = figure(1);
        imshow(bacteriaImage);
        
        hold on;
       
%        for k2=1:numberObjects;
b = boundaries{1};
plot(b(:,2),b(:,1),'g','LineWidth',1);


%        end
       
       %%%add the clock%%%%%%


text(x_clock, y_clock, [hours_str, ':', minutes_str], 'fontsize', clock_font_size, 'color', clock_color);



%%%%%%%%%%%%%%%%%%%%%%%%%
                      
    hold off; 
        
                   
    %4) save the image    
                       
        
        cd(['overlaySingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumber)]);
        
        
         
        outputNameOverlay =(['outlineSingle'  num2str(imageNumber)]);

        %%%%REDUCE SIZE OF THESE FILES BY USING JPEG COMPRESSION
        
        
        dialog.outputPath = cd;
        dialog.outputFilename = outputNameOverlay;
        ext = '.jpg';
        print(['-f',int2str(figure1)],'-djpeg',fullfile(dialog.outputPath,[dialog.outputFilename,ext]))
        
        close all;
        
         cd('../'); 
        
   %%%%FIND McHERRY SIGNAL IN BW
   
    sumSigBack = sum(sum(imNormRback(BWsingleCell)));
 sumSigBackVect=  [sumSigBackVect, sumSigBack];
   
% % %    sumSigBackFlicker = sum(sum(imNormRbackFlick(BWsingleCell)));
% % %  sumSigBackVectFlicker =  [sumSigBackVectFlicker, sumSigBackFlicker];
    
  end
 cd(['analysis' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumber)]);
 
% % %  save('sumSigBackFlicker', 'sumSigBackVectFlicker');
 
 save('sumSigBack', 'sumSigBackVect');
 
 figure
        plot(fFirst:fLast, sumSigBackVect, 'k')
        print -r600 -dpdf sumSigBackVect
        
        close all;
        %%%%save centroid matrix
        
        save('centroid', 'centroidMatrix');
   
        figure1 = figure
        
         ylim([0, 1023]);
         xlim([0, 1023]);
         axis('square')
 
 hold('all');
        
        plot (centroidMatrix(1,:), centroidMatrix(2,:), 'LineStyle', '-', 'LineWidth', 2);
  
        print -r600 -dpdf centroid
        
        
% % % figure
% % %         plot(fFirst:fLast, sumSigBackVectFlicker, 'k')
% % %         print -r600 -dpdf sumSigBackVectFlicker
        
   end

toc
end



        %%%%%%%%%%%%%%%%%%%%%%%%%%%%% start simpleChooser%%%%%%%%%%%%%%%%%%%%%%%%%
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if simpleChooser == 1;
    
    
    tic
    sumSigBackVect=[];
    
    constantHerdNumber = 200;
    
    herdFolderNumber = constantHerdNumber;
    
    
    
    fFirst = firstFrameCell;
   fLast = lastFrameCell;
    
    cd(directory);
    
    
    
     nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovChosen)]); 
    
    cd(nameFOVfolder);
   
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%PICK FIRST CENTROID
   
    
     dirNameFinalOverlay = (['finalOverlayComplete' 'FOV' num2str(fovChosen)]);
          
          cd(dirNameFinalOverlay);
          
     finalOverlayName = (['finalOverlay' num2str(fFirst) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
     
     cd('../')
     
     %%%LOAD PREVIOUS CELLS TO SHOW PREVIOUSLY PICKED CELLS AND DETERMINE
     %%%NUMBERING OF NEXT CELL
    
        cells = 1;
        for constantHerdNumber = 1:200;
        for previousCells =1:50;
        if exist(['BWsingleHerd' num2str(constantHerdNumber) 'Cell' num2str(previousCells)])~=0;
            
            %%%%make sure folder wasn't created in an aborted run
            
            cd(['BWsingleHerd' num2str(constantHerdNumber) 'Cell' num2str(previousCells)]);
            
% % %             folder_contents=numel(dir(['BWsingleHerd' num2str(constantHerdNumber) 'Cell' num2str(previousCells)]))
% % %             
% % %            if folder_contents ~=0;
               
               %%%GET FIRST IMAGE NUMBER
           
           
           %%%get all tif files
           list = dir(fullfile(cd, '*.TIF'));
           
           if numel(list)~=0;
           
           %%%extract the names
           name = {list.name};
           
           %%%makethem into one string
           str  = sprintf('%s#', name{:});

           %%%cut string up to left and right of "cell"
           s =  regexp(str, 'Cell|\.', 'split');
           
           %%%take only strings corresponding to the numbers
           numOnly = s(2:2:numel(s));
           
           %%%convert from string to number
           realNum = str2double(numOnly);
           
           %%%sort low to high
          sortedNum =sort(realNum);
          
          %%%take first element = first frame
          firstFileNum = sortedNum(1);
 
           %%%% if exist(['BWsinglecell' num2str(1) '.TIF'])~=0;
            
            cells = previousCells+1;
            
            
            %cd(['BWsingleHerd200Cell' num2str(previousCells)]);
            %%%use cell array to store images (can aslo use eval function
            %%%to change name, eg eval(['A' 'B' '=10']) has the same effect as AB=10
            %%%not nerccesary as modify image sequentially anyway
         %%%%prevHerdBW{previousHerds} = imread(['BWcombinedHerd' num2str(1)]);
         prevCellBW = imread(['BWsinglecell' num2str(firstFileNum) '.TIF']);
         
         prevCellBW = im2bw(prevCellBW);
         overlayToDisplay(prevCellBW)=255;
         
            
            else
                
                cd('../');
                
                break;
            
            end
             
            
        cd('../')
        end
        end
        end
        %%%MAKE FOLDER FOR SINGLE CELL BW
        
        cellNumberToUse = cells
        
        mkdir(['BWsingleHerd' num2str(constantHerdNumber) 'Cell' num2str(cellNumberToUse)]);
        mkdir(['overlaySingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
        %%%mkdir(['overlaySingleRescale' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
        mkdir(['analysis' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
        
        %%%%CHOOSE CELL BY IMPOINT
       figure1 = figure;
        
        imshow(overlayToDisplay);
        
        hold on;
        
             h = impoint(gca);
             
              %%%get position of point
      %%%IF FIRST FRAME, GET POSITION FROM IMPOINT
            pos = getPosition(h);
            % % % %%%get x and y coord of position 
                xpoint = pos(1);

                ypoint = pos(2);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    posVector(1, 1:2) = pos;
   
    %%%%%%%%%%%%%%%GET CLOSEST CENTROID
 if usePreviousImpolySeg ==0;   
    cd('BW');
    
 else
     
     cd(['BWfromPolyCell' num2str(cellNumberPoly)]);
     
 end

outputNameBW =(['BWcombined'  num2str(fFirst) '.' 'TIF' ]);

BW2 = imread(outputNameBW);
cd('../');
 L = bwlabel(BW2);
 
 %%%2) find centroids of objects
 
  s = regionprops(BW2, 'Centroid');
    
      distVector = [];
        
%%%REMEMBER s = regionprops(BW2, 'Centroid');
        
         %%%get x, y coord for centroids, will be contained in c
        for k = 1:numel(s)
            c = s(k).Centroid;
        %     text(c(1), c(2), sprintf('%d', k), ...
        %         'HorizontalAlignment', 'center', ...
        %         'VerticalAlignment', 'middle', 'Color', [0 1 0]);

        
        %%%FIND RMS DISTANCE BETWEEN CENTROID AND IMPOINT
            dist = sqrt((c(1)-xpoint)^2 + (c(2)-ypoint)^2);

            distVector = [distVector, dist];
        end
       % hold off

        
        %%%FIND MINIMUM RMS
        minRMS= min(distVector);

        %%%FIND THE CENTROID CORRESPONDING TO MIN RMS

        for i = 1: numel(distVector)

            if distVector(i) == minRMS;

                centroidMinRMS = i;
        %       k = [k, i];
                break;

            end
        end
        
      %%%%%%%%%%%%%%%KEY STEP%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    %%%define the right cell - the one closest to impoint
            BWsingleCell = L==centroidMinRMS;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
    
    
    %%%%CREATE BW FOR CELL
    
     cd(['BWsingleHerd' num2str(constantHerdNumber) 'Cell' num2str(cellNumberToUse)]);
     
     BWbase = BW2.*0;
     
     BWbase(BWsingleCell) = 1;
     
     outputNameSingleCellBW = (['BWsinglecell' num2str(1) '.TIF']);
     
     imwrite(BWbase,outputNameSingleCellBW, 'tif', 'Compression', 'none') ;
        
      cd('../');  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %%  Overlay on Enchanced Fluor Image


    imageNumber =fFirst;
    
        %%%%calculate hours and minutes for clock
    
exactTimeInHours = (imageNumber*minutesBetweenFrames)/60;

hours = floor(exactTimeInHours);

minutes = round((exactTimeInHours - hours)*60);

hours_str = num2str(hours);
    
 if minutes ==0 
         minutes_str = '00';
   else
        minutes_str = num2str(minutes);
        
 end
      backFluor = (['backFluor' '\' 'back'  num2str(imageNumber) '.' 'TIF']);  
     
               
   %1) LOAD normalized modified phase (1:255 range) 
        
        fileNameP = (['normPhase' '\' 'normPhase'  num2str(imageNumber) '.' 'TIF']);
        fileNameE = (['enhancedFluor' '\' 'enhanced'  num2str(imageNumber) '.' 'TIF']);
        %fileNameBW = (['cellHerdBW' '\' 'BWcombinedHerd' num2str(imageNumber) '.' 'TIF']);
        fileNameAPC = (['backAPC' '\' 'backAPC' num2str(imageNumber) '.' 'TIF']);
        
        phaseImage = imread(fileNameP);
        fluorImage = imread(fileNameE);
        imNormRback = imread(backFluor);
        bwImage = BWbase;
        if APCchannel ==1;
        apcImage = imread(fileNameAPC);
        end
    %2) convert regions of bacteria to red
       %%%BW OF ENHANCED FLUOR!
        bwfluor = im2bw(fluorImage);
        if APCchannel ==1;
        apcImage(find(apcImage>0) ) = 255;
        bwAPC = im2bw(apcImage);
        end
        red = phaseImage./1.4;
        green = phaseImage./1.4;
        blue = phaseImage./1.4;
        
        BWoutline = bwperim(bwImage);
        se90 = strel('line', 2, 90);
        se0 = strel('line', 2, 0);
        BWoutlineDilated = imdilate(BWoutline, [se90, se0]);
        
        red(bwfluor) = 255;
        green(BWoutlineDilated) = 255;
        if APCchannel ==1;
        blue(bwAPC) = 255;
        end
        bacteriaImage = cat(3,red,green,blue);
        
        
        
% % %     %3) show fluor image and overlay object boundary
% % %                    
% % %         boundaries = bwboundaries(bwImage); 
% % %         
% % %         
% % %       
% % %        
% % %        
% % % %        numberObjects = numel(boundaries);
% % %        
% % %        figure1 = figure(1);
% % %         imshow(bacteriaImage);
% % %         
% % %         hold on;
% % %        
% % % %        for k2=1:numberObjects;
% % % b = boundaries{1};
% % % plot(b(:,2),b(:,1),'g','LineWidth',1);
% % % 
% % % 
% % % %        end
% % %        
% % %        %%%add the clock%%%%%%taken off in this version
% % % 
% % % 
% % % % % % % % text(x_clock, y_clock, [hours_str, ':', minutes_str], 'fontsize', clock_font_size, 'color', clock_color);
% % % 
% % % 
% % % 
% % % %%%%%%%%%%%%%%%%%%%%%%%%%
% % %                       
% % %     hold off; 
        
                   
    %4) save the image    
                       
        
% % % % %         cd(['overlaySingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
        
        
         
% % % % %         outputNameOverlay =(['outlineSingle'  num2str(imageNumber)]);
% % % % % 
% % % % %         %%%%REDUCE SIZE OF THESE FILES BY USING JPEG COMPRESSION
% % % % %         
% % % % %         
% % % % %         dialog.outputPath = cd;
% % % % %         dialog.outputFilename = outputNameOverlay;
% % % % %         ext = '.jpg';
% % % % %         print(['-f',int2str(figure1)],'-djpeg',fullfile(dialog.outputPath,[dialog.outputFilename,ext]))
% % % % %         
% % % % %         %%%%Resize Image for Analysis
% % % % %         
% % % % %         
% % % % %      inputNameOverlay =(['outlineSingle'  num2str(imageNumber) '.jpg']);
% % % % %      overlayImage = imread(inputNameOverlay);
% % % % %      cd('../');
% % % % %         
% % % % %         
% % % % %         cropImage = overlayImage(36:834,201:1000,:);
% % % % %      
% % % % %      finalImage = imresize(cropImage,[1024 1024]);
% % % % %      
% % % % %     
     cd(['overlaySingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
     
     finalOverlayName = (['finalOverlaySingle' num2str(imageNumber) '.' 'jpg']);
     
     imwrite(bacteriaImage,finalOverlayName,'jpg','Quality',90);
     
     
    %%%free up memory
     delete('bacteriaImage');
     
     cd('../'); 
        
        close all;
        
        
        
   %%%%FIND McHERRY SIGNAL IN BW
   
    sumSigBack = sum(sum(imNormRback(BWsingleCell)));
 sumSigBackVect=  [sumSigBackVect, sumSigBack];
   
% % %    sumSigBackFlicker = sum(sum(imNormRbackFlick(BWsingleCell)));
% % %  sumSigBackVectFlicker =  [sumSigBackVectFlicker, sumSigBackFlicker];
    
  
 cd(['analysis' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
 
% % %  save('sumSigBackFlicker', 'sumSigBackVectFlicker');
 
 save('sumSigBack', 'sumSigBackVect');
    %%%%END PICK FIRST CENTROID    
        
     cd('../') ;  
    %%%%%%%%%%%SUBSEQUENT CENTROIDS:    
        
    for im = fFirst+1:fLast;    
        
    %%%IF CENTROID NEEDS TO BE MODIFIED            
        if sum(ismember(im, framesModifyCentroid))==1;    
        
        cd(dirNameFinalOverlay);
          
     finalOverlayName = (['finalOverlay' num2str(im) '.' 'TIF']);
     
     overlayToDisplay = imread(finalOverlayName);
     
     cd('../');
     
     figure1 = figure;
        
        imshow(overlayToDisplay);
        
        hold on;
        
             h = impoint(gca);
             
              %%%get position of point
      %%%IF FIRST FRAME, GET POSITION FROM IMPOINT
            pos = getPosition(h);
            % % % %%%get x and y coord of position 
                xpoint = pos(1);

                ypoint = pos(2);
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        %%%NOTE VECTOR STARTS AT 1, WHILE FIRST FRAME MAY BE GREATER.
        %%%THEREFORE MUST SUBTRACT FIRST FRAME. MIN IS 2 SINCE LOOP STARTS
        %%%AT FIRST +1, and 1 position already taken
    posVector(im-fFirst+1, 1:2) = pos;
   
    %%%%%%%%%%%%%%%GET CLOSEST CENTROID
    
    if usePreviousImpolySeg ==0;   
    cd('BW');
    
 else
     
     cd(['BWfromPolyCell' num2str(cellNumberPoly)]);
     
 end

outputNameBW =(['BWcombined'  num2str(im) '.' 'TIF' ]);

BW2 = imread(outputNameBW);

cd('../');

 L = bwlabel(BW2);
 
 %%%2) find centroids of objects
 
  s = regionprops(BW2, 'Centroid');
    
      distVector = [];
        
%%%REMEMBER s = regionprops(BW2, 'Centroid');
        
         %%%get x, y coord for centroids, will be contained in c
        for k = 1:numel(s)
            c = s(k).Centroid;
        %     text(c(1), c(2), sprintf('%d', k), ...
        %         'HorizontalAlignment', 'center', ...
        %         'VerticalAlignment', 'middle', 'Color', [0 1 0]);

        
        %%%FIND RMS DISTANCE BETWEEN CENTROID AND IMPOINT
            dist = sqrt((c(1)-xpoint)^2 + (c(2)-ypoint)^2);

            distVector = [distVector, dist];
        end
       % hold off

        
        %%%FIND MINIMUM RMS
        minRMS= min(distVector);

        %%%FIND THE CENTROID CORRESPONDING TO MIN RMS

        for i = 1: numel(distVector)

            if distVector(i) == minRMS;

                centroidMinRMS = i;
        %       k = [k, i];
                break;

            end
        end
        
      %%%%%%%%%%%%%%%KEY STEP%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    %%%define the right cell - the one closest to impoint
            BWsingleCell = L==centroidMinRMS;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
    
     %%%%CREATE BW FOR CELL
    
     cd(['BWsingleHerd' num2str(constantHerdNumber) 'Cell' num2str(cellNumberToUse)]);
     
     BWbase = BW2.*0;
     
     BWbase(BWsingleCell) = 1;
     
     outputNameSingleCellBW = (['BWsinglecell' num2str(im) '.TIF']);
     
     imwrite(BWbase,outputNameSingleCellBW, 'tif', 'Compression', 'none') ;
        
      cd('../');  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%END modified CENTROID    
        
    
     %%%IF NO MODIFICATION NECCESARY
        else
        
        %%%GET CENTROID FROM PREVIOUS POSITION
        
        pos = posVector(im-fFirst, 1:2);
        
        xpoint = pos(1);

                ypoint = pos(2);
       
   
    %%%%%%%%%%%%%%%GET CLOSEST CENTROID
    
    if usePreviousImpolySeg ==0;   
    cd('BW');
    
 else
     
     cd(['BWfromPolyCell' num2str(cellNumberPoly)]);
     
 end

outputNameBW =(['BWcombined'  num2str(im) '.' 'TIF' ]);

BW2 = imread(outputNameBW);

cd('../');

 L = bwlabel(BW2);
 
 %%%2) find centroids of objects
 
  s = regionprops(BW2, 'Centroid');
    
      distVector = [];
        
%%%REMEMBER s = regionprops(BW2, 'Centroid');
        
         %%%get x, y coord for centroids, will be contained in c
        for k = 1:numel(s)
            c = s(k).Centroid;
        %     text(c(1), c(2), sprintf('%d', k), ...
        %         'HorizontalAlignment', 'center', ...
        %         'VerticalAlignment', 'middle', 'Color', [0 1 0]);

        
        %%%FIND RMS DISTANCE BETWEEN CENTROID AND IMPOINT
            dist = sqrt((c(1)-xpoint)^2 + (c(2)-ypoint)^2);

            distVector = [distVector, dist];
        end
       % hold off

        
        %%%FIND MINIMUM RMS
        minRMS= min(distVector);

        %%%FIND THE CENTROID CORRESPONDING TO MIN RMS

        for i = 1: numel(distVector)

            if distVector(i) == minRMS;

                centroidMinRMS = i;
        %       k = [k, i];
                break;

            end
        end
        
      %%%%%%%%%%%%%%%KEY STEP%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    %%%define the right cell - the one closest to impoint
            BWsingleCell = L==centroidMinRMS;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
    
    
    pos = s(centroidMinRMS).Centroid;
     posVector(im-fFirst+1, 1:2) = pos;
    
    
    %%%%CREATE BW FOR CELL
    
     cd(['BWsingleHerd' num2str(constantHerdNumber) 'Cell' num2str(cellNumberToUse)]);
     
     BWbase = BW2.*0;
     
     BWbase(BWsingleCell) = 1;
     
     outputNameSingleCellBW = (['BWsinglecell' num2str(im) '.TIF']);
     
     imwrite(BWbase,outputNameSingleCellBW, 'tif', 'Compression', 'none') ;
        
      cd('../');  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
        end
        
    
    
   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Overlay on Enchanced Fluor Image


    imageNumber =im;
    
        %%%%calculate hours and minutes for clock
    
exactTimeInHours = (imageNumber*minutesBetweenFrames)/60;

hours = floor(exactTimeInHours);

minutes = round((exactTimeInHours - hours)*60);

hours_str = num2str(hours);
    
 if minutes ==0 
         minutes_str = '00';
   else
        minutes_str = num2str(minutes);
        
 end
        
     
         backFluor = (['backFluor' '\' 'back'  num2str(imageNumber) '.' 'TIF']);      
   %1) LOAD normalized modified phase (1:255 range) 
        
        fileNameP = (['normPhase' '\' 'normPhase'  num2str(imageNumber) '.' 'TIF']);
        fileNameE = (['enhancedFluor' '\' 'enhanced'  num2str(imageNumber) '.' 'TIF']);
        %fileNameBW = (['cellHerdBW' '\' 'BWcombinedHerd' num2str(imageNumber) '.' 'TIF']);
        fileNameAPC = (['backAPC' '\' 'backAPC' num2str(imageNumber) '.' 'TIF']);
        
        phaseImage = imread(fileNameP);
        fluorImage = imread(fileNameE);
        imNormRback = imread(backFluor);
        
        bwImage = BWbase;
        if APCchannel ==1;
        apcImage = imread(fileNameAPC);
        end
    %2) convert regions of bacteria to red
       %%%BW OF ENHANCED FLUOR!
        bwfluor = im2bw(fluorImage);
        if APCchannel ==1;
        apcImage(find(apcImage>0) ) = 255;
        bwAPC = im2bw(apcImage);
        end
        red = phaseImage./1.4;
        green = phaseImage./1.4;
        blue = phaseImage./1.4;
        
        BWoutline = bwperim(bwImage);
        se90 = strel('line', 2, 90);
        se0 = strel('line', 2, 0);
        BWoutlineDilated = imdilate(BWoutline, [se90, se0]);
        
        red(bwfluor) = 255;
        green(BWoutlineDilated) = 255;
        if APCchannel ==1;
        blue(bwAPC) = 255;
        end
        bacteriaImage = cat(3,red,green,blue);
        
        
        
% % %     %3) show fluor image and overlay object boundary
% % %                    
% % %         boundaries = bwboundaries(bwImage); 
% % %         
% % %         
% % %       
% % %        
% % %        
% % % %        numberObjects = numel(boundaries);
% % %        
% % %        figure1 = figure(1);
% % %         imshow(bacteriaImage);
% % %         
% % %         hold on;
% % %        
% % % %        for k2=1:numberObjects;
% % % b = boundaries{1};
% % % plot(b(:,2),b(:,1),'g','LineWidth',1);
% % % 
% % % 
% % % %        end
% % %        
% % %        %%%add the clock%%%%%%taken off in this version
% % % 
% % % 
% % % % % % % % text(x_clock, y_clock, [hours_str, ':', minutes_str], 'fontsize', clock_font_size, 'color', clock_color);
% % % 
% % % 
% % % 
% % % %%%%%%%%%%%%%%%%%%%%%%%%%
% % %                       
% % %     hold off; 
        
                   
    %4) save the image    
                       
        
% % % % %         cd(['overlaySingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
        
        
         
% % % % %         outputNameOverlay =(['outlineSingle'  num2str(imageNumber)]);
% % % % % 
% % % % %         %%%%REDUCE SIZE OF THESE FILES BY USING JPEG COMPRESSION
% % % % %         
% % % % %         
% % % % %         dialog.outputPath = cd;
% % % % %         dialog.outputFilename = outputNameOverlay;
% % % % %         ext = '.jpg';
% % % % %         print(['-f',int2str(figure1)],'-djpeg',fullfile(dialog.outputPath,[dialog.outputFilename,ext]))
% % % % %         
% % % % %         %%%%Resize Image for Analysis
% % % % %         
% % % % %         
% % % % %      inputNameOverlay =(['outlineSingle'  num2str(imageNumber) '.jpg']);
% % % % %      overlayImage = imread(inputNameOverlay);
% % % % %      cd('../');
% % % % %         
% % % % %         
% % % % %         cropImage = overlayImage(36:834,201:1000,:);
% % % % %      
% % % % %      finalImage = imresize(cropImage,[1024 1024]);
% % % % %      
% % % % %     
     cd(['overlaySingle' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
     
     finalOverlayName = (['finalOverlaySingle' num2str(imageNumber) '.' 'jpg']);
     
     imwrite(bacteriaImage,finalOverlayName,'jpg','Quality',90);
     
     delete('bacteriaImage');
     
     cd('../'); 
        
        close all;
        
         
        
   %%%%FIND McHERRY SIGNAL IN BW
   
    sumSigBack = sum(sum(imNormRback(BWsingleCell)));
 sumSigBackVect=  [sumSigBackVect, sumSigBack];
   
% % %    sumSigBackFlicker = sum(sum(imNormRbackFlick(BWsingleCell)));
% % %  sumSigBackVectFlicker =  [sumSigBackVectFlicker, sumSigBackFlicker];
    
  end
 cd(['analysis' 'Herd' num2str(herdFolderNumber) 'Cell' num2str(cellNumberToUse)]);
 
 save('sumSigBack', 'sumSigBackVect');
 
 
   save ('centroidPositions', 'posVector');
 
 
 firstLastDeathMethod = [deathFrameSimpleChooser, firstFrameCell, lastFrameCell, methodDeathDetermination, cellInfected, staysAfterDeath];
 
 save('firstLastDeathMethodData', 'firstLastDeathMethod');
   
 figure
        plot(fFirst:fLast, sumSigBackVect, 'k')
        print -r600 -dpdf sumSigBackVect
        
        cd('../') ;
        
end 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if modifyCellInfoOnly ==1;
    
    cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovMod)]); 
    
    cd(nameFOVfolder);
    cd(['analysis' 'Herd' num2str(herdFolderNumberMod) 'Cell' num2str(cellNumberToUseMod)]);
 
 
 firstLastDeathMethod = [deathFrameSimpleChooserMod, firstFrameCellMod, lastFrameCellMod, methodDeathDeterminationMod, cellInfectedMod, staysAfterDeathMod];
 
 save('firstLastDeathMethodData', 'firstLastDeathMethod');
 cd('../') ;  
 
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if quantifyPickup == 1;
    
     cd(directory);
    
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovChosenPickup)]); 
    
    cd(nameFOVfolder);
    
    cellPickupVector = ones(1,80).*0.001;
    
    for pickupNumber = 1:numel(frameForPickup);
        
        analysisFolderName = (['analysis' 'Herd' num2str(herdNumberPickup) 'Cell' num2str(cellNumberPickup)]);
        
        if overlaySingleHerdContainsOverlays ==1;
        overlayFolderName = (['overlaySingle' 'Herd' num2str(herdNumberPickup) 'Cell' num2str(cellNumberPickup)]);
        
        else
            
        overlayFolderName = (['overlaySingleRescale' 'Herd' num2str(herdNumberPickup) 'Cell' num2str(cellNumberPickup)]);
        
        end
       
        mCherrySignalFolder = 'backFluor';
        
        
        frame = frameForPickup(pickupNumber);
        
        


cd(overlayFolderName);

inputNameOverlay =(['finalOverlaySingle' num2str(frame) '.' 'jpg']);

     finalImage = imread(inputNameOverlay);
     
     
     figure, imshow(finalImage);

cd('../');
        
    cd(mCherrySignalFolder);
    
    mCherry = imread(['back' num2str(frame) '.' 'TIF']);
        
  cd('../');       
        
    %%%define ellipse to capture pickup signal
    
    
  h2= imellipse(gca);
  
    
          
          %waits for user to modify polygon
          position = wait(h2);
          
          %get new position
          pos = getPosition(h2);
      
      BWpickup = createMask(h2);
      
     totalBactFluor = sum(sum(mCherry(BWpickup)));
     
     %%%find area of pickup
     
     imageInEllipse = mCherry;
     
     imageInEllipse(~BWpickup)=0;
     
     fudgeFactorFluor =0.1;
     
     thresh_fluor=graythresh(imageInEllipse);
 
 %%%Use empirically determined fudgeFactorFluor to decrease threshold
  bw_pickup=im2bw(imageInEllipse,(thresh_fluor+0.001)*fudgeFactorFluor);
  
  
  
  L = bwlabel(bw_pickup);
  s = regionprops(bw_pickup, 'Area');
  
  
            areaPickup = s(1).Area;
            
            
     
     
     %%%DATA STRUCTURE 1-10: FLUOR OF PICKUPS. 11-20: EFFERO OR NOT.
     %%%21-30:FRAME OF PICKUP
     
     cellPickupVector(pickupNumber)= totalBactFluor;
     cellPickupVector(pickupNumber+10)= efferocytosis(pickupNumber);
     cellPickupVector(pickupNumber+20)= frame;
     cellPickupVector(pickupNumber+30)= areaPickup;
     cellPickupVector(pickupNumber+40)= pos(1);
      cellPickupVector(pickupNumber+50)= pos(2);
      cellPickupVector(pickupNumber+60)= pos(3);
      cellPickupVector(pickupNumber+70)= pos(4);
    
     %%%save modified vector
     
    cd(analysisFolderName);
    
    fileName = (['bw_pickup' num2str(pickupNumber) '.TIF']);
    
    imwrite(bw_pickup,fileName, 'tif', 'Compression', 'none') ;

 save('pickups', 'cellPickupVector');

cd('../');    
        
    end    
        
end   
       
  
        
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        if dataCombiner == 1;
    
    tic
   
    cd(directory);

    for fovNumber = rangeToUse;
    nameFOVfolder = ([num2str(movieDate) 'FOV' num2str(fovNumber)]); 
    
    if exist(nameFOVfolder) ~=0;
    
    cd(nameFOVfolder);
    
    mkdir(['FOVanalysisCombinedFOV' num2str(fovNumber)]);
    
    for herdNumber = herdRange;
    for cellNumber = cellRange;
        
 
 %%%check for analysis folder as some cells have a BW single cell but no
 %%%analysis folder and script errors out. Never other way
 
  cd(directory);
 cd(nameFOVfolder);
 
 fileNameAnalysis = ([(directory) '/' (nameFOVfolder) '/' 'analysis' 'Herd' num2str(herdNumber) 'Cell' num2str(cellNumber)]);
 
        
       if exist(fileNameAnalysis)~=0;
            
            cd(fileNameAnalysis)
            
            load('sumSigBack.mat');
            
            if applybFilt ==1;
            
            sumSigBackVectBfilt = bfilt(sumSigBackVect);
            
            else
                
                sumSigBackVectBfilt = sumSigBackVect;
                
            end
            
            nameOfPickupFile = ([(directory) '/' (nameFOVfolder) '/' 'analysis' 'Herd' num2str(herdNumber) 'Cell' num2str(cellNumber) '/' 'pickups.mat' ]);
            
            if exist(nameOfPickupFile)~=0; %%%%%%
                
                
 
             load(nameOfPickupFile);
             
             pickupsPresent =1;
             
            else
                
                pickupsPresent =0;
             
            end
             
             nameOfFirstLastDeath = ([(directory) '/' (nameFOVfolder) '/' 'analysis' 'Herd' num2str(herdNumber) 'Cell' num2str(cellNumber) '/' 'firstLastDeathMethodData.mat' ]);
            
             if exist(nameOfFirstLastDeath)~=0;
             
             load(nameOfFirstLastDeath);
             
             firstLastDeathPresent =1;
             
             end
             
             cd('../');
             %%%%%CREATE COMBINED VECTOR
             constVector = ones(1, 2000)*0.001;
             
             constVector(1:numel(sumSigBackVectBfilt))= sumSigBackVectBfilt;
             
             
     
            
     if  firstLastDeathPresent ==1;
        
        %%%key: firstLastDeathMethod = [deathFrameSimpleChooser, firstFrameCell, lastFrameCell, methodDeathDetermination, cellInfected, staysAfterDeath];

        
     constVector(2000) = firstLastDeathMethod(1); %%%death frame
        
        constVector(1999) = firstLastDeathMethod(2);%%%first frame
     
     constVector(1998) = firstLastDeathMethod(3); %%%last frame
     
     constVector(1997) = firstLastDeathMethod(4); %%%method of death 0 = doesn't die
     
     constVector(1996) = firstLastDeathMethod(5); %%%infected
     
     constVector(1995) = firstLastDeathMethod(6); %%%stays around
     
    end
    
     if pickupsPresent ==1;         
             
       constVector(1951:1980) = cellPickupVector(1:30);
       
       constVector(1901:1950) = cellPickupVector(31:80);
       
     else
       
         constVector(1951:1980) = ones(1,30).*0.001;
         
     end
     
     %%%add cell identity
     constVector(1994) = cellNumber;
     constVector(1993) = herdNumber;
     constVector(1992) = fovNumber;
     constVector(1991) = movieDate; 
     
     %%%number frames in movie
     
     constVector(1990) = fLast; 
     
     cd(directory);
 cd(nameFOVfolder);
     cd(['FOVanalysisCombinedFOV' num2str(fovNumber)]);
      
     nameOutpuMatFile = (['herd' num2str(herdNumber) 'Cell' num2str(cellNumber) 'Data']);
     
     save(nameOutpuMatFile, 'constVector');
 %%%plot data
 
 figure1 = figure;

      axes1 = axes('Parent',figure1,'XMinorTick','on',...
    'FontSize',20, 'XTick',[0 20 40 60 80 100]);%%,....)%%,...
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000])
   
   %xlim([vectorCminInnM(drugNumber)*0.04, vectorCmaxInnM(drugNumber)*(1/0.04) ]);
  
 ylim([0, (max(sumSigBackVectBfilt)+0.1)*1.1]);
 
 
 %axis('square')
 
 hold('all');
 

 

plot((constVector(1999):constVector(1998))/6, sumSigBackVectBfilt((1:length(constVector(1999):constVector(1998)))), 'k', 'LineWidth', 2);

%%%plot((fFirst:numel(sumSigBackVectBfilt))/6, sumSigBackVectBfilt(1:numel(sumSigBackVectBfilt)), 'k', 'LineWidth', 2);
hold on


%%%plots death frame as vertical line if a death frame exists before end of
%%%move. two places in file indicate death: if death frame of cell comes
%%%before end of movie, and if cell scored as dead

if  constVector(2000)< constVector(1990)&& constVector(1997) ~=0;
    %plot(ones(1, 10^5).*(death/6), 0:1:(10^5-1), 'Color',[0 1 0], 'LineWidth', 4, 'LineStyle', '-.');
plot(ones(1, 10^5).*(constVector(2000)/6), 1:1:10^5, 'Color',[0 1 0], 'LineWidth', 4, 'LineStyle', '-.');

end



hold on;


%%%graph pickups


for pickupDetector = 1:10;
    
    if constVector(1950+pickupDetector) ~=0.001;
        
        frameOfPickup = constVector(1970+pickupDetector);
        
        if constVector(1960+pickupDetector) ==0;
        plot(ones(1, 10^5).*(frameOfPickup/6), 1:1:10^5, 'Color',[1 0 0], 'LineWidth', 4, 'LineStyle', '-.');
        
        else
            
            plot(ones(1, 10^5).*(frameOfPickup/6), 1:1:10^5, 'Color',[0 0 0], 'LineWidth', 4, 'LineStyle', '-.');
        end
      hold on;  
        
    
    end
  
end

%%%%name for cell in figure


nameOfCell = (['herd' num2str(herdNumber) 'Cell' num2str(cellNumber) '.' 'TIF']);

print(figure1, '-dtiff','-r600', nameOfCell);


hold off
  cd('../');   
     

        end
        
    end
    
    end
    cd('../');
    end
    
    
    close all;
    end
        end
    