close all 

clear all

%Purpose is to obtain p values for differences between death frequencies 
%of cells with different Mtb numbers, where frequency is of cells binned into groups of 72,
%except for bystanders wheich are cells 1:39. 
%Matrix used is masterDataMatrixModSorted, where cells are sorted by sum
%Mtb picked up. 

binSize = 72; 
bystanders = 1:39;
maxFrame = 500;
numIterations= 100000;

cd('C:\Alex\SAforBackup\deeqaPaper\submissions\elifeRevision')

load('dataForBootstrap')%%%generated by fig1sub4v5


for count = 1:10;%% 10 comparisons as each bin is compared to all bins below and bystanders
    
  inverseCount = 11-count; %%%start with higest bin
 rangeCells = ((inverseCount-1)*binSize)+1:inverseCount*binSize;
 
 %%%these will be used for bootstrap
 deathFramesForBin = infectedDeathFrames(rangeCells);
 
 %%%%%bootstrap
      
      %%%create the death frames vector for the bin to be bootstrapped
      
      %%%%for infected: size of vector = binsize
      
      freqDeathBootstrapVector = [];
      for iteration =1:numIterations
          
          indexVector = ceil(rand(1, binSize)*binSize);
          
          resampledVect = deathFramesForBin(indexVector);
          
          freqDeathBootstrap = numel(find(resampledVect<maxFrame))/binSize;
         
         freqDeathBootstrapVector = [freqDeathBootstrapVector; freqDeathBootstrap];
  
      end
      
      %%%%for bystander: size of vector = 39
      
      freqDeathBootstrapVectorBy = [];
      for iteration =1:numIterations
          
          indexVector = ceil(rand(1, max(bystanders))*binSize);%%%note that choose 39 out of 72 values, not 39, hence *binSize
          
          resampledVect = deathFramesForBin(indexVector);
          
          freqDeathBootstrap = numel(find(resampledVect<maxFrame))/max(bystanders);
         
         freqDeathBootstrapVectorBy = [freqDeathBootstrapVectorBy; freqDeathBootstrap];
  
      end
      
     %%%p-values
     
     for condition =1:11
         
         if condition ==1
             
             pValue = numel(find(freqDeathBootstrapVectorBy<freqDeathLastFrame(condition,2)))/numIterations;
             
         else
     
            pValue = numel(find(freqDeathBootstrapVector<freqDeathLastFrame(condition,2)))/numIterations;
             
         end

pValueMatrix(count, condition) = pValue;

     end
     
end


cd('C:\Alex\SAforBackup\deeqaPaper\submissions\elifeRevision')
 save('bootstrapResult', 'pValueMatrix');
 
% %%% Compare highest Mtb to all bins below
% 
% for count = 1:10;%% 10 comparisons as each bin is compared to all bins below and bystanders
%     
%     inverseCount = 11-count ; % start from highest
%     
% 
%  rangeCellsBin = (40+(inverseCount-1)*binSize):40+inverseCount*binSize; %window of binSize cells to average and find freq death
% 
%  %%%death freq
%  
%  deathFreq = numel(find(infectedMatrix(rangeCellsBin, 2000)<maxFrame))/numel(binSize); 
%  
%   meanMtbBin = mean(infectedMatrix(rangeCellsBin, 2001));
%   
%   %%%test against other bins and bystanders
%   
%   for count = 1: inverseCount 
%       
%       binNumber = count-1
%       
%       if binNumber ==0
%           
%            rangeCellsBinBootstrap = 1:39; %%%window of bootstrap for bystanders
%            
%            numberPick = 39;
%            
% 
%           
%       else
%     rangeCellsBinBootstrap = (40+(binNumber-1)*binSize):40+binNumber*binSize; %%%window of bootstrap for bins 
%                          
%            numberPick = binSize;
%            
%       end
%       %%%%%bootstrap
%       
%       %%%create the death frames vector for the bin to be bootstrapped
%       
%       freqDeathBootstrapVector = [];
%       for iteration =1:1000
%           
%           indexVector = ceil(rand(1, numberPick)*numberPick);
%           
%           
%           cellsChosen = matrixBootstrapBin(indexVector, 2000);
%           
%          freqDeathBootstrap = numel((find(cellsChosen<maxFrame)))/numel(numberPick);
%          
%          freqDeathBootstrapVector = [freqDeathBootstrapVector; freqDeathBootstrap];
%          
%       end
%           
%           

