function h = De3DFollicleLength(h, Time, dt, hmax, hmin)

 
%Follicle length coefficients 
HGrow = 0.2;
HDie = 2;





if Time > 0
    %phase+
    t = abs(Time)/20;
    h = max(h - dt*HGrow*t^4, hmax);
else
    %phase-
    t = abs(Time)/15;
    h = min(h + dt*HDie*t^2,hmin);
end