function StructStack = Prep_Dynamics3DFollicle_BackOnly



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%     PARAMETERS     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%Production coefficients 
%alphaW1 = 50;
%alphaW0 = 3 ;
%alphaB0 = -5;
%alphaB1 = 15;

%Production coefficients 
alphaW1 = 40;
alphaW0 = 3 ;
alphaB0 = -8;
alphaB1 = 20;



%Temporal discretizaion
dt = 0.02;

%Geomotry coefficients  
   %spacial discretization
   dx = 2;
   dy = 2;
   dz = 0.2;
    
   %computation domain [0, X]*[0, Y]*[-Z, 0]
   X = 60;
   Y = 100;
   Z = 10;
   
   NX = X/dx;
   NY = Y/dy;
   NZ = Z/dz;
   
   
   %region I: bulge [  h_I*dz,  h_I*dh + d_I*dz] 
   hI = - 5 ;
   dI = 3 ;
   %region II: sHG/Matrix + DP  [h(t), h(t) + d_II*dh]
   dII = 4;
   %max/min length of the follicle
   hmin = (hI - dII)*dz;
   hmax = - 30*dz;

%explicit finite difference, D*dt/(dx^2 + dy^2) < 1/2
   
%Error allowence in computation
err = 0.005;


 
%Threshold of concentration differnece
DeltaT = 1;


%Diffusion coefficient  
DAct = 0.5;
DInh = 0.5;



%Reaction coefficients 
kActOn = 0.3;
kInhOn = 0.5;
kActOff = 0;
kInhOff = 0;

 
%Degradation coefficients
kActDeg = 2;
kInhDeg = 7;%6;%4;
 

%Preservation of receptors
RActTot = 20;
RInhTot = 20;





%betaW = 2;
betaAct = 4; 
%betaB = 0.2;
betaInh = 2.3 ;  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%  PREPARATION  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%  TIME  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 



HFTime = ones(NX+1,NY+1);
%FollicleTime(i) : +/-t for the (i,j)-th follicle
%t is the time in the current phase: t - t^+ or t - t^-
%+/- gives the current time phase
 


%%%%%%%%%%%%%%%%%%%%%%%% CONCENTRATION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for nstack = 1:1:NZ+1
    
    StructStack(nstack).ActL = zeros(NX+1,NY+1);
    StructStack(nstack).InhL = zeros(NX+1,NY+1);
    StructStack(nstack).ActLR = zeros(NX+1,NY+1);
    StructStack(nstack).InhLR = zeros(NX+1,NY+1);
    
end





%%%%%%%%%%%%%%%%%%%%%%% FOLLICLE LENGTH %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 

h = hmin*ones(NX+1,NY+1);



%%%%%%%%%%%%%%%%%%%%% Boundary Condition %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

 
%left&right boundary condition
%BdCond = 1, no leak
%BdCond = 0, periodic
 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




NStep = 4000 ; 
 

 
%production
ActProd = zeros(NX+1,NY+1);
InhProd = zeros(NX+1,NY+1);
Conc3DDiff = zeros(NX+1,NY+1);
 
Struct3DHF(1).StructStack = StructStack;
Struct3DHF(1).h = h;
Struct3DHF(1).HFTime = HFTime;
Struct3DHF(1).Time = 0;



CountStep = 1;



for nstep = 1:1:NStep
    
    if nstep == 10
        DeltaT = 5;
    end
    
     
    
    %Inh production rate
    InhProd = alphaB0 + alphaB1*( -h  + hmin + dI*dz);
        
        
    for nxHF = 1:1:NX+1
        for nyHF = 1:1:NY+1
            
            %Act production rate
            if HFTime(nxHF,nyHF) > 0
                %phase+
                ActProd(nxHF,nyHF) = alphaW1*( - hmax + h(nxHF,nyHF) )/(- hmax + hmin)  ;
            else
                ActProd(nxHF,nyHF) = alphaW0;
            end
            
            
            %HF length
            h(nxHF,nyHF) = De3DFollicleLength(h(nxHF,nyHF), HFTime(nxHF,nyHF), dt, hmax, hmin);
       
            
            %HF phase 
            if h(nxHF,nyHF) <= hmin - dz && Conc3DDiff(nxHF,nyHF) < - err && HFTime(nxHF,nyHF) > 0
                %time phase turns from + to -
                HFTime(nxHF,nyHF) = -1;

            end
    
            if h(nxHF,nyHF) >= hmin - err && Conc3DDiff(nxHF,nyHF) >= DeltaT && HFTime(nxHF,nyHF) <0
                %starts a new cycle, i.e., time phase turns from - to +
                HFTime(nxHF,nyHF) = 1;
    
            end
            
            

            
            
        end
    end
            
           
        
        

    HFTime = HFTime + sign(HFTime); 
    

            
            
    
    
 for nstack = 1:1:NZ+1
        
        %diffusion in the z direction
        if nstack == 1
            %top, d (ActL/InhL) / dz = 0
            DeActL = DAct*(2*StructStack(2).ActL - 2*StructStack(1).ActL)/dz^2;
            DeInhL = DInh*(2*StructStack(2).InhL - 2*StructStack(1).InhL)/dz^2;
        elseif nstack == NZ+1
            %bottom, ActL/InhL = 0
            DeActL = DAct*(StructStack(NZ).ActL - 2*StructStack(NZ+1).ActL)/dz^2;
            DeInhL = DInh*(StructStack(NZ).InhL - 2*StructStack(NZ+1).InhL)/dz^2;
        else       
            DeActL = DAct*(StructStack(nstack-1).ActL - 2*StructStack(nstack).ActL + StructStack(nstack+1).ActL)/dz^2;
            DeInhL = DInh*(StructStack(nstack-1).InhL - 2*StructStack(nstack).InhL + StructStack(nstack+1).InhL)/dz^2;
        end
        
        
        
        ActL = StructStack(nstack).ActL;
        InhL = StructStack(nstack).InhL;
        
        DeActL(2:NX,2:NY) = DeActL(2:NX,2:NY) + DAct*(( ActL(1:NX-1,2:NY) - 2*ActL(2:NX,2:NY) + ActL(3:NX+1,2:NY) )/dx^2 + ( ActL(2:NX,1:NY-1) - 2*ActL(2:NX,2:NY) + ActL(2:NX,3:NY+1) )/dy^2);
        DeInhL(2:NX,2:NY) = DeInhL(2:NX,2:NY) + DInh*(( InhL(1:NX-1,2:NY) - 2*InhL(2:NX,2:NY) + InhL(3:NX+1,2:NY) )/dx^2 + ( InhL(2:NX,1:NY-1) - 2*InhL(2:NX,2:NY) + InhL(2:NX,3:NY+1) )/dy^2);
        
        %no leak on head & tail, periodic on left & right
        
        DeActL(1,1) = DeActL(1,1) + DAct*((ActL(2,1) - 2*ActL(1,1) + ActL(NX+1,1))/dx^2 + (2*ActL(1,2) - 2*ActL(1,1))/dy^2);
        DeInhL(1,1) = DeInhL(1,1) + DInh*((InhL(2,1) - 2*InhL(1,1) + InhL(NX+1,1))/dx^2 + (2*InhL(1,2) - 2*InhL(1,1))/dy^2);
        
        DeActL(NX+1,1) = DeActL(NX+1,1) + DAct*((ActL(NX,1) - 2*ActL(NX+1,1) + ActL(1,1))/dx^2 + (2*ActL(NX+1,2) - 2*ActL(NX+1,1))/dy^2);
        DeInhL(NX+1,1) = DeInhL(NX+1,1) + DInh*((InhL(NX,1) - 2*InhL(NX+1,1) + InhL(1,1))/dx^2 + (2*InhL(NX+1,2) - 2*InhL(NX+1,1))/dy^2);
        
        DeActL(1,NY+1) = DeActL(1,NY+1) + DAct*((2*ActL(1,NY) - 2*ActL(1,NY+1))/dy^2 + (ActL(2,NY+1) - 2*ActL(1,NY+1) + ActL(NX+1,NY+1))/dx^2);
        DeInhL(1,NY+1) = DeInhL(1,NY+1) + DInh*((2*InhL(1,NY) - 2*InhL(1,NY+1))/dy^2 + (InhL(2,NY+1) - 2*InhL(1,NY+1) + InhL(NX+1,NY+1))/dx^2);
        
        DeActL(NX+1,NY+1) = DeActL(NX+1,NY+1) + DAct*((ActL(NX,NY+1) - 2*ActL(NX+1,NY+1) + ActL(1,NY+1))/dx^2 + (2*ActL(NX+1,NY) - 2*ActL(NX+1,NY+1))/dy^2);
        DeInhL(NX+1,NY+1) = DeInhL(NX+1,NY+1) + DInh*((InhL(NX,NY+1) - 2*InhL(NX+1,NY+1) + InhL(1,NY+1))/dx^2 + (2*InhL(NX+1,NY) - 2*InhL(NX+1,NY+1))/dy^2);
        
        
        
        
        
         
        DeActL(1,2:NY) = DeActL(1,2:NY) + DAct*((ActL(2,2:NY) - 2*ActL(1,2:NY) + ActL(NX+1,2:NY))/dx^2 + ( ActL(1,1:NY-1) - 2*ActL(1,2:NY) + ActL(1,3:NY+1) )/dy^2  );
        DeInhL(1,2:NY) = DeInhL(1,2:NY) + DInh*((InhL(2,2:NY) - 2*InhL(1,2:NY) + InhL(NX+1,2:NY))/dx^2 + ( InhL(1,1:NY-1) - 2*InhL(1,2:NY) + InhL(1,3:NY+1) )/dy^2  );
        
        DeActL(NX+1,2:NY) = DeActL(NX+1,2:NY) + DAct*((ActL(NX,2:NY) - 2*ActL(NX+1,2:NY) + ActL(1,2:NY))/dx^2 + ( ActL(NX+1,1:NY-1) - 2*ActL(NX+1,2:NY) + ActL(NX+1,3:NY+1) )/dy^2  );
        DeInhL(NX+1,2:NY) = DeInhL(NX+1,2:NY) + DInh*((InhL(NX,2:NY) - 2*InhL(NX+1,2:NY) + InhL(1,2:NY))/dx^2 + ( InhL(NX+1,1:NY-1) - 2*InhL(NX+1,2:NY) + InhL(NX+1,3:NY+1) )/dy^2  );
        
        DeActL(2:NX,1) = DeActL(2:NX,1) + DAct*((2*ActL(2:NX,2) - 2*ActL(2:NX,1))/dy^2 + ( ActL(1:NX-1,1) - 2*ActL(2:NX,1) + ActL(3:NX+1,1) )/dx^2  );
        DeInhL(2:NX,1) = DeInhL(2:NX,1) + DInh*((2*InhL(2:NX,2) - 2*InhL(2:NX,1))/dy^2 + ( InhL(1:NX-1,1) - 2*InhL(2:NX,1) + InhL(3:NX+1,1) )/dx^2  );
        
        DeActL(2:NX,NY+1) = DeActL(2:NX,NY+1) + DAct*((2*ActL(2:NX,NY) - 2*ActL(2:NX,NY+1))/dy^2 + ( ActL(1:NX-1,NY+1) - 2*ActL(2:NX,NY+1) + ActL(3:NX+1,NY+1) )/dx^2  );
        DeInhL(2:NX,NY+1) = DeInhL(2:NX,NY+1) + DInh*((2*InhL(2:NX,NY) - 2*InhL(2:NX,NY+1))/dy^2 + ( InhL(1:NX-1,NY+1) - 2*InhL(2:NX,NY+1) + InhL(3:NX+1,NY+1) )/dx^2  );
        
        StructStack(nstack).DeActL = DeActL;
        StructStack(nstack).DeInhL = DeInhL;
 
        
        
    end
    
    for nstack = 1:1:NZ+1
        
        StructStack(nstack).ActL = StructStack(nstack).ActL + dt*(StructStack(nstack).DeActL);
        StructStack(nstack).InhL = StructStack(nstack).InhL + dt*(StructStack(nstack).DeInhL);
 
 
        
        %reaction, region I
        if nstack >= - hI - dI + 1 && nstack <= -hI
            
            ActL = StructStack(nstack).ActL;
            ActLR = StructStack(nstack).ActLR;
            InhL = StructStack(nstack).InhL;
            InhLR = StructStack(nstack).InhLR;
                
            StructStack(nstack).ActL = ActL + (- kActOn*ActL.*(RActTot - ActLR) + kActOff*ActLR)*dt;
            StructStack(nstack).InhL = InhL + (- kInhOn*InhL.*(RInhTot - InhLR) + kInhOff*InhLR)*dt;
            StructStack(nstack).ActLR = ActLR + (kActOn*ActL.*(RActTot - ActLR) - (kActOff + kActDeg)*ActLR + betaAct)*dt;%  + lambda*sqrt( dt)*randn*WNTLR(index) ;
            StructStack(nstack).InhLR = InhLR + (kInhOn*InhL.*(RInhTot - InhLR) - (kInhOff + kInhDeg)*InhLR + betaInh)*dt;%  + lambda*sqrt( dt)*randn*WNTLR(index) ;
            
            StructStack(nstack).ActLR = max(StructStack(nstack).ActLR,0 );
            StructStack(nstack).InhLR = max(StructStack(nstack).InhLR,0 );

        
        end
         
        
        %production, region II
        if nstack >= -hI
        for nxHF = 1:1:NX+1
            for nyHF = 1:1:NY+1
                if nstack >= floor(- h(nxHF,nyHF)/dz) - dII + 1 && nstack <= ceil(- h(nxHF,nyHF)/dz)
                    
                    ActL =  StructStack(nstack).ActL;
                    ActL(nxHF,nyHF) = ActL(nxHF,nyHF) + ActProd(nxHF,nyHF)*dt;
                    StructStack(nstack).ActL = ActL;
                    
                    InhL =  StructStack(nstack).InhL;
                    InhL(nxHF,nyHF) = InhL(nxHF,nyHF) + InhProd(nxHF,nyHF)*dt;
                    StructStack(nstack).InhL = InhL;
                end
            end
            

        end
        end
        
        
        StructStack(nstack).ActL = max(StructStack(nstack).ActL ,0);
        StructStack(nstack).InhL = max(StructStack(nstack).InhL ,0);

       % InhL = StructStack(nstack).InhL;
       % TestInhL(nstack) = InhL(10,1);
        
       % ActL = StructStack(nstack).ActL;
       % TestActL(nstack) = ActL(10,1);
        
        
    end

       
    
   
    %concentration difference
    AveActLR = zeros(NX+1,NY+1);
    AveInhLR = zeros(NX+1,NY+1);
    for nstack = - hI + 1 - dI:1:- hI
        
        AveActLR = AveActLR + StructStack(nstack).ActLR;
        AveInhLR = AveInhLR + StructStack(nstack).InhLR;
                
    end
    AveActLR = AveActLR/dI;
    AveInhLR = AveInhLR/dI;
    Conc3DDiff = AveActLR - AveInhLR;
    
    
    
    
    
    

    

    
    
    if mod(nstep,100) == 0
        
        
        CountStep = CountStep + 1;
        
        StructPrep3DHF(CountStep).StructStack = StructStack;
        StructPrep3DHF(CountStep).h = h;
        StructPrep3DHF(CountStep).HFTime = HFTime;
        StructPrep3DHF(CountStep).Time = nstep*dt;
 
    
    %hmin, HFColorStr = 0; hmax, HFColorStr = 1;
    HFColorStr = (hmin - h)/(hmin - hmax);
        
    figure(1)
    clf
    set(gca,'FontSize',15,'FontWeight','bold');
    hold on
    
    for nxHF = 1:1:NX+1
        for nyHF = 1:1:NY+1
            
            if HFColorStr(nxHF,nyHF) == 0
            else
                HFColor = [1-HFColorStr(nxHF,nyHF), 1-HFColorStr(nxHF,nyHF),1];
                plot((nxHF-1)*dx, (nyHF-1)*dy, '.', 'Color',HFColor,'MarkerSize',20)
                
            end
            
            
        end
    end
    
    axis([0,X,0,Y])
    axis equal
 
    StrTitle = sprintf('Time = %g', nstep*dt);
    title(StrTitle)

    hold off
    
    
  %  figure(2)
  %  clf
  %  PlotX = 0:1:NX ;
  %  plot(PlotX,AveActLR(:,40),'g-','LineWidth',2)
  %  hold on
  %  plot(PlotX,AveInhLR(:,40),'r-','LineWidth',2)
  %  plot(PlotX,-h(:,40),'-','LineWidth',2)
  %  hold off
  %  axis([1,NX+1,0,15])
    

   
 
    end
    
    
    
    
end

 
StructStack = Struct3DHF(end).StructStack;













