function FHN_TimeScale


load('MouseWTParameters');

%alpha_1=0.014;
%alpha_2 = 0.02;
%I=0.015;
%J=0.015;
I=0.015;
J=0.013;


n_vec = 1;

for alpha_1 = 0.011:0.0002:0.015
    
    %T_UP:PA, T_DOWN: R, T_exc: C
    
    [T_UP T_DOWN T_exc T_exc_with_D] = GetPARCTimeVariation(alpha_1); 
    
    
    [v_ss w_ss v_min v_max w_min w_max v_plot_1...
    v_plot_2 v_plot_3 v_plot_4 w_1 w_2 w_3 w_4 v_thr] = GetSteadyStateAndNullclines;
    
    if v_ss >= v_0
        T_exc = 0;
    end
    
    alpha_1_vec(n_vec) = alpha_1;
    T_PA(n_vec) = T_UP;
    T_R(n_vec) = T_DOWN;
    T_C(n_vec) = T_exc; 
    
    n_vec = n_vec + 1;
    
    
    if alpha_1 == 0.011
        
        Tel_Ana_Ratio_max = (T_DOWN+T_exc)/T_UP;
        Tel_Ana_Ratio_min = (T_DOWN+T_exc)/T_UP;
    else
        Tel_Ana_Ratio_max = max(Tel_Ana_Ratio_max,(T_DOWN+T_exc)/T_UP);
        Tel_Ana_Ratio_min = min(Tel_Ana_Ratio_min,(T_DOWN+T_exc)/T_UP);
        
    end
    
    
end
%Tel_Ana_Ratio_max
%Tel_Ana_Ratio_min

n_vec = n_vec - 1;




 

figure(1)
clf
plot(alpha_1_vec,T_PA,'LineWidth',2)
hold on
plot(alpha_1_vec,T_R,'--', 'LineWidth',2)
plot(alpha_1_vec,T_C,'-.', 'LineWidth',2)
ylim([0,100])
set(gca,'FontSize',15,'FontWeight','bold');
legend('T_{PA}','T_{R}','T_{C}')
h=xlabel('$\alpha_1$');
set(h,'Interpreter','Latex')
ylabel('Time')
h=title([ 'I = ' num2str(I) ', J = ' num2str(J) ]);
set(h,'Interpreter','Latex')


clear T_PA T_R T_C


n_vec = 1;

load('MouseWTParameters');
alpha_1=0.0145;
%alpha_2 = 0.02;
%I=0.015;
%J=0.017;


for I = 0.012:0.0005:0.02
    
    %T_UP:PA, T_DOWN: R, T_exc: C
    
    [T_UP T_DOWN T_exc T_exc_with_D] = GetPARCTimeVariation(alpha_1); 
    
    [v_ss w_ss v_min v_max w_min w_max v_plot_1...
    v_plot_2 v_plot_3 v_plot_4 w_1 w_2 w_3 w_4 v_thr] = GetSteadyStateAndNullclines;
    
    if v_ss >= v_0
        T_exc = 0;
    end
    
    I_vec(n_vec) = I;
    T_PA(n_vec) = T_UP;
    T_R(n_vec) = T_DOWN;
    T_C(n_vec) = T_exc;
    
    
    Tel_Ana_Ratio_max = max(Tel_Ana_Ratio_max,(T_DOWN+T_exc)/T_UP);
    Tel_Ana_Ratio_min = min(Tel_Ana_Ratio_min,(T_DOWN+T_exc)/T_UP);
    
    n_vec = n_vec + 1;
    
    
end

n_vec = n_vec - 1;
 

%Tel_Ana_Ratio_max
%Tel_Ana_Ratio_min


figure(2)
clf
plot(I_vec,T_PA,'LineWidth',2)
hold on
plot(I_vec,T_R,'--', 'LineWidth',2)
plot(I_vec,T_C,'-.', 'LineWidth',2)
ylim([0,100])
set(gca,'FontSize',15,'FontWeight','bold');
legend('T_{PA}','T_{R}','T_{C}','Location','Best')
h=xlabel('I');
ylabel('Time')
h=title([ '$\alpha_1$ = ' num2str(alpha_1) ', J = ' num2str(J)]);
set(h,'Interpreter','Latex')
%StrTitle = sprintf('alpha_1 = %g',alpha_1);
%title(StrTitle)


clear T_PA T_R T_C


n_vec = 1;

load('MouseWTParameters');
alpha_1=0.0145;
%alpha_2 = 0.02;
%I=0.015;
%J=0.017;


for J = 0.012:0.0005:0.02
    
    %T_UP:PA, T_DOWN: R, T_exc: C
    
    [T_UP T_DOWN T_exc T_exc_with_D] = GetPARCTimeVariation(alpha_1);
    
    [v_ss w_ss v_min v_max w_min w_max v_plot_1...
    v_plot_2 v_plot_3 v_plot_4 w_1 w_2 w_3 w_4 v_thr] = GetSteadyStateAndNullclines;
    
    if v_ss >= v_0
        T_exc = 0;
    end
    
    J_vec(n_vec) = J;
    T_PA(n_vec) = T_UP;
    T_R(n_vec) = T_DOWN;
    T_C(n_vec) = T_exc;
    
    
    Tel_Ana_Ratio_max = max(Tel_Ana_Ratio_max,(T_DOWN+T_exc)/T_UP);
    Tel_Ana_Ratio_min = min(Tel_Ana_Ratio_min,(T_DOWN+T_exc)/T_UP);
    
    n_vec = n_vec + 1;
    
    
end

n_vec = n_vec - 1;
 

%Tel_Ana_Ratio_max
%Tel_Ana_Ratio_min
  

figure(3)
clf
plot(J_vec,T_PA,'LineWidth',2)
hold on
plot(J_vec,T_R,'--', 'LineWidth',2)
plot(J_vec,T_C,'-.', 'LineWidth',2)
xlim([0.012,0.02])
ylim([0,100])
set(gca,'FontSize',15,'FontWeight','bold');
legend('T_{PA}','T_{R}','T_{C}','Location','Best')
h=xlabel('J');
ylabel('Time')
%StrTitle = sprintf('alpha_1 = %g',alpha_1);
%title(StrTitle)
h=title([ '$\alpha_1$ = ' num2str(alpha_1) ', I = ' num2str(I)]);
set(h,'Interpreter','Latex')





