function Struct_FHN_HFWave = FitzHughNagumo_HFWave

global N_cells

N_cells=100^2; 
N_cells_rt = 100; 
Delta_x=1.0;
t_start=0; t_sim_end=600.0;dt = 0.05;
t_Thrd = 30 ;




NStep = (t_sim_end - t_start)/dt+1;


j1_mov_ind=1;

y =zeros(1,2*N_cells);


X_Partit = 20;


load('MouseWTParameters');
 

%alpha_1
alpha_1 = 0.0136;
I = 0.015; 
Gamma = 0.5*Gamma;
D_coupling=D_coupling*1.3;
 

% Work out the diffusion matrix (finite difference, forward Euler, square lattice)
A_Laplacian = Make2DLaplacian_LRPeriodic_BTNoFlux(N_cells_rt, Delta_x);

% Work out nullclines and times in PARC
[v_ss w_ss v_min v_max w_min w_max v_plot_1 v_plot_2 v_plot_3 v_plot_4 w_1 w_2 w_3 w_4] = GetSteadyStateAndNullclines;

% Set initial values
% Middle in competent, two sides in refractory
v_inside = 0.5*v_ss;
w_inside = w_ss;
v_outside =  0.5*v_min ;
w_outside =  w_max ;


% Set initial distributions on the lattice
for i=1:N_cells
    x_pos = mod(i-1,sqrt(N_cells));
    y_pos = floor((i-1)/sqrt(N_cells));
    if x_pos <= X_Partit || x_pos >= N_cells_rt - X_Partit
        y(1,i)=v_outside;
        y(1,i+N_cells)=w_outside;
    else
        y(1,i)=v_inside;
        y(1,i+N_cells)=w_inside;
        
        if y_pos <= 5 
            % P
            y(1,i)=v_max;
            y(1,i+N_cells)=w_ss;
            
        end
    
        
        
        
    end
    

    
end

mov_str='FHN_Movie';

SetUpMovieFigure;

CountStruct = 1;

for nstep = 1:1:NStep
    
    Time = (nstep-1)*dt;
    
    

    
    
    %% Right hand side of equations 12 and 13 in Murray et al, PLoS Comp Bio (2013) 
    dy_reac = solve_exc_med_equations_for_pop(y);% deterministic component
    dy_diff = D_coupling/epsilon*(A_Laplacian*y(1:N_cells)')'; % Diffusion term
    norm_var=randn(N_cells,1); % Stochastic term (Euler Muruyama method)
    
    % Add deterministic, diffusion and stochastic components to get
    % total change and use forward Euler
    y = y+(dy_reac+[dy_diff zeros(1,N_cells)])*dt + sqrt(2*Gamma/epsilon^2*dt)*[randn(1,N_cells) zeros(1,N_cells)];
    
    
    if Time < t_Thrd
       
        for i=1:N_cells
            x_pos = mod(i-1,sqrt(N_cells));
            if x_pos <= X_Partit || x_pos >= N_cells_rt - X_Partit
                y(1,i)=v_outside;
                y(1,i+N_cells)=w_outside;
            end
        end
       
    end
   
    if mod(nstep-1,40)==0 
         
        F(j1_mov_ind)=Plot_Act_ForMovie(y,v_min,v_max,w_min,w_max,fig1,winsize,Time );
        j1_mov_ind=j1_mov_ind+1;
        
        
        Struct_FHN_HFWave(CountStruct).y=y;
        Struct_FHN_HFWave(CountStruct).Time = Time;
        CountStruct = CountStruct + 1;
        
        
    end
    
    
end

Struct_FHN_HFWave(CountStruct).v_min = v_min;
Struct_FHN_HFWave(CountStruct).v_max = v_max;
Struct_FHN_HFWave(CountStruct).w_min = w_min;
Struct_FHN_HFWave(CountStruct).w_max = w_max;
Struct_FHN_HFWave(CountStruct).alpha_1 = alpha_1;
Struct_FHN_HFWave(CountStruct).I = I; 
Struct_FHN_HFWave(CountStruct).Gamma = Gamma;
Struct_FHN_HFWave(CountStruct).D_coupling = D_coupling;





movie2avi(F, mov_str ,'fps',10);



