function A = Make2DLaplacian_LRPeriodic_BTNoFlux(N, Delta_x)

%Bottom & Top, no flux
%Left & Right, periodic

A=zeros(N^2,N^2);

for i=1+N:N*(N-1)
    A(i,i)=-4;
    A(i,i+1)=1;
    A(i,i-1)=1;
    A(i,i+N)=1;
    A(i,i-N)=1;
end

% Bottom bdy
for i=2:N-1
    A(i,:)=0;
    A(i,i)=-3;
    A(i,i+1)=1;
    A(i,i-1)=1;
    A(i,i+N)=1;
end

% Top bdy
for i=N*(N-1)+1:N^2-1
    A(i,:)=0;
    A(i,i)=-3;
    A(i,i+1)=1;
    A(i,i-1)=1;
    A(i,i-N)=1;
end

% Left bdy
for i=N+1:N:N*(N-2)+1
    j_left_ind = i+N-1;
    A(i,:)=0;
    A(i,i)=-4;
    A(i,i+1)=1;
    A(i,j_left_ind)=1;
    A(i,i+N)=1;
    A(i,i-N)=1;
end

% Right bdy
for i=2*N:N:N*(N-1)
    j_right_ind = i+1-N;
    A(i,:)=0;
    A(i,i)=-4;
    A(i,j_right_ind)=1;
    A(i,i-1)=1;
    A(i,i+N)=1;
    A(i,i-N)=1;
end

% bottom left corner
i=1;
A(i,:)=0;
A(i,i)=-3;
A(i,i+1)=1;
A(i,i-1+N)=1;
A(i,i+N)=1;

% bottom right corner
i=N;
A(i,:)=0;
A(i,i)=-3;
A(i,i+1-N)=1;
A(i,i-1)=1;
A(i,i+N)=1;

% top left corner
i=N*(N-1)+1;
A(i,:)=0;
A(i,i)=-3;
A(i,i+1)=1;
A(i,i-1+N)=1;
A(i,i-N)=1;

%top right corner
i=N^2;
A(i,:)=0;
A(i,i)=-3;
A(i,i+1-N)=1;
A(i,i-1)=1;
A(i,i-N)=1;



A=A/Delta_x^2;




