function dy = solve_exc_med_equations_for_pop_2Domain(y,I_Mx)
global a b c d J epsilon N_cells

dy=zeros(size(y));

v=y(1:N_cells); 
w=y(N_cells+1:2*N_cells);

f = getactfunshift_vectorahh_tanh_switch(v);


% Calculate the reaction components of the right-hand side
dy(1:N_cells) = 1/epsilon*(f - a*v-b*w+I_Mx);
dy(N_cells+1:2*N_cells) = c*v-d*w+J;
 

end


function f = getactfunshift_vectorahh_tanh_switch(v)
global  alpha_1 alpha_2 v_0 v_1 
    f=zeros(size(v));    

    less_than_v0= tanhswitch(-(v-v_0),0.01);
    
    f_term_1 = (alpha_1*v).*less_than_v0;
    
    gr_than_v1= tanhswitch((v-v_1),0.01);
    
    f_term_2 = (alpha_2*(v_1-v_0)+alpha_1*v_0).*gr_than_v1;
    
    in_the_middle = ones(size(v)) - less_than_v0 - gr_than_v1;

    f_term_3 = (alpha_2*(v-v_0)+alpha_1*v_0).*in_the_middle;

    f = f_term_1+f_term_2+f_term_3; 

    
end

function ret = tanhswitch(x,param)

    ret = 0.5*(tanh(x/param)+1);
end
