function Conc = DeSingleFollicle(Conc, IW, IB, h, A, gamma, BMPAdd ,Str)
 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%     PARAMETERS     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

TimeScale = 1 ;

%Diffusion coefficient  
%DW = 1;
%DB = 6;
DW = 1*TimeScale ;
DB = 1*TimeScale ;
 


%Reaction coefficients 
kWon = 0.3*TimeScale ;
kBon = 0.5*TimeScale ;
kWoff = 0*TimeScale ;
kBoff = 0*TimeScale ;

 
%Degradation coefficients
kWdeg =  2*TimeScale ; 
kBdeg =  4*TimeScale ;
 

%Preservation of receptors
RWtot = 10;
RBtot =  10;
 

 
%computation domain [- Y*dh, 0]
Y =  100;



%Temporal discretizaion
dt = 0.1;

%Spacial discretization
dh = 0.1;

%region I: bulge [  h_I*dh,  h_I*dh + d_I*dh] 
hI = - 10 ;
dI = 5 ;
%region II: sHG/Matrix + DP  [h(t), h(t) + d_II*dh]
dII = 8;





%Noise strength in production  
%GammaW = 800;
%GammaB = 600;
GammaW = 0;
GammaB = 0;





%betaW = 2;
betaW = 4*TimeScale ;
%betaB = 0.2;
betaB = 1  + BMPAdd ;%  + WNTStr*sqrt( dt)*randn;
betaB = betaB*TimeScale ;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 



WL = Conc(:,1);
BL = Conc(:,2);
WLR = Conc(:,3);
BLR = Conc(:,4);
 



DeWL = zeros(Y,1);
DeBL = zeros(Y,1);
DeWLR = zeros(Y,1);
DeBLR = zeros(Y,1);


%reaction, region I

for n = - hI - dI + 1:1:-hI
    DeWL(n) = - kWon*WL(n)*(RWtot - WLR(n)) + kWoff*WLR(n) ;
    DeBL(n) = - kBon*BL(n)*(RBtot - BLR(n)) + kBoff*BLR(n); 
    DeWLR(n) =  kWon*WL(n)*(RWtot - WLR(n)) - (kWoff + kWdeg)*WLR(n) + betaW   +  Str*sqrt( dt)*randn;%Str*sqrt( dt)*randn*WLR(n);
    DeBLR(n) =  kBon*BL(n)*(RBtot - BLR(n)) - (kBoff + kBdeg)*BLR(n) + betaB  +  Str*sqrt( dt)*randn;%Str*sqrt( dt)*randn*BLR(n) ;
%X = - n*dh;
end

 
%production, region II
for n = floor(- h/dh) - dII + 1:1:ceil(- h/dh)
    DeWL(n) =  IW + GammaW*sqrt( dt)*randn ;
    DeBL(n) =  IB + GammaB*sqrt( dt)*randn ;
end


 
I = eye(Y,Y);
 
 
 

Conc(:,1) = max((I + DW*gamma*A) \ (WL + dt*DeWL),0);
Conc(:,2) = max((I + DB*gamma*A) \ (BL + dt*DeBL),0);
Conc(:,3) = max(WLR + dt*DeWLR,0);
Conc(:,4) = max(BLR + dt*DeBLR,0);
 
 
 
 
%for j =1:1:50
%    Ploth(j) = - h/dh +2i*(j-1);
%end


%figure(1)
%clf
%plot(Conc(:,1),'LineWidth',1.5 )
%hold on
%grid on
%set(gca,'XTickLabel',{'0', '-2', '-4', '-6', '-8', '-10'})
%%set(gca,'FontSize',15,'FontWeight','bold');
%xlim([0,100])
%ylim([0,50])
%plot( Conc(:,2),'r','LineWidth',1.5)
%plot( Conc(:,3),'x','MarkerSize',8)
%plot( Conc(:,4),'rx','MarkerSize',8)
%plot(Ploth,'g','LineWidth',1.5 )
%legend('WNT-L','BMP-L','WNT-LR','BMP-LR','h')

%hold off


 
 













