function  PhaseTime = DynamicsSingleFollicle(BMPAdd,Str)%(BMPAdd ,RWTot,RBTot)

%BMPAdd in [-8.5, 4.5], cyclci dynamics
%BMPAdd <-9, humar hair dynamics



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%     PARAMETERS     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Production coefficients 
alphaW1 = 6;%8;
alphaW0 = 1.5 ;
alphaB0 = 0;
alphaB1 = 6;


%Diffusion coefficient  
%DW = 1;
%DB = 6;
DW = 1;
DB = 1;
 



%Temporal discretizaion
dt = 0.1; 

%Geomotry coefficients  
   %spacial discretization
   dh = 0.1;
   %computation domain [- Y*dh, 0]
   Y =  100;
   %region I: bulge [  h_I*dh,  h_I*dh + d_I*dh] 
   hI = - 10 ;
   dI = 5 ;
   %region II: sHG/Matrix + DP  [h(t), h(t) + d_II*dh]
   dII = 8;
   %max/min length of the follicle
   hmin = (hI - dII)*dh;
   hmax = - 60*dh;


%Error allowence in computation
err = 0.005;

TimeScale = 1 ;
 
%Threshold of concentration differnece
DeltaT = 1.5;%0.8;
 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%  PREPARATION  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 


%%%%%%%%%%%%%%%%%%%%%%%%%%%%  TIME  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 



Time = [1,1];
%Time = (t, +/-)
%Time(1) gives the time in the current phase: t - t^+ or t - t^-
%Time(2) gives the current time phase:
%Time(2) = 1: phase+, t^+ <= t < t^-
%Time(2) = -1: phase-, t^- <= t < next t^+



%%%%%%%%%%%%%%%%%%%%%%%% CONCENTRATION %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Conc = zeros(Y,4);
%Row 1 -- WNT_L, Row 2 -- BMP_L
%Row 3 -- WNT_LR, Row 4 -- BMP_LR, vanish outside reigion I

%%%%%%%%%%%%%%%%%%%%%%% FOLLICLE LENGTH %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 

h = hmin;

%%%%%%%%%%%%%%%%%%%%%%%%%%% Laplace %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

A = 2*eye(Y,Y) - diag(diag(eye(Y-1,Y-1)),-1) - diag(diag(eye(Y-1,Y-1)), 1);
A(1,1) =  1;
A(1,2) =  -1;

gamma = dt/(dh)^2;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



NStep = 2000;


FollicleH = zeros(1,NStep);
AveWNT = zeros(1,NStep);
AveBMP = zeros(1,NStep);
PicTime = zeros(1,NStep);
PicIW = zeros(1,NStep);
PicIB = zeros(1,NStep);


%PhaseTime = zeros(1,4);
PhaseTime = 0;
CountTime = 1;
nstep = 1;


 

%WNTStr = 0;

%for nstep = 1:1:NStep
%while CountTime <= 42  
while nstep <= 2500
    
  % if nstep == 6000 && CountTime <= 2
  %     CountTime = 41;
  % end
       
    if nstep == 8000
        %CountTime
        if CountTime <= 2
            CountTime = 43;
        end
    end
    
   % if nstep == 800
   %     BMPAdd = 8;
   % else BMPAdd = -15;
   % end
     
    
    %current production rate
    if Time(2) > 0 
        %phase+
        IW = alphaW1*( - hmax + h )/(- hmax + hmin) +3 ;
    else
        %phase-
        IW = alphaW0;
    end
    
    IW = IW*TimeScale ;

    
    IB = alphaB0 + alphaB1*( -h  + hmin + dI*dh);
 
    IB = IB*TimeScale ;
    
    
    %update concentrations
    Conc = DeSingleFollicle(Conc, IW, IB, h, A, gamma,BMPAdd ,Str );
    
    AveConc = ConcDiff(Conc, hI, dI );
    Delta = AveConc(3);
    
    %update follicle length
    h = DeFollicleLength(h, Time, dt, hmax, hmin);
    
    %record
    FollicleH(nstep) = h;
    AveWNT(nstep) = AveConc(1);
    AveBMP(nstep) = AveConc(2);
    PicTime(nstep) = (nstep - 1)*dt;
    PicIW(nstep) = IW;
    PicIB(nstep) = IB;
    
    %if nstep <= 500
    %    MovieSingleFollicle(nstep) = getframe(gcf);
    %end
    
    
    %update Time
    
   % if PicTime(nstep) >=48
   %     WNTStr = 8;
   % end
     
    
    if h <= hmin - dh && Delta < - err && Time(2) > 0
        %if CountTime <= 4
            PhaseTime(CountTime) = Time(1)*dt;
        %end
        CountTime = CountTime + 1;
      
        %time phase turns from + to -
        Time(1) = 0;
        Time(2) = -1;
    end
    
    if h >= hmin - err && Delta >= DeltaT && Time(2) <0
        %if CountTime <= 4
            PhaseTime(CountTime) = Time(1)*dt;
        %end

        CountTime = CountTime + 1 ;
 
        %starts a new cycle
        Time(1) = 0;
        Time(2) = 1;
    end
    
    Time(1) = Time(1) + 1;
    
    nstep = nstep + 1;
     
end
 
%PhaseTime = PhaseTime*dt*1.6; 
%PicTime = PicTime*1.6;
 
     
figure(1)
clf
set(gca,'FontSize',20,'FontWeight','bold');
 
%hold on
%grid on
 
xlim([20,80])
%%ylim([-8, 10])
plot(PicTime,PicIW,'g','LineWidth',2.5)
hold on
plot(PicTime,PicIB,'r','LineWidth',2.5)
legend('Act-L','Inh-L','Location','NorthWest')
%%StrTitle = sprintf('DB/DW = %g', DB/DW);
title('Net Production of Ligands')
xlabel('Time')
%hold off
 
 



%figure(3)
%clf
%set(gca,'FontSize',15,'FontWeight','bold');
%plot(PicTime(1:1500), FollicleH(1:1500), 'LineWidth',5 )
%hold on
%grid on
%TimeLim = floor(max(PicTime));
%xlim([0,TimeLim])
%%xlim([0,160])
%%xlim([40,90])
%ylim([-8, 10])
%plot(PicTime(1:1500),AveWNT(1:1500), 'g','LineWidth',5)
%plot(PicTime(1:1500),AveBMP(1:1500),'r','LineWidth',5)
%%legend('follicle','WNT-LR','BMP-LR','Location','NorthEast')
%%StrTitle = sprintf('DB/DW = %g', DB/DW);
%%title(StrTitle )
%%title('(Single) Follicle Growth Cycles')
%StrTitle = sprintf(' = %g', BMPAdd);
%title(['\beta +',StrTitle])
%xlabel('Time')
%hold off

 
    
figure(3)
clf
set(gca,'FontSize',15,'FontWeight','bold');
plot(PicTime, FollicleH,'LineWidth',2.5 )
hold on
%grid on

xlim([0,150])
ylim([-8, 10])
plot(PicTime,AveWNT,'g','LineWidth',2.5)
plot(PicTime,AveBMP,'r','LineWidth',2.5)
%plot(PicTime,AveWNT - AveBMP,'k','LineWidth',2.5)
%legend('WNT-LR','BMP-LR','Location','NorthEast')
%StrTitle = sprintf('DB/DW = %g', DB/DW);
%title(StrTitle )
%title('Concentration of Ligand-bond Receptors')
xlabel('Time')
hold off

 





%movie2avi(MovieSingleFollicle,'SingleFollicle')


 