%{
    Calculates PSTH for spike train x wrt input y. Here y is time of release
    from inhibition - i.e., beginning of "trough phase" of inhibition.

    EDIT: so this was kinda unnecessary since histogram() does this anyway. But at least
    I found out that the below method is exactly how histogram() calculates bins (using round() of
    differentials).

    psth_struct contains
        * 'psth'
        * 'bintimes'
        * 'diffs'
%}
function psth_struct = calc_psth(x, y, freq, verbose)
    if nargin < 4
        verbose = 0;
    end

    binsize = 5; % ms
    cycles = 1;  % # of cycles

    lookahead = 1e3/freq * cycles;
    total_bins = floor(lookahead / binsize);
    if verbose
        disp(sprintf('total_bins %d', total_bins));
    end

    diffs = [];
    psth = zeros(1, total_bins);
    for i=1:length(y)
        spike_differential = x - y(i);
        poststimulus_spikes = find(spike_differential <= lookahead & spike_differential >= 0);
        poststimulus_differentials = x(poststimulus_spikes) - y(i);
        diffs = [diffs poststimulus_differentials];
        spike_bins = round(poststimulus_differentials / binsize);

        if ~isempty(spike_bins)

            % If rounded differentials make spike_bins go to 0 or one beyond the max, just put them in 
            % respectively the first or last bins.
            zero_bins = (spike_bins==0);
            if ~isempty(zero_bins)
                spike_bins(zero_bins) = 1;
                if verbose
                    disp(sprintf('*** Have zero bins! i=%d', i));
                end
            end
            max_bins = spike_bins>total_bins;
            if ~isempty(max_bins)
                spike_bins(max_bins) = total_bins;
                if verbose
                    disp(sprintf('*** Have max bins! i=%d', i));
                end
            end
            psth(spike_bins) = psth(spike_bins) + 1;
        end
    end

    bintimes = zeros(1, total_bins);
    cur_time = binsize;
    for i=1:total_bins
        bintimes(i) = cur_time;
        cur_time = cur_time + binsize;
    end
    psth_struct = struct('psth',psth,'bintimes',bintimes,'diffs',diffs);
end
