%{

Plots <whatever> for models across desired modulation frequencies.

Where <whatever> is one of rotation number, (meas_struct), vector strength (VS_struct),
or angular mean (am_struct).

%}
function cns2016_plot_measure(first, second, meas_name, fileloc)

if nargin < 4
    fileloc = '';
end

phd_exc_load_mod; % to get mo and mf

f=figure;
hold on;
dmf=4:16;
y1=nanmedian(first(:,dmf),1)
y2=nanmedian(second(:,dmf),1);

e_first=std(first(:,dmf),1);
e_second=std(second(:,dmf),1);
Nfreqs=length(y1);

errorbar(1:Nfreqs, y1, e_first, 'b+-');
errorbar(1:Nfreqs, y2, e_second, 'r+-');
plot(y1,'b+-','LineWidth',2);
plot(y2,'r+-','LineWidth',2);

X = phd_exc_load_plotting(size(first,1), Nfreqs);
scatter(X, reshape(first(:,dmf), [1 size(first,1)*size(first(:,dmf),2)]),7,'b');
scatter(X, reshape(second(:,dmf), [1 size(second,1)*size(second(:,dmf),2)]),7,'r');

legend({'Somatic I_h', 'Somatodendritic I_h'});

set(gca,'FontSize',16);
set(gca,'XTick',1:Nfreqs);
set(gca,'XTickLabel',{'2','3','4','5','8','9','10','12','15','16','20','25','30'});
set(gca,'XTickLabelRotation',-45);
%title('Rotation number');
%ylim([0:1]);
%ylabel(sprintf('Ratio of mod frequency power to 0Hz power'));
ylabel(meas_name);
xlabel('Modulation frequencies (Hz)');

if fileloc
    if ~win
        filename = sprintf('rotn_%g_%s.png', desired_modulation, title_str);
    else
        filename = sprintf('rotn_win_%g_%s.png', desired_modulation, title_str);
    end
    disp(sprintf('PRINTING to file %s', filename));
    print(f, sprintf('%s/%s', fileloc, filename), '-dpng');
end

end
