%{

    ranks is an array of ranks to process; ignore everything else. Facilitates splitting the work into 
    multiple MATLAB instances to save memory.

%}
function [models] = conds_load_all_new(topdir, prefix_str, set_no, desired_ranks, fileloc_prefix)

rank_idx = 1;
ranks = [];
hoc = '';
Ihact_sets = [1, 2, 12];
jobs_sequence = [1, 2, 3];
mfs = [3, 5, 8, 12];

%
% Get PSDs for all models.
%
cd(topdir);
cd(prefix_str);
disp(sprintf('*** PROCESSING PREFIX %s', prefix_str));
pwd

for rank_idx=1:length(desired_ranks)
    rank = desired_ranks(rank_idx);

    for i=1:length(Ihact_sets)
        Ihact = Ihact_sets(i);
        job_num = jobs_sequence(i);

        current_model_dir = sprintf('scen5_Ihact%d_%d_%d_%d', Ihact, set_no, rank, job_num);
        cd(current_model_dir);
        disp(sprintf('*** Processing model dir %s', current_model_dir));

        outfile_dir = './dev/shm/vsekulic/O-LM_runs/';
        cd(outfile_dir);

        outfiles = dir('*.dat');
        pwd
        for j=1:length(outfiles)
            model_name = outfiles(j).name;

            % Stupidly have to separately deal with Ihact1
            if i == 1
                model_format = 'R3_somadend_rank%d_h_%g_excw_%g_inhw_%g_tstop_%d_modfreq_%g_modulation_%g_injclamp_%d.dat';

                disp(sprintf('    *** Processing outfile %s', model_name));
                A = sscanf(model_name, model_format);
                modfreq = A(6);
                mf = find(mfs == modfreq);
                Ihact_val = 1;
                h = A(2);
            else
                model_format = 'R3_somadend_rank%d_Ihact%d_h_%g_excw_%g_inhw_%g_tstop_%d_modfreq_%g_modulation_%g_injclamp_%d.dat';

                disp(sprintf('    *** Processing outfile %s', model_name));
                A = sscanf(model_name, model_format);
                modfreq = A(7);
                mf = find(mfs == modfreq);
                Ihact_val = A(2);
                h = A(3);
            end 


            % Are we in a new rank?
            find_idx = find(ranks == rank);
            if find_idx
                rank_idx = find_idx;
            else
                rank_idx = length(ranks) + 1;
                ranks(rank_idx) = rank;
                disp(sprintf('    *** NEW RANK %d, assigning new rank_idx = %d, length(ranks)==%d\n', rank, rank_idx, length(ranks)));
            end

            d = pwd;
            models(rank_idx).rank = rank;
            models(rank_idx).mf(mf).ihact(i).Ihact = Ihact;
            if h ~= 0
                models(rank_idx).mf(mf).ihact(i).data = struct('dir', d, 'model_name', model_name, 'Ihact', Ihact_val, 'h', h);
                models(rank_idx).mf(mf).mf = modfreq;
            else
                models(rank_idx).mf(mf).ihact(i).data_blh = struct('dir', d, 'model_name', model_name, 'Ihact', Ihact_val, 'h', h);
                models(rank_idx).mf(mf).mf = modfreq;
            end
        end

        cd('../../../../../');
    end

end

%{
    for i=1:length(models)
        for mo_idx=1:length(models(i).mod.mo)
            for j=length(models(i).mod.mo(mo_idx).mf)+1:length(mf)
                models(i).mod.mo(mo_idx).mf(j).psd = [];
            end
        end
    end
%}
end
